/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.CountedList;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.DefIndex;
import com.reandroid.dex.data.DirectoryEntry;
import com.reandroid.dex.key.Key;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.util.Iterator;
import java.util.function.Predicate;

public class DirectoryMap<DEFINITION extends DefIndex, VALUE extends DataItem>
extends CountedList<DirectoryEntry<DEFINITION, VALUE>>
implements Iterable<DirectoryEntry<DEFINITION, VALUE>> {
    public DirectoryMap(IntegerReference itemCount, Creator<DirectoryEntry<DEFINITION, VALUE>> creator) {
        super(itemCount, creator);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean sort() {
        return super.sort(CompareUtil.getComparableComparator());
    }

    public void add(DEFINITION definition, VALUE value) {
        if (!this.contains(definition, value)) {
            DirectoryEntry entry = (DirectoryEntry)this.createNext();
            entry.set(definition, value);
        }
    }

    @Override
    public boolean contains(DEFINITION definition) {
        return this.getEntries(definition).hasNext();
    }

    public boolean contains(DEFINITION definition, VALUE value) {
        Iterator<DirectoryEntry<DEFINITION, VALUE>> iterator = this.getEntries(definition);
        while (iterator.hasNext()) {
            if (!iterator.next().equalsValue(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(DEFINITION definition, Key valueKey) {
        Iterator<DirectoryEntry<DEFINITION, VALUE>> iterator = this.getEntries(definition);
        while (iterator.hasNext()) {
            if (!iterator.next().matchesValue(valueKey)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Key definitionKey, Key valueKey) {
        Iterator<DirectoryEntry<DEFINITION, VALUE>> iterator = this.getEntries(definitionKey);
        while (iterator.hasNext()) {
            if (!iterator.next().matchesValue(valueKey)) continue;
            return true;
        }
        return false;
    }

    public void remove(DEFINITION definition) {
        super.remove(entry -> entry.equalsDefIndex((DefIndex)definition));
    }

    public void remove(DEFINITION definition, Predicate<VALUE> filter) {
        super.remove(entry -> entry.equalsDefIndex((DefIndex)definition) && filter.test(entry.getValue()));
    }

    public void link(DEFINITION definition) {
        for (DirectoryEntry entry : this) {
            entry.link(definition);
        }
    }

    public Iterator<VALUE> getValues(int definitionIndex) {
        return ComputeIterator.of(this.getEntries((DEFINITION)definitionIndex), DirectoryEntry::getValue);
    }

    public Iterator<DirectoryEntry<DEFINITION, VALUE>> getEntries(int definitionIndex) {
        return FilterIterator.of(this.iterator(), entry -> entry.equalsDefIndex(definitionIndex));
    }

    public Iterator<VALUE> getValues(DEFINITION definition) {
        return ComputeIterator.of(this.getEntries(definition), DirectoryEntry::getValue);
    }

    public Iterator<VALUE> getValues() {
        return ComputeIterator.of(this.iterator(), DirectoryEntry::getValue);
    }

    public Iterator<DirectoryEntry<DEFINITION, VALUE>> getEntries(DEFINITION definition) {
        return FilterIterator.of(this.iterator(), entry -> entry.equalsDefIndex((DefIndex)definition));
    }

    public Iterator<DirectoryEntry<DEFINITION, VALUE>> getEntries(Key definitionKey) {
        return FilterIterator.of(this.iterator(), entry -> entry.matchesDefinition(definitionKey));
    }

    @Override
    public int countBytes() {
        return this.getCount() * 8;
    }

    public void merge(DirectoryMap<DEFINITION, VALUE> directoryMap) {
        if (directoryMap == this) {
            return;
        }
        int size = directoryMap.size();
        this.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            DirectoryEntry coming = (DirectoryEntry)directoryMap.get(i);
            DirectoryEntry item = (DirectoryEntry)this.createNext();
            item.merge(coming);
        }
    }
}

