/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.DexBlockItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.DefIndex;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import java.io.IOException;
import java.util.Objects;

public class DirectoryEntry<DEFINITION extends DefIndex, VALUE extends DataItem>
extends DexBlockItem
implements BlockRefresh,
Comparable<DirectoryEntry<?, ?>> {
    private final SectionType<VALUE> sectionType;
    private DEFINITION mDefinition;
    private VALUE mValue;
    private Key mDefinitionKey;
    public static final int SIZE = 8;

    public DirectoryEntry(SectionType<VALUE> sectionType) {
        super(8);
        this.sectionType = sectionType;
    }

    public int getDefinitionIndexValue() {
        return DirectoryEntry.getInteger(this.getBytesInternal(), 0);
    }

    public void setDefinitionIndexValue(int value) {
        if (value == this.getDefinitionIndexValue()) {
            return;
        }
        DirectoryEntry.putInteger(this.getBytesInternal(), 0, value);
    }

    public int getValueOffset() {
        return DirectoryEntry.getInteger(this.getBytesInternal(), 4);
    }

    public void setValueOffset(int value) {
        DirectoryEntry.putInteger(this.getBytesInternal(), 4, value);
    }

    public DEFINITION getDefinition() {
        return this.mDefinition;
    }

    public void link(DEFINITION definition) {
        if (definition == null || this.mDefinition != null) {
            return;
        }
        Key key = this.getDefinitionKey();
        if (key != null) {
            if (key.equals(definition.getKey())) {
                this.mDefinition = definition;
                this.setDefinitionIndexValue(definition.getDefinitionIndex());
            }
        } else if (this.getDefinitionIndexValue() == definition.getDefinitionIndex()) {
            this.mDefinition = definition;
        }
    }

    public void setDefinition(DEFINITION definition) {
        this.mDefinition = definition;
        Key key = null;
        if (definition != null) {
            key = definition.getKey();
        }
        this.setDefinitionKey(key);
    }

    public Key getDefinitionKey() {
        DEFINITION definition = this.getDefinition();
        if (definition != null) {
            this.mDefinitionKey = definition.getKey();
        }
        return this.mDefinitionKey;
    }

    public void setDefinitionKey(Key key) {
        this.mDefinitionKey = key;
    }

    public VALUE getValue() {
        return this.mValue;
    }

    public void setValue(Key key) {
        Section<VALUE> section = this.getOrCreateSection(this.sectionType);
        DexSectionPool<VALUE> pool = section.getPool();
        DataItem value = (DataItem)pool.getOrCreate(key);
        this.setValue(value);
    }

    public void setValue(VALUE value) {
        this.mValue = value;
        int offset = 0;
        if (value != null) {
            offset = ((SectionItemContainer)value).getOffset();
        }
        this.setValueOffset(offset);
    }

    public void set(DEFINITION definition, VALUE value) {
        this.setDefinition(definition);
        this.setValue(value);
    }

    public Key getValueKey() {
        VALUE value = this.getValue();
        if (value != null) {
            return ((DataItem)value).getKey();
        }
        return null;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.cacheItem();
    }

    private void cacheItem() {
        this.mValue = (DataItem)this.getSectionItem(this.sectionType, this.getValueOffset());
        if (this.mValue != null) {
            ((SectionItem)this.mValue).addUsageType(UsageMarker.USAGE_ANNOTATION);
        }
    }

    @Override
    public void refresh() {
        DEFINITION definition = this.getDefinition();
        if (definition != null) {
            this.setDefinitionIndexValue(definition.getDefinitionIndex());
        }
        VALUE value = this.refreshValue();
        int offset = 0;
        if (value != null) {
            offset = ((SectionItemContainer)value).getOffset();
        }
        this.setValueOffset(offset);
    }

    private VALUE refreshValue() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        value = (DataItem)((SectionItem)value).getReplace();
        this.mValue = value;
        if (value != null) {
            ((SectionItem)value).addUsageType(UsageMarker.USAGE_ANNOTATION);
        }
        return value;
    }

    public boolean equalsDefIndex(int defIndex) {
        return this.getDefinitionIndexValue() == defIndex;
    }

    public boolean equalsDefIndex(DefIndex defIndex) {
        if (defIndex == null) {
            return false;
        }
        DEFINITION definition = this.getDefinition();
        if (definition != null) {
            return definition == defIndex;
        }
        return false;
    }

    public boolean equalsValue(VALUE value) {
        return Objects.equals(this.getValue(), value);
    }

    public boolean matchesDefinition(Key definitionKey) {
        return Objects.equals(this.getDefinitionKey(), definitionKey);
    }

    public boolean matchesValue(Key key) {
        return Objects.equals(this.getValueKey(), key);
    }

    @Override
    public int compareTo(DirectoryEntry<?, ?> entry) {
        return DirectoryEntry.compareDefIndex(this.getDefinition(), entry.getDefinition());
    }

    public void merge(DirectoryEntry<DEFINITION, VALUE> entry) {
        if (entry == this) {
            return;
        }
        this.setDefinitionKey(entry.getDefinitionKey());
        this.setValue(entry.getValueKey());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectoryEntry entry = (DirectoryEntry)obj;
        return Objects.equals(this.getDefinitionKey(), entry.getDefinitionKey()) && Objects.equals(this.getValue(), entry.getValue());
    }

    public int hashCode() {
        int hash = 1;
        Key obj = this.getDefinitionKey();
        hash *= 31;
        if (obj != null) {
            hash += obj.hashCode();
        }
        obj = this.getValue();
        hash *= 31;
        if (obj != null) {
            hash += obj.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        DEFINITION definition = this.getDefinition();
        if (definition != null) {
            builder.append(definition.getKey());
        } else {
            builder.append(this.getDefinitionIndexValue());
        }
        builder.append(" (");
        VALUE value = this.getValue();
        if (value != null) {
            builder.append(value);
        } else {
            builder.append(this.getValueOffset());
        }
        builder.append(')');
        return builder.toString();
    }

    public static int compareDefIndex(DefIndex defIndex1, DefIndex defIndex2) {
        if (defIndex1 == defIndex2) {
            return 0;
        }
        if (defIndex1 == null) {
            return 1;
        }
        if (defIndex2 == null) {
            return -1;
        }
        return Integer.compare(defIndex1.getDefinitionIndex(), defIndex2.getDefinitionIndex());
    }
}

