/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.EditableItem;
import com.reandroid.dex.common.IdUsageIterator;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public abstract class DefArray<T extends Def<?>>
extends BlockList<T>
implements Iterable<T>,
EditableItem,
SmaliFormat,
IdUsageIterator {
    private final IntegerReference itemCount;
    private ClassId mClassId;

    public DefArray(IntegerReference itemCount, Creator<T> creator) {
        super(creator);
        this.itemCount = itemCount;
    }

    @Override
    public boolean remove(T def) {
        boolean removed;
        AnnotationsDirectory directory = this.getUniqueAnnotationsDirectory();
        if (directory != null) {
            directory.remove((Def<?>)def);
        }
        if (removed = super.remove(def)) {
            this.resetIndex();
            if (directory != null) {
                this.sortAnnotations();
            }
        }
        this.updateCount();
        return removed;
    }

    @Override
    public final boolean sort(Comparator<? super T> comparator) {
        if (!this.needsSort(comparator)) {
            this.sortAnnotations();
            return false;
        }
        this.onPreSort();
        boolean changed = super.sort(comparator);
        this.onPostSort();
        return changed;
    }

    void onPreSort() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            classId.getUniqueAnnotationsDirectory();
        }
        this.linkAnnotation();
    }

    void onPostSort() {
        this.resetIndex();
        this.sortAnnotations();
    }

    void sortAnnotations() {
    }

    public T getOrCreate(Key key) {
        Object item = this.get(key);
        if (item != null) {
            return item;
        }
        item = this.createNext();
        ((Def)item).setKey(key);
        return item;
    }

    public T get(Key key) {
        for (Def def : this) {
            if (!key.equals(def.getKey())) continue;
            return (T)def;
        }
        return null;
    }

    @Override
    public T createNext() {
        Def item = (Def)super.createNext();
        this.updateCount();
        return (T)item;
    }

    private ClassId searchClassId() {
        ClassId classId = this.mClassId;
        if (classId != null) {
            return classId;
        }
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            classId = ((Def)iterator.next()).getClassId();
        }
        return classId;
    }

    public ClassId getClassId() {
        return this.mClassId;
    }

    public void setClassId(ClassId classId) {
        if (this.mClassId == classId) {
            return;
        }
        this.mClassId = classId;
        if (classId != null) {
            this.linkAnnotation();
        }
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.linkAnnotation();
        boolean sorted = this.sort(CompareUtil.getComparatorUnchecked());
        if (!sorted) {
            this.resetIndex();
        }
    }

    @Override
    protected void onRefreshed() {
        this.updateCount();
    }

    private void updateCount() {
        this.itemCount.set(this.getCount());
    }

    public ClassData getClassData() {
        return (ClassData)this.getParent();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.setSize(this.itemCount.get());
        super.readChildes(reader);
    }

    private void linkAnnotation() {
        if (this.getCount() == 0) {
            return;
        }
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory == null) {
            return;
        }
        for (Def def : this) {
            directory.link(def);
        }
    }

    AnnotationsDirectory getAnnotationsDirectory() {
        ClassId classId = this.searchClassId();
        if (classId == null) {
            return null;
        }
        return classId.getAnnotationsDirectory();
    }

    AnnotationsDirectory getUniqueAnnotationsDirectory() {
        ClassId classId = this.searchClassId();
        if (classId == null) {
            return null;
        }
        return classId.getUniqueAnnotationsDirectory();
    }

    private void resetIndex() {
        for (Def def : this) {
            def.resetIndex();
        }
    }

    public void replaceKeys(Key search, Key replace) {
        for (Def def : this) {
            def.replaceKeys(search, replace);
        }
    }

    @Override
    public void editInternal(Block user) {
        for (Def def : this) {
            def.editInternal(user);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<Def<?>, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(Def<?> element) {
                return element.usedIds();
            }
        };
    }

    public void merge(DefArray<?> defArray) {
        int count = defArray.getCount();
        this.setSize(count);
        for (int i = 0; i < count; ++i) {
            Def coming = (Def)defArray.get(i);
            ((Def)this.get(i)).merge(coming);
        }
        this.itemCount.set(count);
        this.linkAnnotation();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        for (Def def : this.getChildes()) {
            def.append(writer);
            writer.newLine();
        }
    }
}

