/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.EditableItem;
import com.reandroid.dex.common.HiddenApiFlag;
import com.reandroid.dex.common.IdDefinition;
import com.reandroid.dex.common.IdUsageIterator;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.DefArray;
import com.reandroid.dex.data.DefIndex;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public abstract class Def<T extends IdItem>
extends FixedDexContainerWithTool
implements IdDefinition<T>,
EditableItem,
Comparable<Def<T>>,
SmaliRegion,
DefIndex,
IdUsageIterator {
    private final SectionType<T> sectionType;
    private final Ule128Item relativeId;
    private final Ule128Item accessFlags;
    private T mDefId;
    private int mCachedIndex;
    private boolean mCachedIndexUpdated;
    private HiddenApiFlagValue hiddenApiFlagValue;

    public Def(int childesCount, SectionType<T> sectionType) {
        super(childesCount + 2);
        this.sectionType = sectionType;
        this.relativeId = new Ule128Item(true);
        this.accessFlags = new Ule128Item();
        this.addChild(0, this.relativeId);
        this.addChild(1, this.accessFlags);
    }

    @Override
    public Iterator<? extends Modifier> getModifiers() {
        return CombiningIterator.two(this.getAccessFlags(), this.getHiddenApiFlags());
    }

    public Iterator<HiddenApiFlag> getHiddenApiFlags() {
        HiddenApiFlagValue flagValue = this.getHiddenApiFlagValue();
        if (flagValue != null) {
            return flagValue.getFlags();
        }
        return EmptyIterator.of();
    }

    public HiddenApiFlagValue getHiddenApiFlagValue() {
        return this.hiddenApiFlagValue;
    }

    public void setHiddenApiFlagValue(HiddenApiFlagValue hiddenApiFlagValue) {
        this.hiddenApiFlagValue = hiddenApiFlagValue;
    }

    public void removeSelf() {
        DefArray<Def<Def>> array = this.getParentArray();
        if (array != null) {
            array.remove(this);
        }
    }

    void onRemove() {
        this.mCachedIndexUpdated = true;
        this.mDefId = null;
        this.relativeId.set(0);
    }

    @Override
    public Key getKey() {
        T item = this.getId();
        if (item != null) {
            return ((IdItem)item).getKey();
        }
        return null;
    }

    public void setKey(Key key) {
        this.setItem(key);
    }

    public AnnotationSet getOrCreateAnnotationSet() {
        AnnotationSet annotationSet = CollectionUtil.getFirst(this.getAnnotations());
        if (annotationSet != null) {
            return annotationSet;
        }
        AnnotationsDirectory directory = this.getOrCreateUniqueAnnotationsDirectory();
        annotationSet = directory.createSectionItem(SectionType.ANNOTATION_SET);
        directory.addAnnotation(this, annotationSet);
        return annotationSet;
    }

    public void addAnnotationSet(AnnotationSet annotationSet) {
        AnnotationsDirectory directory = this.getOrCreateUniqueAnnotationsDirectory();
        this.addAnnotationSet(directory, annotationSet);
    }

    void addAnnotationSet(AnnotationsDirectory directory, AnnotationSet annotationSet) {
        directory.addAnnotation(this, annotationSet);
    }

    public Iterator<AnnotationSet> getAnnotations() {
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            return directory.getAnnotations(this);
        }
        return EmptyIterator.of();
    }

    public AnnotationsDirectory getAnnotationsDirectory() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getAnnotationsDirectory();
        }
        return null;
    }

    public AnnotationsDirectory getOrCreateUniqueAnnotationsDirectory() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getOrCreateUniqueAnnotationsDirectory();
        }
        return null;
    }

    public AnnotationsDirectory getUniqueAnnotationsDirectory() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getUniqueAnnotationsDirectory();
        }
        return null;
    }

    public ClassId getClassId() {
        ClassId classId;
        DefArray<Def<T>> array = this.getParentArray();
        if (array != null && (classId = array.getClassId()) != null) {
            return classId;
        }
        SectionList sectionList = this.getSectionList();
        if (sectionList == null || sectionList.isReading()) {
            return null;
        }
        TypeKey defining = this.getDefining();
        if (defining == null) {
            return null;
        }
        DexSectionPool<ClassId> pool = this.getPool(SectionType.CLASS_ID);
        if (pool == null) {
            return null;
        }
        ClassId classId2 = (ClassId)pool.get(defining);
        if (classId2 == null) {
            return null;
        }
        ClassData classData = this.getClassData();
        if (classData == null) {
            return null;
        }
        classData.setClassId(classId2);
        return classId2;
    }

    public TypeKey getDefining() {
        Key key = this.getKey();
        if (key != null) {
            return key.getDeclaring();
        }
        return null;
    }

    public int getRelativeIdValue() {
        return this.relativeId.get();
    }

    @Override
    public int getAccessFlagsValue() {
        return this.accessFlags.get();
    }

    @Override
    public void setAccessFlagsValue(int value) {
        this.accessFlags.set(value);
    }

    public boolean isPrivate() {
        return AccessFlag.PRIVATE.isSet(this.getAccessFlagsValue());
    }

    public boolean isNative() {
        return AccessFlag.NATIVE.isSet(this.getAccessFlagsValue());
    }

    public boolean isStatic() {
        return AccessFlag.STATIC.isSet(this.getAccessFlagsValue());
    }

    public boolean isFinal() {
        return AccessFlag.FINAL.isSet(this.getAccessFlagsValue());
    }

    public boolean isConstructor() {
        return AccessFlag.CONSTRUCTOR.isSet(this.getAccessFlagsValue());
    }

    public boolean isDirect() {
        return false;
    }

    @Override
    public T getId() {
        return this.mDefId;
    }

    void setItem(Key key) {
        Object item = this.getId();
        if (item != null && key.equals(((IdItem)item).getKey())) {
            return;
        }
        item = (IdItem)this.getOrCreateSection(this.sectionType).getOrCreate(key);
        this.setItem(item);
    }

    void setItem(T item) {
        this.mDefId = item;
        this.updateIndex();
    }

    @Override
    public int getDefinitionIndex() {
        if (!this.mCachedIndexUpdated) {
            this.mCachedIndexUpdated = true;
            this.mCachedIndex = this.calculateDefinitionIndex();
        }
        return this.mCachedIndex;
    }

    private int calculateDefinitionIndex() {
        Def previous;
        DefArray<Def<T>> parentArray = this.getParentArray();
        if (parentArray != null && (previous = (Def)parentArray.get(this.getIndex() - 1)) != null) {
            return this.getRelativeIdValue() + previous.getDefinitionIndex();
        }
        return this.relativeId.get();
    }

    private int getPreviousIdIndex() {
        Def previous;
        DefArray<Def<T>> parentArray = this.getParentArray();
        if (parentArray != null && (previous = (Def)parentArray.get(this.getIndex() - 1)) != null) {
            return previous.getDefinitionIndex();
        }
        return 0;
    }

    private ClassData getClassData() {
        DefArray<Def<T>> array = this.getParentArray();
        if (array != null) {
            return array.getClassData();
        }
        return null;
    }

    private DefArray<Def<T>> getParentArray() {
        return (DefArray)this.getParent();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.cacheItem();
    }

    private void cacheItem() {
        this.mDefId = (IdItem)this.getSectionItem(this.sectionType, this.getDefinitionIndex());
        if (this.mDefId != null) {
            ((SectionItem)this.mDefId).addUsageType(IdItem.USAGE_DEFINITION);
        }
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateIndex();
    }

    private void updateIndex() {
        this.resetIndex();
        Object item = this.mDefId;
        item = (IdItem)((SectionItem)item).getReplace();
        this.mDefId = item;
        int index = this.getPreviousIdIndex();
        index = ((Block)item).getIndex() - index;
        this.relativeId.set(index);
        ((SectionItem)item).addUsageType(IdItem.USAGE_DEFINITION);
    }

    void resetIndex() {
        this.mCachedIndexUpdated = false;
    }

    public void replaceKeys(Key search, Key replace) {
        Key key2;
        Key key = this.getKey();
        if (key != (key2 = key.replaceKey(search, replace))) {
            this.setItem(key2);
        }
    }

    @Override
    public void editInternal(Block user) {
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return SingleIterator.of(this.getId());
    }

    public void merge(Def<?> def) {
        this.setItem(def.getKey());
        this.setAccessFlagsValue(def.getAccessFlagsValue());
    }

    @Override
    public int compareTo(Def<T> other) {
        if (other == null) {
            return -1;
        }
        return SectionTool.compareIdx(this.getId(), other.getId());
    }
}

