/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.OffsetReceiver;
import com.reandroid.dex.base.PositionedItem;
import com.reandroid.dex.common.IdUsageIterator;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItem;
import com.reandroid.dex.key.KeyItemCreate;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.util.Iterator;

public class DataItem
extends SectionItemContainer
implements PositionedItem,
OffsetSupplier,
OffsetReceiver,
KeyItem,
IdUsageIterator {
    private Block mUniqueUser;
    private boolean mShared;

    public DataItem(int childesCount) {
        super(childesCount);
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return EmptyIterator.of();
    }

    @Override
    public void setReplace(SectionItem replace) {
        super.setReplace(replace);
        replace = this.getReplace();
        if (replace != null && replace != this) {
            ((DataItem)replace).addUniqueUser(this.mUniqueUser);
        }
    }

    public void copyFrom(DataItem item) {
        if (item == null) {
            return;
        }
        if (this instanceof KeyItemCreate) {
            KeyItemCreate self = (KeyItemCreate)((Object)this);
            self.setKey(((KeyItemCreate)((Object)item)).getKey());
            return;
        }
        BlockReader reader = new BlockReader(item.getBytes());
        try {
            this.readBytes(reader);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean isSharedItem() {
        return this.mShared;
    }

    public boolean isSharedItem(Block uniqueUser) {
        if (this.isSharedItem()) {
            return true;
        }
        Block user = this.mUniqueUser;
        return user != null && uniqueUser != null && user != uniqueUser;
    }

    public void addUniqueUser(Block uniqueUser) {
        if (uniqueUser == null || this.mShared || uniqueUser == this.mUniqueUser || uniqueUser == this) {
            return;
        }
        if (this.mUniqueUser != null) {
            this.mShared = true;
        } else {
            this.mUniqueUser = uniqueUser;
        }
    }

    @Override
    public void removeSelf() {
        Block parent = this.getParent();
        if (parent == null) {
            return;
        }
        BlockList itemArray = (BlockList)parent;
        itemArray.remove(this);
        this.setPosition(0);
        this.mUniqueUser = null;
    }

    @Override
    public Key getKey() {
        return null;
    }

    @Override
    public void removeLastAlign() {
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        if (this.mUniqueUser != null && this.mUniqueUser.getParent() == null) {
            this.mUniqueUser = null;
        }
    }
}

