/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.DefArray;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.FieldDefArray;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.data.MethodDefArray;
import com.reandroid.dex.data.StaticFieldDefArray;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.dex.smali.model.SmaliField;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;

public class ClassData
extends DataItem
implements SmaliFormat {
    private final Ule128Item staticFieldsCount = new Ule128Item();
    private final Ule128Item instanceFieldsCount = new Ule128Item();
    private final Ule128Item directMethodsCount = new Ule128Item();
    private final Ule128Item virtualMethodCount = new Ule128Item();
    private StaticFieldDefArray staticFields;
    private FieldDefArray instanceFields;
    private MethodDefArray directMethods;
    private MethodDefArray virtualMethods;

    public ClassData() {
        super(8);
        this.addChild(0, this.staticFieldsCount);
        this.addChild(1, this.instanceFieldsCount);
        this.addChild(2, this.directMethodsCount);
        this.addChild(3, this.virtualMethodCount);
    }

    public SectionType<ClassData> getSectionType() {
        return SectionType.CLASS_DATA;
    }

    public void remove(Key key) {
        Def<?> def = this.get(key);
        if (def != null) {
            def.removeSelf();
        }
    }

    public void removeField(FieldKey key) {
        FieldDef def = this.getField(key);
        if (def != null) {
            def.removeSelf();
        }
    }

    public void removeMethod(MethodKey key) {
        MethodDef def = this.getMethod(key);
        if (def != null) {
            def.removeSelf();
        }
    }

    public Def<?> get(Key key) {
        if (key instanceof FieldKey) {
            return this.getField((FieldKey)key);
        }
        if (key instanceof MethodKey) {
            return this.getMethod((MethodKey)key);
        }
        if (key != null) {
            throw new RuntimeException("Unknown key type: " + key.getClass() + ", '" + key + "'");
        }
        return null;
    }

    public FieldDef getField(FieldKey key) {
        FieldDef fieldDef = null;
        FieldDefArray fieldDefArray = this.staticFields;
        if (fieldDefArray != null) {
            fieldDef = (FieldDef)fieldDefArray.get(key);
        }
        if (fieldDef == null && (fieldDefArray = this.instanceFields) != null) {
            fieldDef = (FieldDef)fieldDefArray.get(key);
        }
        return fieldDef;
    }

    public MethodDef getMethod(MethodKey key) {
        MethodDef methodDef = null;
        MethodDefArray methodDefArray = this.directMethods;
        if (methodDefArray != null) {
            methodDef = (MethodDef)methodDefArray.get(key);
        }
        if (methodDef == null && (methodDefArray = this.virtualMethods) != null) {
            methodDef = (MethodDef)methodDefArray.get(key);
        }
        return methodDef;
    }

    public FieldDef getOrCreateStatic(FieldKey fieldKey) {
        FieldDef fieldDef = (FieldDef)this.initStaticFieldsArray().getOrCreate(fieldKey);
        fieldDef.addAccessFlag(AccessFlag.STATIC);
        return fieldDef;
    }

    public FieldDef getOrCreateInstance(FieldKey fieldKey) {
        return (FieldDef)this.initInstanceFieldsArray().getOrCreate(fieldKey);
    }

    public void ensureStaticConstructor(String type) {
        MethodKey methodKey = new MethodKey(type, "<clinit>", null, "V");
        MethodDef methodDef = this.getMethod(methodKey);
        if (methodDef != null) {
            return;
        }
        methodDef = (MethodDef)this.initDirectMethodsArray().getOrCreate(methodKey);
        methodDef.addAccessFlag(AccessFlag.STATIC);
        methodDef.addAccessFlag(AccessFlag.CONSTRUCTOR);
        InstructionList instructionList = methodDef.getCodeItem().getInstructionList();
        instructionList.add((Ins)Opcode.RETURN_VOID.newInstance());
    }

    public MethodDef getOrCreateDirect(MethodKey methodKey) {
        return (MethodDef)this.initDirectMethodsArray().getOrCreate(methodKey);
    }

    public MethodDef getOrCreateVirtual(MethodKey methodKey) {
        return (MethodDef)this.initVirtualMethodsArray().getOrCreate(methodKey);
    }

    public Iterator<Ins> getInstructions() {
        return new IterableIterator<MethodDef, Ins>(this.getMethods()){

            @Override
            public Iterator<Ins> iterator(MethodDef element) {
                return element.getInstructions();
            }
        };
    }

    public Iterator<FieldDef> getFields() {
        return new CombiningIterator(this.getStaticFields(), this.getInstanceFields());
    }

    public Iterator<MethodDef> getMethods() {
        return new CombiningIterator(this.getDirectMethods(), this.getVirtualMethods());
    }

    public Iterator<MethodDef> getDirectMethods() {
        MethodDefArray methodDefArray = this.directMethods;
        if (methodDefArray == null) {
            return EmptyIterator.of();
        }
        return methodDefArray.arrayIterator();
    }

    public Iterator<MethodDef> getConstructors() {
        return FilterIterator.of(this.getDirectMethods(), Def::isConstructor);
    }

    public Iterator<MethodDef> getVirtualMethods() {
        MethodDefArray methodDefArray = this.virtualMethods;
        if (methodDefArray == null) {
            return EmptyIterator.of();
        }
        return methodDefArray.arrayIterator();
    }

    public Iterator<FieldDef> getStaticFields() {
        StaticFieldDefArray fieldDefArray = this.staticFields;
        if (fieldDefArray == null) {
            return EmptyIterator.of();
        }
        return fieldDefArray.arrayIterator();
    }

    public Iterator<FieldDef> getInstanceFields() {
        FieldDefArray fieldDefArray = this.instanceFields;
        if (fieldDefArray == null) {
            return EmptyIterator.of();
        }
        return fieldDefArray.arrayIterator();
    }

    public int getStaticFieldsCount() {
        StaticFieldDefArray fieldDefArray = this.staticFields;
        if (fieldDefArray == null) {
            return 0;
        }
        return fieldDefArray.getCount();
    }

    public int getInstanceFieldsCount() {
        FieldDefArray fieldDefArray = this.instanceFields;
        if (fieldDefArray == null) {
            return 0;
        }
        return fieldDefArray.getCount();
    }

    public int getDirectMethodsCount() {
        MethodDefArray methodDefArray = this.directMethods;
        if (methodDefArray == null) {
            return 0;
        }
        return methodDefArray.getCount();
    }

    public int getVirtualMethodsCount() {
        MethodDefArray methodDefArray = this.virtualMethods;
        if (methodDefArray == null) {
            return 0;
        }
        return methodDefArray.getCount();
    }

    public StaticFieldDefArray getStaticFieldsArray() {
        return this.staticFields;
    }

    public FieldDefArray getInstanceFieldsArray() {
        return this.instanceFields;
    }

    public MethodDefArray getDirectMethodsArray() {
        return this.directMethods;
    }

    public MethodDefArray getVirtualMethodArray() {
        return this.virtualMethods;
    }

    private FieldDefArray initStaticFieldsArray() {
        StaticFieldDefArray fieldDefArray = this.staticFields;
        if (fieldDefArray == null) {
            this.staticFields = fieldDefArray = new StaticFieldDefArray(this.staticFieldsCount);
            this.addChild(4, this.staticFields);
        }
        return fieldDefArray;
    }

    private FieldDefArray initInstanceFieldsArray() {
        FieldDefArray fieldDefArray = this.instanceFields;
        if (fieldDefArray == null) {
            this.instanceFields = fieldDefArray = new FieldDefArray(this.instanceFieldsCount);
            this.addChild(5, this.instanceFields);
        }
        return fieldDefArray;
    }

    private MethodDefArray initDirectMethodsArray() {
        MethodDefArray methodDefArray = this.directMethods;
        if (methodDefArray == null) {
            this.directMethods = methodDefArray = new MethodDefArray(this.directMethodsCount);
            this.addChild(6, methodDefArray);
        }
        return methodDefArray;
    }

    private MethodDefArray initVirtualMethodsArray() {
        MethodDefArray methodDefArray = this.virtualMethods;
        if (methodDefArray == null) {
            this.virtualMethods = methodDefArray = new MethodDefArray(this.virtualMethodCount);
            this.addChild(7, methodDefArray);
        }
        return methodDefArray;
    }

    private Iterator<DefArray<?>> getDefArrays() {
        return ArrayIterator.of(this.getChildes(), 4, 4);
    }

    public void setClassId(ClassId classId) {
        Iterator<DefArray<?>> iterator = this.getDefArrays();
        while (iterator.hasNext()) {
            iterator.next().setClassId(classId);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        if (this.staticFieldsCount.get() != 0) {
            this.initStaticFieldsArray().onReadBytes(reader);
        }
        if (this.instanceFieldsCount.get() != 0) {
            this.initInstanceFieldsArray().onReadBytes(reader);
        }
        if (this.directMethodsCount.get() != 0) {
            this.initDirectMethodsArray().onReadBytes(reader);
        }
        if (this.virtualMethodCount.get() != 0) {
            this.initVirtualMethodsArray().onReadBytes(reader);
        }
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        Iterator<DefArray<?>> iterator = this.getDefArrays();
        while (iterator.hasNext()) {
            iterator.next().sort(CompareUtil.getComparableComparator());
        }
    }

    @Override
    public void removeSelf() {
        super.removeSelf();
        Iterator<DefArray<?>> iterator = this.getDefArrays();
        while (iterator.hasNext()) {
            iterator.next().clearChildes();
        }
        this.setClassId(null);
    }

    public void replaceKeys(Key search, Key replace) {
        Iterator<DefArray<?>> iterator = this.getDefArrays();
        while (iterator.hasNext()) {
            iterator.next().replaceKeys(search, replace);
        }
    }

    @Override
    public void editInternal(Block user) {
        if (this.staticFields != null) {
            this.staticFields.editInternal(user);
        }
        if (this.instanceFields != null) {
            this.instanceFields.editInternal(user);
        }
        if (this.directMethods != null) {
            this.directMethods.editInternal(user);
        }
        if (this.virtualMethods != null) {
            this.virtualMethods.editInternal(user);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<DefArray<?>, IdItem>(this.getDefArrays()){

            @Override
            public Iterator<IdItem> iterator(DefArray<?> element) {
                return element.usedIds();
            }
        };
    }

    public void merge(ClassData classData) {
        if (classData.getStaticFieldsCount() != 0) {
            this.initStaticFieldsArray().merge(classData.staticFields);
        }
        if (classData.getInstanceFieldsCount() != 0) {
            this.initInstanceFieldsArray().merge(classData.instanceFields);
        }
        if (classData.getDirectMethodsCount() != 0) {
            this.initDirectMethodsArray().merge(classData.directMethods);
        }
        if (classData.getVirtualMethodsCount() != 0) {
            this.initVirtualMethodsArray().merge(classData.virtualMethods);
        }
    }

    public void fromSmali(SmaliClass smaliClass) throws IOException {
        Iterator<SmaliMethod> smaliVirtualMethods;
        Iterator<SmaliMethod> smaliDirectMethods;
        Iterator<SmaliField> smaliInstanceFields;
        Iterator<SmaliField> smaliStaticFields = smaliClass.getStaticFields();
        if (smaliStaticFields.hasNext()) {
            FieldDefArray defArray = this.initStaticFieldsArray();
            defArray.fromSmali(smaliStaticFields);
        }
        if ((smaliInstanceFields = smaliClass.getInstanceFields()).hasNext()) {
            FieldDefArray defArray = this.initInstanceFieldsArray();
            defArray.fromSmali(smaliInstanceFields);
        }
        if ((smaliDirectMethods = smaliClass.getDirectMethods()).hasNext()) {
            MethodDefArray defArray = this.initDirectMethodsArray();
            defArray.fromSmali(smaliDirectMethods);
        }
        if ((smaliVirtualMethods = smaliClass.getVirtualMethods()).hasNext()) {
            MethodDefArray defArray = this.initVirtualMethodsArray();
            defArray.fromSmali(smaliVirtualMethods);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendOptional(this.staticFields, "static fields");
        writer.appendOptional(this.instanceFields, "instance fields");
        writer.appendOptional(this.directMethods, "direct methods");
        writer.appendOptional(this.virtualMethods, "virtual methods");
    }

    public String toString() {
        return "staticFieldsCount=" + this.staticFieldsCount + ", instanceFieldCount=" + this.instanceFieldsCount + ", directMethodCount=" + this.directMethodsCount + ", virtualMethodCount=" + this.virtualMethodCount;
    }
}

