/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.IntegerDataItemList;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.DataKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItemCreate;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationItem;
import com.reandroid.dex.smali.model.SmaliAnnotationSet;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;

public class AnnotationSet
extends IntegerDataItemList<AnnotationItem>
implements KeyItemCreate,
SmaliFormat,
PositionAlignedItem,
FullRefresh {
    private final DataKey<AnnotationSet> mKey = new DataKey<AnnotationSet>(this);

    public AnnotationSet() {
        super(SectionType.ANNOTATION_ITEM, UsageMarker.USAGE_ANNOTATION, new DexPositionAlign());
    }

    @Override
    public DataKey<AnnotationSet> getKey() {
        return this.mKey;
    }

    @Override
    public void setKey(Key key) {
        DataKey dataKey = (DataKey)key;
        this.merge((AnnotationSet)dataKey.getItem());
    }

    public SectionType<AnnotationSet> getSectionType() {
        return SectionType.ANNOTATION_SET;
    }

    public DexValueBlock<?> getValue(TypeKey typeKey, String name) {
        AnnotationElement element = this.getElement(typeKey, name);
        if (element != null) {
            return element.getValue();
        }
        return null;
    }

    public AnnotationElement getElement(TypeKey typeKey, String name) {
        AnnotationItem annotationItem = this.get(typeKey);
        if (annotationItem != null) {
            return annotationItem.getElement(name);
        }
        return null;
    }

    public AnnotationItem get(TypeKey typeKey) {
        for (AnnotationItem item : this) {
            if (!typeKey.equals(item.getTypeKey())) continue;
            return item;
        }
        return null;
    }

    public Iterator<AnnotationItem> getAll(TypeKey typeKey) {
        return FilterIterator.of(this.iterator(), item -> typeKey.equals(item.getTypeKey()));
    }

    public boolean contains(String typeName) {
        for (AnnotationItem item : this) {
            if (!typeName.equals(item.getTypeName())) continue;
            return true;
        }
        return false;
    }

    public boolean contains(TypeKey typeKey) {
        for (AnnotationItem item : this) {
            if (!typeKey.equals(item.getTypeKey())) continue;
            return true;
        }
        return false;
    }

    public AnnotationItem getOrCreate(TypeKey typeKey) {
        AnnotationItem item = this.get(typeKey);
        if (item != null) {
            return item;
        }
        return this.addNewItem(typeKey);
    }

    public AnnotationItem getOrCreate(String type, String name) {
        AnnotationItem item = this.get(type, name);
        if (item != null) {
            return item;
        }
        return this.addNew(type, name);
    }

    public AnnotationItem addNewItem(TypeKey typeKey) {
        AnnotationItem item = (AnnotationItem)this.addNew();
        item.setType(typeKey);
        return item;
    }

    public AnnotationItem addNew(String type, String name) {
        AnnotationItem item = (AnnotationItem)this.addNew();
        item.setType(type);
        item.getOrCreateElement(name);
        return item;
    }

    public AnnotationItem get(String type, String name) {
        for (AnnotationItem item : this) {
            if (!type.equals(item.getTypeName()) || !item.containsName(name)) continue;
            return item;
        }
        return null;
    }

    public void replaceKeys(Key search, Key replace) {
        for (AnnotationItem annotationItem : this) {
            annotationItem.replaceKeys(search, replace);
        }
    }

    @Override
    public void refreshFull() {
        this.sort();
    }

    public boolean sort() {
        return super.sort(CollectionUtil.getComparator());
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<AnnotationItem, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(AnnotationItem element) {
                return element.usedIds();
            }
        };
    }

    public void merge(AnnotationSet annotationSet) {
        if (annotationSet == this) {
            return;
        }
        for (AnnotationItem coming : annotationSet) {
            this.addNew(coming.getKey());
        }
    }

    public void fromSmali(SmaliAnnotationSet smaliAnnotationSet) {
        Iterator iterator = smaliAnnotationSet.iterator();
        while (iterator.hasNext()) {
            SmaliAnnotationItem smaliAnnotationItem = (SmaliAnnotationItem)iterator.next();
            AnnotationItem annotationItem = this.addNewItem(smaliAnnotationItem.getType());
            annotationItem.fromSmali(smaliAnnotationItem);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendAllWithDoubleNewLine(this.iterator());
    }

    @Override
    public String toString() {
        if (this.getOffsetReference() == null) {
            return super.toString();
        }
        int size = this.size();
        if (size == 0) {
            return "EMPTY";
        }
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        for (AnnotationItem item : this) {
            if (appendOnce) {
                builder.append(',');
            }
            builder.append(item);
            appendOnce = true;
        }
        return builder.toString();
    }

    public static class EmptyAnnotationSet
    extends AnnotationSet {
        @Override
        protected void onRefreshed() {
            super.onRefreshed();
            Section<AnnotationSet> section = this.getSection(this.getSectionType());
            if (section.getCount() == 1) {
                this.addUsageType(UsageMarker.USAGE_ANNOTATION);
            }
        }
    }
}

