/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.item.ByteItem;
import com.reandroid.dex.base.CountedList;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.AnnotationElement;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.DataKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItemCreate;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliAnnotationElement;
import com.reandroid.dex.smali.model.SmaliAnnotationItem;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public class AnnotationItem
extends DataItem
implements Comparable<AnnotationItem>,
Iterable<AnnotationElement>,
KeyItemCreate,
SmaliRegion {
    private final ByteItem visibility;
    private final Ule128IdItemReference<TypeId> typeId;
    private final CountedList<AnnotationElement> annotationElements;
    private final boolean mValueEntry;
    private final DataKey<AnnotationItem> mItemKey;

    public AnnotationItem(boolean valueEntry) {
        super(valueEntry ? 3 : 4);
        this.mValueEntry = valueEntry;
        ByteItem visibility = valueEntry ? null : new ByteItem();
        this.visibility = visibility;
        this.typeId = new Ule128IdItemReference<TypeId>(SectionType.TYPE_ID, UsageMarker.USAGE_ANNOTATION);
        Ule128Item elementsCount = new Ule128Item();
        this.annotationElements = new CountedList<AnnotationElement>(elementsCount, AnnotationElement.CREATOR);
        int i = 0;
        if (!valueEntry) {
            this.addChild(i++, visibility);
        }
        this.mItemKey = new DataKey<AnnotationItem>(this);
        this.addChild(i++, this.typeId);
        this.addChild(i++, elementsCount);
        this.addChild(i, this.annotationElements);
    }

    public AnnotationItem() {
        this(false);
    }

    public SectionType<AnnotationItem> getSectionType() {
        return SectionType.ANNOTATION_ITEM;
    }

    public int remove(Predicate<AnnotationElement> filter) {
        return this.annotationElements.remove(filter);
    }

    public void remove(AnnotationElement element) {
        this.annotationElements.remove(element);
    }

    public AnnotationElement getOrCreateElement(String name) {
        AnnotationElement element = this.getElement(name);
        if (element != null) {
            return element;
        }
        element = this.createNewElement();
        element.setName(name);
        element.getOrCreateValue(DexValueType.NULL);
        return element;
    }

    public AnnotationElement createNewElement() {
        return (AnnotationElement)this.annotationElements.createNext();
    }

    public boolean containsName(String name) {
        for (AnnotationElement element : this) {
            if (!name.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    public DexValueBlock<?> getElementValue(String name) {
        AnnotationElement element = this.getElement(name);
        if (element != null) {
            return element.getValue();
        }
        return null;
    }

    public AnnotationElement getElement(String name) {
        for (AnnotationElement element : this) {
            if (!name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public String[] getNames() {
        CountedList<AnnotationElement> elements = this.annotationElements;
        int length = elements.size();
        if (length == 0) {
            return null;
        }
        String[] results = new String[length];
        for (int i = 0; i < length; ++i) {
            results[i] = ((AnnotationElement)elements.get(i)).getName();
        }
        return results;
    }

    @Override
    public DataKey<AnnotationItem> getKey() {
        return this.mItemKey;
    }

    @Override
    public void setKey(Key key) {
        DataKey itemKey = (DataKey)key;
        this.merge((AnnotationItem)itemKey.getItem());
    }

    @Override
    public Iterator<AnnotationElement> iterator() {
        return this.annotationElements.iterator();
    }

    public Iterator<AnnotationElement> clonedIterator() {
        return this.annotationElements.clonedIterator();
    }

    public int getElementsCount() {
        return this.annotationElements.size();
    }

    public boolean isEmpty() {
        return this.annotationElements.size() == 0;
    }

    public AnnotationElement getElement(int index) {
        return (AnnotationElement)this.annotationElements.get(index);
    }

    public boolean isValueEntry() {
        return this.mValueEntry;
    }

    public AnnotationVisibility getVisibility() {
        if (!this.isValueEntry()) {
            return AnnotationVisibility.valueOf(this.visibility.unsignedInt());
        }
        return null;
    }

    public void setVisibility(AnnotationVisibility visibility) {
        int value = visibility != null ? visibility.getValue() : 0;
        this.setVisibility(value);
    }

    public void setVisibility(int visibility) {
        if (this.visibility != null) {
            this.visibility.set((byte)visibility);
        }
    }

    public int getVisibilityValue() {
        if (this.visibility == null) {
            return 0;
        }
        return this.visibility.unsignedInt();
    }

    public String getTypeName() {
        TypeId typeId = this.getTypeId();
        if (typeId != null) {
            return typeId.getName();
        }
        return null;
    }

    public TypeKey getTypeKey() {
        return (TypeKey)this.typeId.getKey();
    }

    public TypeId getTypeId() {
        return (TypeId)this.typeId.getItem();
    }

    public void setType(String type) {
        this.setType(TypeKey.create(type));
    }

    public void setType(TypeKey typeKey) {
        this.typeId.setItem(typeKey);
    }

    public void replaceKeys(Key search, Key replace) {
        for (AnnotationElement element : this) {
            element.replaceKeys(search, replace);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.singleOne(this.getTypeId(), new IterableIterator<AnnotationElement, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(AnnotationElement element) {
                return element.usedIds();
            }
        });
    }

    public void merge(AnnotationItem annotationItem) {
        if (annotationItem == this) {
            return;
        }
        this.setVisibility(annotationItem.getVisibilityValue());
        this.setType(annotationItem.getTypeKey());
        this.annotationElements.ensureCapacity(annotationItem.getElementsCount());
        for (AnnotationElement coming : annotationItem) {
            this.createNewElement().merge(coming);
        }
    }

    public void fromSmali(SmaliAnnotationItem smaliAnnotationItem) {
        this.setType(smaliAnnotationItem.getType());
        Iterator iterator = smaliAnnotationItem.iterator();
        while (iterator.hasNext()) {
            SmaliAnnotationElement smaliAnnotationElement = (SmaliAnnotationElement)iterator.next();
            AnnotationElement element = this.createNewElement();
            element.fromSmali(smaliAnnotationElement);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        AnnotationVisibility visibility = this.getVisibility();
        if (visibility != null) {
            visibility.append(writer);
        }
        this.getTypeId().append(writer);
        writer.indentPlus();
        writer.appendAllWithDoubleNewLine(this.iterator());
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        if (this.isValueEntry()) {
            return SmaliDirective.SUB_ANNOTATION;
        }
        return SmaliDirective.ANNOTATION;
    }

    @Override
    public int compareTo(AnnotationItem other) {
        if (other == null) {
            return -1;
        }
        if (other == this) {
            return 0;
        }
        return SectionTool.compareIdx(this.getTypeId(), other.getTypeId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationItem item = (AnnotationItem)obj;
        if (!Objects.equals(this.getTypeName(), item.getTypeName())) {
            return false;
        }
        return this.annotationElements.equals(item.annotationElements);
    }

    public int hashCode() {
        int hash = 1;
        Object obj = this.getTypeName();
        hash *= 31;
        if (obj != null) {
            hash += obj.hashCode();
        }
        obj = this.annotationElements;
        hash *= 31;
        if (obj != null) {
            hash += obj.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('@');
        builder.append(this.getTypeName());
        boolean appendOnce = false;
        for (AnnotationElement element : this) {
            if (appendOnce) {
                builder.append(", ");
            } else {
                builder.append('(');
            }
            builder.append(element);
            appendOnce = true;
        }
        if (appendOnce) {
            builder.append(')');
        }
        return builder.toString();
    }
}

