/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.IntegerDataItemList;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.DataKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyItemCreate;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.IterableIterator;
import java.util.Iterator;

public class AnnotationGroup
extends IntegerDataItemList<AnnotationSet>
implements KeyItemCreate {
    private final DataKey<AnnotationGroup> mKey = new DataKey<AnnotationGroup>(this);

    public AnnotationGroup() {
        super(SectionType.ANNOTATION_SET, UsageMarker.USAGE_ANNOTATION, null);
    }

    @Override
    public DataKey<AnnotationGroup> getKey() {
        return this.mKey;
    }

    @Override
    public void setKey(Key key) {
        DataKey dataKey = (DataKey)key;
        this.merge((AnnotationGroup)dataKey.getItem());
    }

    public SectionType<AnnotationGroup> getSectionType() {
        return SectionType.ANNOTATION_GROUP;
    }

    @Override
    void removeNulls() {
    }

    public void replaceKeys(Key search, Key replace) {
        for (AnnotationSet annotationSet : this) {
            annotationSet.replaceKeys(search, replace);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<AnnotationSet, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(AnnotationSet element) {
                return element.usedIds();
            }
        };
    }

    public void merge(AnnotationGroup annotationGroup) {
        AnnotationSet[] comingSets = (AnnotationSet[])annotationGroup.getItems();
        if (comingSets == null) {
            return;
        }
        for (AnnotationSet comingSet : comingSets) {
            if (comingSet == null) {
                this.addNull();
                continue;
            }
            this.addNew(comingSet.getKey());
        }
    }
}

