/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.NumberIntegerReference;
import com.reandroid.dex.base.OffsetReceiver;
import com.reandroid.dex.base.PositionedItem;
import com.reandroid.dex.common.SectionItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SectionItemContainer
extends SectionItem
implements BlockRefresh,
PositionedItem,
OffsetSupplier,
OffsetReceiver {
    private final Block[] mChildes;
    private IntegerReference mReference;
    private static final Block[] EMPTY = new Block[0];

    public SectionItemContainer(int childesCount) {
        super(0);
        Block[] childes = childesCount == 0 ? EMPTY : new Block[childesCount];
        this.mChildes = childes;
    }

    @Override
    public int getIdx() {
        return this.getOffset();
    }

    @Override
    public void setIdx(int idx) {
        this.setPosition(idx);
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.mReference;
    }

    @Override
    public void setOffsetReference(IntegerReference reference) {
        this.mReference = reference;
    }

    @Override
    public void setPosition(int position) {
        IntegerReference reference = this.getOffsetReference();
        if (reference == null) {
            reference = new NumberIntegerReference(position);
            this.setOffsetReference(reference);
        } else {
            reference.set(position);
        }
    }

    @Override
    public void removeLastAlign() {
    }

    public int getOffset() {
        IntegerReference reference = this.getOffsetReference();
        if (reference != null) {
            return reference.get();
        }
        return 0;
    }

    @Override
    public int countBytes() {
        if (this.isNull()) {
            return 0;
        }
        Block[] childes = this.getChildes();
        if (childes == null) {
            return 0;
        }
        int result = 0;
        for (Block item : childes) {
            if (item == null) continue;
            result += item.countBytes();
        }
        return result;
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        Block[] childes = this.getChildes();
        if (childes == null) {
            return null;
        }
        byte[] results = null;
        for (Block item : childes) {
            if (item == null) continue;
            results = SectionItemContainer.addBytes(results, item.getBytes());
        }
        return results;
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        if (this.isNull()) {
            return 0;
        }
        Block[] childes = this.getChildes();
        if (childes == null) {
            return 0;
        }
        int result = 0;
        for (Block item : childes) {
            if (item == null) continue;
            result += item.writeBytes(stream);
        }
        return result;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        int length = childes.length;
        if (this.skipReading(this, reader)) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Block block = childes[i];
            if (block == null || this.skipReading(block, reader)) continue;
            block.readBytes(reader);
        }
    }

    protected void nonCheckRead(BlockReader reader) throws IOException {
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        for (Block block : childes) {
            if (block == null) continue;
            block.readBytes(reader);
        }
    }

    private boolean skipReading(Block block, BlockReader reader) {
        if (!(block instanceof OffsetSupplier)) {
            return false;
        }
        OffsetSupplier offsetSupplier = (OffsetSupplier)((Object)block);
        IntegerReference reference = offsetSupplier.getOffsetReference();
        if (reference != null) {
            int offset = reference.get();
            if (!this.isValidOffset(offset)) {
                return true;
            }
            reader.seek(offset);
        }
        return false;
    }

    protected boolean isValidOffset(int offset) {
        return offset > 0;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        int max = childes.length;
        for (int i = 0; i < max; ++i) {
            if (counter.FOUND) {
                return;
            }
            Block item = childes[i];
            if (item == null) continue;
            item.onCountUpTo(counter);
        }
    }

    public void addChild(int index, Block block) {
        this.mChildes[index] = block;
        if (block != null) {
            block.setIndex(index);
            block.setParent(this);
        }
    }

    @Override
    public void refresh() {
        if (this.isNull()) {
            return;
        }
        this.onPreRefresh();
        this.refreshChildes();
        this.onRefreshed();
    }

    protected void refreshChildes() {
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        for (Block item : childes) {
            if (!(item instanceof BlockRefresh)) continue;
            ((BlockRefresh)((Object)item)).refresh();
        }
    }

    protected void onPreRefresh() {
    }

    protected void onRefreshed() {
    }

    public int getChildesCount() {
        return this.mChildes.length;
    }

    public Block[] getChildes() {
        return this.mChildes;
    }

    @Override
    protected final byte[] getBytesInternal() {
        throw new RuntimeException("Not block item");
    }

    @Override
    protected void onBytesChanged() {
        throw new RuntimeException("Not block item");
    }

    @Override
    public final int readBytes(InputStream inputStream) throws IOException {
        throw new RuntimeException("Not block item");
    }
}

