/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;
import java.util.Iterator;

public abstract class Modifier
implements SmaliFormat {
    private final int value;
    private final String name;
    private final int hash;

    public Modifier(int value, String name) {
        this.value = value;
        this.name = name;
        this.hash = name.hashCode() + value * 31;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean isSet(int var1);

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append(this.getName());
        writer.append(' ');
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getName();
    }

    public static void append(SmaliWriter writer, Modifier[] modifiers) throws IOException {
        if (modifiers == null) {
            return;
        }
        for (Modifier modifier : modifiers) {
            if (modifier == null) continue;
            writer.append(modifier.getName());
            writer.append(' ');
        }
    }

    public static boolean contains(Modifier[] modifiers, Modifier modifier) {
        if (modifiers == null || modifier == null) {
            return false;
        }
        for (Modifier m : modifiers) {
            if (modifier != m) continue;
            return true;
        }
        return false;
    }

    public static String toString(Iterator<? extends Modifier> iterator) {
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            Modifier modifier = iterator.next();
            builder.append(modifier.getName());
            builder.append(' ');
        }
        return builder.toString();
    }

    public static String toString(Modifier[] modifiers) {
        if (modifiers == null) {
            return StringsUtil.EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        for (Modifier modifier : modifiers) {
            if (modifier == null) continue;
            builder.append(modifier.getName());
            builder.append(' ');
        }
        return builder.toString();
    }

    public static int combineValues(Modifier[] modifiers) {
        if (modifiers == null) {
            return 0;
        }
        int result = 0;
        for (Modifier modifier : modifiers) {
            if (modifier == null) continue;
            result |= modifier.getValue();
        }
        return result;
    }
}

