/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.utils.ObjectsUtil;
import java.util.Iterator;

public interface UsageMarker {
    public static final int USAGE_NONE = ObjectsUtil.of(0);
    public static final int USAGE_INSTRUCTION = ObjectsUtil.of(1);
    public static final int USAGE_ENCODED_VALUE = ObjectsUtil.of(2);
    public static final int USAGE_ANNOTATION = ObjectsUtil.of(4);
    public static final int USAGE_TYPE_NAME = ObjectsUtil.of(8);
    public static final int USAGE_SIGNATURE_TYPE = ObjectsUtil.of(16);
    public static final int USAGE_FIELD_NAME = ObjectsUtil.of(32);
    public static final int USAGE_METHOD_NAME = ObjectsUtil.of(64);
    public static final int USAGE_SHORTY = ObjectsUtil.of(512);
    public static final int USAGE_SOURCE = ObjectsUtil.of(256);
    public static final int USAGE_DEBUG = ObjectsUtil.of(512);
    public static final int USAGE_DEFINITION = ObjectsUtil.of(1024);
    public static final int USAGE_SUPER_CLASS = ObjectsUtil.of(2048);
    public static final int USAGE_FIELD_CLASS = ObjectsUtil.of(4096);
    public static final int USAGE_FIELD_TYPE = ObjectsUtil.of(8192);
    public static final int USAGE_METHOD = ObjectsUtil.of(16384);
    public static final int USAGE_PROTO = ObjectsUtil.of(15);
    public static final int USAGE_INTERFACE = ObjectsUtil.of(65536);
    public static final int USAGE_CALL_SITE = ObjectsUtil.of(131072);
    public static final int USAGE_STATIC_VALUES = ObjectsUtil.of(262144);
    public static final int USAGE_MARKER = ObjectsUtil.of(524288);

    public int getUsageType();

    public void addUsageType(int var1);

    public boolean containsUsage(int var1);

    public void clearUsageType();

    public static void clearUsageTypes(Iterator<?> usageMarkerIterator) {
        while (usageMarkerIterator.hasNext()) {
            UsageMarker usageMarker = (UsageMarker)usageMarkerIterator.next();
            usageMarker.clearUsageType();
        }
    }

    public static String toUsageString(int usages) {
        if (UsageMarker.containsUsage(usages, USAGE_NONE)) {
            return "NONE";
        }
        StringBuilder builder = new StringBuilder();
        if (UsageMarker.containsUsage(usages, USAGE_INSTRUCTION)) {
            builder.append("INSTRUCTION");
        }
        if (UsageMarker.containsUsage(usages, USAGE_ENCODED_VALUE)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("ENCODED_VALUE");
        }
        if (UsageMarker.containsUsage(usages, USAGE_ANNOTATION)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("ANNOTATION");
        }
        if (UsageMarker.containsUsage(usages, USAGE_TYPE_NAME)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("TYPE_NAME");
        }
        if (UsageMarker.containsUsage(usages, USAGE_SIGNATURE_TYPE)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("SIGNATURE_TYPE");
        }
        if (UsageMarker.containsUsage(usages, USAGE_FIELD_NAME)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("FIELD_NAME");
        }
        if (UsageMarker.containsUsage(usages, USAGE_METHOD_NAME)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("METHOD_NAME");
        }
        if (UsageMarker.containsUsage(usages, USAGE_SHORTY)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("SHORTY");
        }
        if (UsageMarker.containsUsage(usages, USAGE_SOURCE)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("SOURCE");
        }
        if (UsageMarker.containsUsage(usages, USAGE_DEBUG)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("DEBUG");
        }
        if (UsageMarker.containsUsage(usages, USAGE_DEFINITION)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("DEFINITION");
        }
        if (UsageMarker.containsUsage(usages, USAGE_SUPER_CLASS)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("SUPER_CLASS");
        }
        if (UsageMarker.containsUsage(usages, USAGE_FIELD_CLASS)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("FIELD_CLASS");
        }
        if (UsageMarker.containsUsage(usages, USAGE_FIELD_TYPE)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("FIELD_TYPE");
        }
        if (UsageMarker.containsUsage(usages, USAGE_METHOD)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("METHOD");
        }
        if (UsageMarker.containsUsage(usages, USAGE_PROTO)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("PROTO");
        }
        if (UsageMarker.containsUsage(usages, USAGE_INTERFACE)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("INTERFACE");
        }
        if (UsageMarker.containsUsage(usages, USAGE_MARKER)) {
            if (builder.length() != 0) {
                builder.append('|');
            }
            builder.append("MARKER");
        }
        return builder.toString();
    }

    public static boolean containsUsage(int usages, int usage) {
        if (usage == 0) {
            return usages == 0;
        }
        return (usages & usage) == usage;
    }
}

