/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexBlockItem;
import com.reandroid.dex.base.DexException;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public class NumberArray
extends DexBlockItem {
    private final IntegerReference widthReference;
    private final IntegerReference itemCount;
    private List<Number> numberList;

    public NumberArray(IntegerReference widthReference, IntegerReference itemCount) {
        super(0);
        this.widthReference = widthReference;
        this.itemCount = itemCount;
    }

    public Iterator<IntegerReference> getReferences() {
        return new Iterator<IntegerReference>(){
            private int mIndex;

            @Override
            public boolean hasNext() {
                return this.mIndex < NumberArray.this.size();
            }

            @Override
            public IntegerReference next() {
                IntegerReference reference = NumberArray.this.getReference(this.mIndex);
                ++this.mIndex;
                return reference;
            }
        };
    }

    public IntegerReference getReference(int index) {
        if (index >= this.size()) {
            return null;
        }
        return new Data(this, index);
    }

    public short[] getShortArray() {
        int width = this.getWidth();
        short[] results = new short[this.size()];
        byte[] bytes = this.getBytesInternal();
        for (int i = 0; i < results.length; ++i) {
            results[i] = NumberArray.getShort(bytes, i * width);
        }
        return results;
    }

    public int[] getByteUnsignedArray() {
        int[] results = new int[this.size()];
        byte[] bytes = this.getBytesInternal();
        for (int i = 0; i < results.length; ++i) {
            results[i] = bytes[i] & 0xFF;
        }
        return results;
    }

    public int[] getShortUnsignedArray() {
        int width = this.getWidth();
        int[] results = new int[this.size()];
        byte[] bytes = this.getBytesInternal();
        for (int i = 0; i < results.length; ++i) {
            results[i] = NumberArray.getShortUnsigned(bytes, i * width);
        }
        return results;
    }

    public int[] getIntArray() {
        int width = this.getWidth();
        int[] results = new int[this.size()];
        byte[] bytes = this.getBytesInternal();
        for (int i = 0; i < results.length; ++i) {
            results[i] = NumberArray.getInteger(bytes, i * width);
        }
        return results;
    }

    public long[] getLongArray() {
        int width = this.getWidth();
        long[] results = new long[this.size()];
        byte[] bytes = this.getBytesInternal();
        for (int i = 0; i < results.length; ++i) {
            results[i] = NumberArray.getLong(bytes, i * width);
        }
        return results;
    }

    public int getByteUnsigned(int index) {
        return this.getBytesInternal()[index * this.getWidth()] & 0xFF;
    }

    public void put(byte[] values) {
        int index = this.size();
        int length = values.length;
        this.ensureSize(index + length);
        for (int i = 0; i < length; ++i) {
            this.put(index + i, values[i] & 0xFF);
        }
    }

    public void put(short[] values) {
        int index = this.size();
        int length = values.length;
        this.ensureSize(index + length);
        for (int i = 0; i < length; ++i) {
            this.put(index + i, values[i] & 0xFFFF);
        }
    }

    public void put(int[] values) {
        int index = this.size();
        int length = values.length;
        this.ensureSize(index + length);
        for (int i = 0; i < length; ++i) {
            this.put(index + i, values[i]);
        }
    }

    public void put(int index, int value) {
        this.validateValueRange(value);
        this.ensureSize(index + 1);
        int width = this.getWidth();
        index *= width;
        byte[] bytes = this.getBytesInternal();
        if (width < 2) {
            this.getBytesInternal()[index] = (byte)value;
        } else if (width < 4) {
            NumberArray.putShort(bytes, index, value);
        } else if (width == 4) {
            NumberArray.putInteger(bytes, index, value);
        } else {
            NumberArray.putLong(bytes, index, 0xFFFFFFFFL & (long)value);
        }
    }

    private void validateValueRange(int value) {
        int count = 0;
        int shift = value;
        while (shift != 0) {
            shift >>>= 8;
            ++count;
        }
        if (count <= this.getWidth()) {
            return;
        }
        throw new DexException("Value out of range width = " + this.getWidth() + ", value = " + HexUtil.toHex(value, 1));
    }

    public void putLong(long[] values) {
        int index = this.size();
        int length = values.length;
        this.ensureSize(index + length);
        for (int i = 0; i < length; ++i) {
            this.putLong(index + i, values[i]);
        }
    }

    public void putLong(int index, long value) {
        this.ensureSize(index + 1);
        int width = this.getWidth();
        NumberArray.putLong(this.getBytesInternal(), index *= width, value);
    }

    public int getShortUnsigned(int index) {
        return NumberArray.getShortUnsigned(this.getBytesInternal(), index * this.getWidth());
    }

    public byte getByte(int index) {
        return this.getBytesInternal()[index * this.getWidth()];
    }

    public short getShort(int index) {
        return NumberArray.getShort(this.getBytesInternal(), index * this.getWidth());
    }

    public int getInteger(int index) {
        return NumberArray.getInteger(this.getBytesInternal(), index * this.getWidth());
    }

    public void setInteger(int index, int value) {
        NumberArray.putInteger(this.getBytesInternal(), index * this.getWidth(), value);
    }

    public long getLong(int index) {
        return NumberArray.getLong(this.getBytesInternal(), index * this.getWidth());
    }

    public List<Number> toList() {
        if (this.numberList == null) {
            this.numberList = new AbstractList<Number>(){

                @Override
                public Number get(int i) {
                    return NumberArray.this.getNumber(i);
                }

                @Override
                public int size() {
                    return NumberArray.this.size();
                }
            };
        }
        return this.numberList;
    }

    public Number getNumber(int index) {
        int width = this.getWidth();
        if (width == 1) {
            return this.getBytesInternal()[index];
        }
        int offset = index * width;
        if (width == 2) {
            return NumberArray.getShortUnsigned(this.getBytesInternal(), offset);
        }
        if (width == 4) {
            return NumberArray.getInteger(this.getBytesInternal(), offset);
        }
        return NumberArray.getLong(this.getBytesInternal(), offset);
    }

    public int getAsInteger(int index) {
        int width = this.getWidth();
        if (width < 2) {
            return this.getByteUnsigned(index);
        }
        if (width < 4) {
            return this.getShortUnsigned(index);
        }
        if (width == 4) {
            return this.getInteger(index);
        }
        return (int)this.getLong(index);
    }

    public int[] getAsIntegers() {
        int size = this.size();
        int[] results = new int[size];
        for (int i = 0; i < size; ++i) {
            results[i] = this.getAsInteger(i);
        }
        return results;
    }

    public int size() {
        return this.countBytes() / this.getWidth();
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void setSize(int size) {
        this.setBytesLength(size * this.getWidth(), false);
        this.itemCount.set(size);
    }

    public int getWidth() {
        int width = this.widthReference.get();
        if (width == 0) {
            width = 1;
        }
        return width;
    }

    public void setWidth(int width) {
        if (width == this.widthReference.get()) {
            return;
        }
        if (this.size() == 0) {
            this.widthReference.set(width);
        } else if (this.getWidth() > 4) {
            this.changeWidthOfLong(width);
        } else {
            this.changeWidthOfInt(width);
        }
    }

    private void changeWidthOfInt(int width) {
        int[] backup = this.getAsIntegers();
        this.setSize(0);
        this.widthReference.set(width);
        this.ensureSize(backup.length);
        this.put(backup);
    }

    private void changeWidthOfLong(int width) {
        long[] backup = this.getLongArray();
        this.setSize(0);
        this.widthReference.set(width);
        this.ensureSize(backup.length);
        this.putLong(backup);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int count = this.itemCount.get();
        int width = this.widthReference.get();
        if (width == 0) {
            width = 1;
            count = 0;
            this.itemCount.set(0);
        }
        this.setBytesLength(count * width, false);
        super.onReadBytes(reader);
    }

    public void merge(NumberArray array) {
        this.setWidth(array.getWidth());
        this.setSize(array.size());
        byte[] coming = array.getBytesInternal();
        byte[] bytes = this.getBytesInternal();
        for (byte bytes[i] : coming) {
        }
    }

    public String toString() {
        return "width=" + this.getWidth() + ", " + StringsUtil.toString(this.toList());
    }

    static class Data
    implements IntegerReference {
        private final NumberArray numberArray;
        private final int index;

        public Data(NumberArray numberArray, int index) {
            this.numberArray = numberArray;
            this.index = index;
        }

        @Override
        public int get() {
            return this.numberArray.getAsInteger(this.index);
        }

        @Override
        public void set(int value) {
            this.numberArray.put(this.index, value);
        }
    }
}

