/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexBlockItem;
import com.reandroid.dex.base.IndirectBlockIntegerPair;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;

public class IndexAndOffsetArray
extends DexBlockItem
implements OffsetArray {
    private final IntegerReference itemCount;

    public IndexAndOffsetArray(IntegerReference itemCount) {
        super(0);
        this.itemCount = itemCount;
    }

    public int[] getOffsetsForIndex(int index) {
        int size = this.size();
        int[] tmp = new int[size];
        int count = 0;
        for (int i = 0; i < size; ++i) {
            if (index != this.getIndexEntry(i)) continue;
            tmp[count] = this.getOffset(i);
            ++count;
        }
        int[] results = new int[count];
        for (int i = 0; i < count; ++i) {
            results[i] = tmp[i];
        }
        return results;
    }

    public IntegerPair[] toIntegerPairArray() {
        int size = this.size();
        IntegerPair[] results = new IntegerPair[size];
        for (int i = 0; i < size; ++i) {
            results[i] = this.get(i);
        }
        return results;
    }

    public IntegerPair get(int i) {
        return new IndirectBlockIntegerPair(this, i * 8);
    }

    private int getIndexEntry(int i) {
        return Block.getInteger(this.getBytesInternal(), i * 8);
    }

    public void setIndexEntry(int index, int value) {
        Block.putInteger(this.getBytesInternal(), index * 8, value);
    }

    @Override
    public int getOffset(int i) {
        return Block.getInteger(this.getBytesInternal(), i * 8 + 4);
    }

    @Override
    public void setOffset(int index, int value) {
        Block.putInteger(this.getBytesInternal(), index * 8 + 4, value);
    }

    @Override
    public int[] getOffsets() {
        int size = this.size();
        int[] results = new int[size];
        for (int i = 0; i < size; ++i) {
            results[i] = this.getOffset(i);
        }
        return results;
    }

    public int[] getIndexEntries() {
        int size = this.size();
        int[] results = new int[size];
        for (int i = 0; i < size; ++i) {
            results[i] = this.getIndexEntry(i);
        }
        return results;
    }

    @Override
    public int size() {
        return this.countBytes() / 8;
    }

    @Override
    public void setSize(int size) {
        if (size < 0) {
            size = 0;
        }
        this.setBytesLength(size * 8, false);
        this.itemCount.set(size);
    }

    @Override
    public void clear() {
        this.setSize(0);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.setBytesLength(this.itemCount.get() * 8, false);
        super.onReadBytes(reader);
    }

    public String toString() {
        return StringsUtil.toString(this.toIntegerPairArray());
    }
}

