/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.CreatorArray;
import com.reandroid.dex.base.DexArraySupplier;
import com.reandroid.dex.base.FixedSizeBlock;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.base.PositionedItem;
import com.reandroid.dex.header.DexHeader;
import java.io.IOException;

public class DexItemArray<T extends Block>
extends CreatorArray<T>
implements OffsetSupplier,
DexArraySupplier<T> {
    private final IntegerPair countAndOffset;

    public DexItemArray(IntegerPair countAndOffset, Creator<T> creator) {
        super(creator);
        this.countAndOffset = countAndOffset;
    }

    @Override
    public int countBytes() {
        Object item = this.get(0);
        if (item instanceof FixedSizeBlock) {
            return ((Block)item).countBytes() * this.getCount();
        }
        return super.countBytes();
    }

    @Override
    public IntegerReference getOffsetReference() {
        return this.getCountAndOffset().getSecond();
    }

    public IntegerPair getCountAndOffset() {
        return this.countAndOffset;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        IntegerPair countAndOffset = this.getCountAndOffset();
        if (this.skipReading(countAndOffset, reader)) {
            return;
        }
        this.positionItem(this, reader);
        this.setSize(countAndOffset.getFirst().get());
        this.readChildes(reader);
    }

    private boolean skipReading(IntegerPair countAndOffset, BlockReader reader) {
        if (countAndOffset == null) {
            return false;
        }
        IntegerReference reference = countAndOffset.getSecond();
        if (reference != null) {
            int offset = reference.get();
            if (!this.isValidOffset(offset)) {
                return true;
            }
            reader.seek(offset);
        }
        return false;
    }

    protected void readChildes(BlockReader reader) throws IOException {
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        for (Block block : childes) {
            if (block == null || this.skipReading(block, reader)) continue;
            this.positionItem(block, reader);
            block.readBytes(reader);
        }
    }

    private boolean skipReading(Block block, BlockReader reader) {
        if (!(block instanceof OffsetSupplier)) {
            return false;
        }
        OffsetSupplier offsetSupplier = (OffsetSupplier)((Object)block);
        IntegerReference reference = offsetSupplier.getOffsetReference();
        if (reference != null) {
            int offset = reference.get();
            if (!this.isValidOffset(offset)) {
                return true;
            }
            reader.seek(offset);
        }
        return false;
    }

    private void positionItem(Block block, BlockReader reader) {
        if (!(block instanceof PositionedItem)) {
            return;
        }
        PositionedItem positionedItem = (PositionedItem)((Object)block);
        positionedItem.setPosition(reader.getPosition());
    }

    protected boolean isValidOffset(int offset) {
        if (offset == 0) {
            return this.isDexHeaderArray();
        }
        return offset > 0;
    }

    private boolean isDexHeaderArray() {
        return this.get(0) instanceof DexHeader;
    }

    @Override
    protected void onRefreshed() {
        IntegerReference count = this.getCountAndOffset().getFirst();
        count.set(this.size());
    }
}

