/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.commons.utils.log;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConsoleUtil {
    private static Boolean succeedOnce;

    public static int getConsoleWidth() {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            try {
                return ConsoleUtil.attemptMode();
            }
            catch (Exception ex) {
                succeedOnce = false;
            }
        } else {
            try {
                return ConsoleUtil.attemptStty();
            }
            catch (Exception ex) {
                succeedOnce = false;
            }
        }
        return 80;
    }

    public static Boolean getSucceedOnce() {
        return succeedOnce;
    }

    private static int attemptStty() {
        String output = ConsoleUtil.attemptCommand(new String[]{"sh", "-c", "stty size < /dev/tty"});
        if (output == null) {
            succeedOnce = false;
            return 80;
        }
        String[] vals = output.split(" ");
        if (vals.length < 2) {
            succeedOnce = false;
            return 80;
        }
        int result = Integer.parseInt(vals[1]);
        if (succeedOnce == null || !succeedOnce.booleanValue()) {
            succeedOnce = true;
        }
        return result;
    }

    private static int attemptMode() {
        String output = ConsoleUtil.attemptCommand(new String[]{"mode", "con"});
        if (output == null) {
            succeedOnce = false;
            return 80;
        }
        Pattern pattern = Pattern.compile("Columns:[ \t]*(\\d+)");
        Matcher m = pattern.matcher(output);
        if (!m.find()) {
            succeedOnce = false;
            return 80;
        }
        int result = Integer.parseInt(m.group(1));
        if (succeedOnce == null || !succeedOnce.booleanValue()) {
            succeedOnce = true;
        }
        return result;
    }

    private static String attemptCommand(String[] command) {
        StringBuffer buffer = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (buffer == null) {
                    buffer = new StringBuffer();
                }
                buffer.append(line);
            }
            if (buffer != null) {
                return buffer.toString();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

