/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.utils.collection.CollectionUtil;
import java.util.Set;

public class SymbolGenerationUtils {
    private static final char[] CHARACTERS;
    private static final int TOTAL_CHARACTERS;
    private static final int LOWERCASE_AND_SUFFIX;
    private static final int SUFFIX_LENGTH;
    private static final Set<String> RESERVED_NAMES;

    public static String generateLowercase(int index) {
        return SymbolGenerationUtils.generate(index, false);
    }

    public static String generateMixedCase(int index) {
        return SymbolGenerationUtils.generate(index, true);
    }

    public static String generate(int index, boolean mixedCase) {
        int firstNumberOfCharacters;
        int size = 1;
        int number = index + 1;
        int maximumNumberOfCharacters = mixedCase ? TOTAL_CHARACTERS : LOWERCASE_AND_SUFFIX;
        int availableCharacters = firstNumberOfCharacters = maximumNumberOfCharacters - SUFFIX_LENGTH;
        while (number > availableCharacters) {
            number = (number - 1) / availableCharacters;
            availableCharacters = maximumNumberOfCharacters;
            ++size;
        }
        char[] characters = new char[size];
        number = index + 1;
        int i = 0;
        availableCharacters = firstNumberOfCharacters;
        int firstLetterPadding = SUFFIX_LENGTH;
        while (number > availableCharacters) {
            characters[i++] = CHARACTERS[(number - 1) % availableCharacters + firstLetterPadding];
            number = (number - 1) / availableCharacters;
            availableCharacters = maximumNumberOfCharacters;
            firstLetterPadding = 0;
        }
        characters[i] = CHARACTERS[number - 1 + firstLetterPadding];
        String symbol = new String(characters);
        if (SymbolGenerationUtils.isReserved(symbol)) {
            return SymbolGenerationUtils.generate(index + 1, mixedCase);
        }
        return symbol;
    }

    private static boolean isReserved(String symbol) {
        return symbol.length() > 1 && RESERVED_NAMES.contains(symbol);
    }

    static {
        int length;
        char[] charArray = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        CHARACTERS = charArray;
        TOTAL_CHARACTERS = length = charArray.length;
        LOWERCASE_AND_SUFFIX = length - 26;
        SUFFIX_LENGTH = 10;
        RESERVED_NAMES = CollectionUtil.newHashSet("boolean", "byte", "char", "double", "float", "int", "long", "short", "void", "it", "by", "class");
    }
}

