/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class ReferenceResolver {
    private final TableBlock entryStore;
    private final List<Entry> results;
    private final Set<Integer> resolvedIds;
    private int limit;

    public ReferenceResolver(TableBlock entryStore) {
        this.entryStore = entryStore;
        this.results = new ArrayList<Entry>();
        this.resolvedIds = new HashSet<Integer>();
        this.limit = -1;
    }

    public Entry resolve(int referenceId) {
        return this.resolve(referenceId, null);
    }

    public synchronized Entry resolve(int referenceId, Predicate<Entry> filter) {
        this.resolveReference(referenceId, filter);
        ArrayList<Entry> results = new ArrayList<Entry>(this.results);
        this.reset();
        if (results.size() > 0) {
            return (Entry)results.get(0);
        }
        return null;
    }

    public List<Entry> resolveWithConfig(int referenceId, ResConfig resConfig) {
        ConfigFilter configFilter = new ConfigFilter(resConfig);
        List<Entry> results = this.resolveAll(referenceId, configFilter);
        results.sort(configFilter);
        return results;
    }

    public List<Entry> resolveAll(int referenceId) {
        return this.resolveAll(referenceId, null);
    }

    public synchronized List<Entry> resolveAll(int referenceId, Predicate<Entry> filter) {
        this.resolveReference(referenceId, filter);
        ArrayList<Entry> results = new ArrayList<Entry>(this.results);
        this.reset();
        return results;
    }

    private void resolveReference(int referenceId, Predicate<Entry> filter) {
        if (referenceId == 0 || this.isFinished() || this.resolvedIds.contains(referenceId)) {
            return;
        }
        this.resolvedIds.add(referenceId);
        List<Entry> entryList = this.listNonNullEntries(referenceId);
        List<Entry> results = this.results;
        for (Entry entry : entryList) {
            if (this.isFinished()) {
                return;
            }
            if (results.contains(entry)) continue;
            if (entry.isComplex()) {
                this.addResult(filter, entry);
                continue;
            }
            ResValue resValue = entry.getResValue();
            if (resValue.getValueType() != ValueType.REFERENCE) {
                this.addResult(filter, entry);
                continue;
            }
            this.resolveReference(resValue.getData(), filter);
        }
    }

    private void reset() {
        this.results.clear();
        this.resolvedIds.clear();
        this.limit = -1;
    }

    private boolean isFinished() {
        return this.limit >= this.results.size();
    }

    private void addResult(Predicate<Entry> filter, Entry entry) {
        if (filter == null || filter.test(entry)) {
            this.results.add(entry);
        }
    }

    private List<Entry> listNonNullEntries(int resourceId) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        ResourceEntry resourceEntry = this.entryStore.getResource(resourceId);
        if (resourceEntry == null) {
            return results;
        }
        Iterator<Entry> itr = resourceEntry.iterator(true);
        while (itr.hasNext()) {
            results.add(itr.next());
        }
        return results;
    }

    public static class ConfigFilter
    implements Predicate<Entry>,
    Comparator<Entry> {
        private final ResConfig config;

        public ConfigFilter(ResConfig config) {
            this.config = config;
        }

        @Override
        public boolean test(Entry entry) {
            ResConfig resConfig = entry.getResConfig();
            if (resConfig == null) {
                return false;
            }
            return resConfig.isEqualOrMoreSpecificThan(this.config);
        }

        @Override
        public int compare(Entry entry1, Entry entry2) {
            ResConfig config1 = entry1.getResConfig();
            ResConfig config2 = entry2.getResConfig();
            if (this.config.equals(config1)) {
                return -1;
            }
            if (this.config.equals(config2)) {
                return 1;
            }
            return 0;
        }
    }
}

