/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.bag;

import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;

public abstract class BagItem {
    protected final ResValueMap mBagItem;
    private final ValueType valueType;
    private final int data;
    private final StringItem string;

    protected BagItem(ResValueMap bagItem) {
        this.mBagItem = bagItem;
        this.valueType = null;
        this.string = null;
        this.data = 0;
    }

    protected BagItem(ValueType valueType, int data) {
        if (valueType == ValueType.STRING) {
            throw new IllegalArgumentException("Use the string constructor instead");
        }
        this.mBagItem = null;
        this.string = null;
        this.valueType = valueType;
        this.data = data;
    }

    protected BagItem(StringItem str) {
        this.string = str;
        this.mBagItem = null;
        this.valueType = ValueType.STRING;
        this.data = 0;
    }

    public ValueType getValueType() {
        if (this.mBagItem != null) {
            return this.mBagItem.getValueType();
        }
        return this.valueType;
    }

    public int getValue() {
        if (this.mBagItem != null) {
            return this.mBagItem.getData();
        }
        if (this.valueType == ValueType.STRING) {
            return this.string.getIndex();
        }
        return this.data;
    }

    public void copyTo(ResValueMap target) {
        if (this.mBagItem != null) {
            target.setTypeAndData(this.mBagItem.getValueType(), this.mBagItem.getData());
        } else if (this.valueType == ValueType.STRING) {
            TableStringPool targetStrPool = (TableStringPool)target.getStringPool();
            if (targetStrPool == this.string.getParent(TableStringPool.class)) {
                target.setTypeAndData(ValueType.STRING, this.string.getIndex());
            } else {
                target.setTypeAndData(ValueType.STRING, ((TableString)targetStrPool.getOrCreate(this.string.get())).getIndex());
            }
        } else {
            target.setTypeAndData(this.valueType, this.data);
        }
    }

    public ResValueMap getBagItem() {
        return this.mBagItem;
    }

    public boolean hasStringValue() {
        return this.getValueType() == ValueType.STRING;
    }

    public boolean hasReferenceValue() {
        return this.getValueType() == ValueType.REFERENCE;
    }

    public String getStringValue() {
        if (this.mBagItem != null) {
            return this.mBagItem.getValueAsString();
        }
        if (this.valueType == ValueType.STRING) {
            return this.string.getHtml();
        }
        throw new IllegalArgumentException("Not a string");
    }
}

