/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.MainChunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.CoderUnknownStringRef;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.XmlSanitizer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.Value;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.StyleDocument;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public abstract class ValueItem
extends BlockItem
implements Value,
JSONConvert<JSONObject> {
    private ReferenceItem mStringReference;
    private final int sizeOffset;
    private static final int OFFSET_SIZE = 0;
    private static final int OFFSET_RES0 = 2;
    private static final int OFFSET_TYPE = 3;
    private static final int OFFSET_DATA = 4;
    public static final String NAME_data = "data";
    public static final String NAME_value_type = "value_type";

    public ValueItem(int bytesLength, int sizeOffset) {
        super(bytesLength);
        this.sizeOffset = sizeOffset;
        this.writeSize();
    }

    public boolean isUndefined() {
        return this.getValueType() == ValueType.NULL && this.getData() == 0;
    }

    public ResourceEntry resolve(int resourceId) {
        PackageBlock context = this.getPackageBlock();
        if (context == null) {
            return null;
        }
        TableBlock tableBlock = context.getTableBlock();
        if (tableBlock == null) {
            return null;
        }
        return tableBlock.getResource(context, resourceId);
    }

    @Override
    public PackageBlock getPackageBlock() {
        ParentChunk parentChunk = this.getParentChunk();
        if (parentChunk != null) {
            return parentChunk.getPackageBlock();
        }
        return null;
    }

    void linkTableStrings(TableStringPool tableStringPool) {
        if (this.getValueType() == ValueType.STRING) {
            this.linkStringReference(tableStringPool);
        }
    }

    public void onRemoved() {
        this.unLinkStringReference();
    }

    protected void onDataChanged() {
    }

    public void refresh() {
        this.updateSize();
    }

    byte getRes0() {
        return this.getBytesInternal()[this.sizeOffset + 2];
    }

    void setRes0(byte b) {
        this.getBytesInternal()[this.sizeOffset + 2] = b;
    }

    public byte getType() {
        return this.getBytesInternal()[this.sizeOffset + 3];
    }

    public void setType(byte type) {
        if (type == this.getType()) {
            return;
        }
        byte[] bts = this.getBytesInternal();
        int offset = this.sizeOffset + 3;
        byte old = bts[offset];
        bts[offset] = type;
        this.onTypeChanged(old, type);
        this.onDataChanged();
    }

    public int getSize() {
        return 0xFFFF & ValueItem.getShort(this.getBytesInternal(), this.sizeOffset + 0);
    }

    public void setSize(int size) {
        size = this.sizeOffset + size;
        this.setBytesLength(size, false);
        this.writeSize();
    }

    void updateSize() {
        this.writeSize();
    }

    private void writeSize() {
        int offset = this.sizeOffset;
        int size = this.countBytes() - offset;
        ValueItem.putShort(this.getBytesInternal(), offset + 0, (short)size);
    }

    protected void onDataLoaded() {
        if (this.getValueType() == ValueType.STRING) {
            this.linkStringReference();
        } else {
            this.unLinkStringReference();
        }
    }

    @Override
    public ValueType getValueType() {
        return ValueType.valueOf(this.getType());
    }

    @Override
    public void setValueType(ValueType valueType) {
        byte type = 0;
        if (valueType != null) {
            type = valueType.getByte();
        }
        this.setType(type);
    }

    @Override
    public int getData() {
        return ValueItem.getInteger(this.getBytesInternal(), this.sizeOffset + 4);
    }

    @Override
    public void setData(int data) {
        int old = this.getData();
        if (old == data) {
            return;
        }
        this.unLinkStringReference();
        this.writeData(data);
        if (ValueType.STRING == this.getValueType()) {
            this.linkStringReference();
        }
        this.onDataChanged();
    }

    void writeData(int data) {
        ValueItem.putInteger(this.getBytesInternal(), this.sizeOffset + 4, data);
    }

    public StringItem getDataAsPoolString() {
        if (this.getValueType() != ValueType.STRING) {
            return null;
        }
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        return stringPool.get(this.getData());
    }

    private void onTypeChanged(byte old, byte type) {
        byte typeString = ValueType.STRING.getByte();
        if (old == typeString) {
            this.unLinkStringReference();
        } else if (type == typeString) {
            this.linkStringReference();
        }
    }

    private void linkStringReference() {
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool == null || stringPool.isStringLinkLocked()) {
            return;
        }
        this.linkStringReference(stringPool);
    }

    private void linkStringReference(StringPool<?> stringPool) {
        Object tableString = stringPool.get(this.getData());
        if (tableString == null) {
            this.unLinkStringReference();
            return;
        }
        ReferenceItem stringReference = this.mStringReference;
        if (stringReference != null) {
            this.unLinkStringReference();
        }
        this.mStringReference = stringReference = new ValueStringReference(this);
        ((StringItem)tableString).addReference(stringReference);
    }

    private void unLinkStringReference() {
        ReferenceItem stringReference = this.mStringReference;
        if (stringReference == null) {
            return;
        }
        this.mStringReference = null;
        this.onUnlinkDataString(stringReference);
    }

    protected void onUnlinkDataString(ReferenceItem referenceItem) {
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        stringPool.removeReference(referenceItem);
    }

    public StringPool<?> getStringPool() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MainChunk)) continue;
            return ((MainChunk)((Object)parent)).getStringPool();
        }
        return null;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int readSize = this.initializeBytes(reader);
        super.onReadBytes(reader);
        if (readSize < 8) {
            this.setBytesLength(this.sizeOffset + 8, false);
            this.writeSize();
        }
    }

    private int initializeBytes(BlockReader reader) throws IOException {
        int readSize;
        int position = reader.getPosition();
        int offset = this.sizeOffset;
        reader.offset(offset);
        int size = readSize = reader.readUnsignedShort();
        if (size < 8 && reader.available() >= 8) {
            size = 8;
        }
        reader.seek(position);
        this.setBytesLength(offset + size, false);
        return readSize;
    }

    @Override
    public String getValueAsString() {
        StringItem stringItem = this.getDataAsPoolString();
        if (stringItem != null) {
            String value = stringItem.getXml();
            if (value == null) {
                value = "";
            }
            return value;
        }
        return null;
    }

    public StyleDocument getValueAsStyleDocument() {
        StringItem stringItem = this.getDataAsPoolString();
        if (!(stringItem instanceof TableString)) {
            return null;
        }
        return ((TableString)stringItem).getStyleDocument();
    }

    public void setValueAsString(StyleDocument styledString) {
        if (styledString == null) {
            this.setValueAsString("");
            return;
        }
        StringPool<?> stringPool = this.getStringPool();
        if (!styledString.hasElements() || !(stringPool instanceof TableStringPool)) {
            this.setValueAsString(XmlSanitizer.unEscapeUnQuote(styledString.getXml(false)));
            return;
        }
        TableStringPool tableStringPool = (TableStringPool)stringPool;
        TableString stringItem = tableStringPool.getOrCreate(styledString);
        this.setData(stringItem.getIndex());
        this.setValueType(ValueType.STRING);
    }

    @Override
    public void setValueAsString(String str) {
        if (this.getValueType() == ValueType.STRING && Objects.equals(str, this.getValueAsString())) {
            return;
        }
        if (str == null) {
            str = "";
        }
        Object stringItem = this.getStringPool().getOrCreate(str);
        this.setData(((Block)stringItem).getIndex());
        this.setValueType(ValueType.STRING);
    }

    public void serializeText(XmlSerializer serializer) throws IOException {
        this.serializeText(serializer, false);
    }

    public void serializeText(XmlSerializer serializer, boolean escapeValues) throws IOException {
        if (this.getValueType() == ValueType.STRING) {
            StringItem stringItem = this.getDataAsPoolString();
            if (stringItem != null) {
                stringItem.serializeText(serializer, escapeValues);
            } else {
                serializer.text(CoderUnknownStringRef.INS.decode(this.getData()));
            }
            return;
        }
        String value = this.decodeValue();
        if (value == null) {
            value = "";
        }
        serializer.text(value);
    }

    public void serializeAttribute(XmlSerializer serializer, String name) throws IOException {
        this.serializeAttribute(serializer, null, name, false);
    }

    public void serializeAttribute(XmlSerializer serializer, String name, boolean ignore_empty) throws IOException {
        this.serializeAttribute(serializer, null, name, ignore_empty);
    }

    public void serializeAttribute(XmlSerializer serializer, String namespace, String name, boolean ignore_empty) throws IOException {
        if (this.getValueType() == ValueType.STRING) {
            StringItem stringItem = this.getDataAsPoolString();
            if (stringItem != null) {
                stringItem.serializeAttribute(serializer, namespace, name);
            } else {
                serializer.attribute(namespace, name, CoderUnknownStringRef.INS.decode(this.getData()));
            }
            return;
        }
        String value = this.decodeValue();
        if (ignore_empty && StringsUtil.isEmpty(value)) {
            return;
        }
        if (value == null) {
            value = "";
        }
        serializer.attribute(namespace, name, value);
    }

    public boolean getValueAsBoolean() {
        return this.getData() != 0;
    }

    public void setValueAsBoolean(boolean val) {
        this.setValueType(ValueType.BOOLEAN);
        int data = val ? -1 : 0;
        this.setData(data);
    }

    @Override
    public void setValue(EncodeResult encodeResult) {
        if (encodeResult == null) {
            throw new NullPointerException();
        }
        if (encodeResult.isError()) {
            throw new IllegalArgumentException("Can not set error value: " + encodeResult.getError());
        }
        this.setTypeAndData(encodeResult.valueType, encodeResult.value);
    }

    public void setTypeAndData(ValueType valueType, int data) {
        this.setData(data);
        this.setValueType(valueType);
    }

    public void merge(ValueItem valueItem) {
        ValueType coming;
        if (valueItem == null || valueItem == this) {
            return;
        }
        int size = valueItem.getSize();
        if (size != 0) {
            this.setSize(valueItem.getSize());
        }
        if ((coming = valueItem.getValueType()) == ValueType.STRING) {
            this.setValueAsString(valueItem.getValueAsString());
        } else {
            this.setTypeAndData(coming, valueItem.getData());
        }
    }

    public void mergeWithName(ResourceMergeOption mergeOption, ValueItem valueItem) {
        ValueType coming;
        if (valueItem == null || valueItem == this) {
            return;
        }
        int size = valueItem.getSize();
        if (size != 0) {
            this.setSize(valueItem.getSize());
        }
        if ((coming = valueItem.getValueType()) == ValueType.STRING) {
            StyleDocument styleDocument = valueItem.getValueAsStyleDocument();
            if (styleDocument != null) {
                this.setValueAsString(styleDocument);
            } else {
                ApkFile apk1 = this.getPackageBlock().getTableBlock().getApkFile();
                ApkFile apk2 = valueItem.getPackageBlock().getTableBlock().getApkFile();
                String value = valueItem.getValueAsString();
                this.setValueAsString(value);
                if (apk1 != null && apk2 != null) {
                    apk1.mergeWithName(mergeOption, apk2, value);
                }
            }
        } else if (coming.isReference()) {
            int id = 0;
            ResourceEntry comingResourceEntry = valueItem.getValueAsReference();
            if (comingResourceEntry == null) {
                id = valueItem.getData();
            } else if (comingResourceEntry.isContext(valueItem.getPackageBlock())) {
                ResourceEntry mergedReference = comingResourceEntry.isDeclared() ? this.getPackageBlock().mergeWithName(mergeOption, comingResourceEntry) : mergeOption.resolveUndeclared(this.getPackageBlock(), comingResourceEntry);
                if (mergedReference != null) {
                    id = mergedReference.getResourceId();
                }
            } else {
                id = valueItem.getData();
            }
            this.setTypeAndData(coming, id);
        } else {
            this.setTypeAndData(coming, valueItem.getData());
        }
    }

    public String decodeValue() {
        return this.decodeValue(true);
    }

    public String decodeValue(boolean validatePackage) {
        ValueType valueType = this.getValueType();
        if (valueType == null) {
            return null;
        }
        if (valueType.isReference()) {
            return this.decodeAsReferenceString(valueType, validatePackage);
        }
        if (valueType == ValueType.STRING) {
            return this.getValueAsString();
        }
        return ValueCoder.decode(valueType, this.getData());
    }

    private String decodeAsReferenceString(ValueType valueType, boolean validatePackage) {
        int data = this.getData();
        if (data == 0) {
            return ValueCoder.decodeReference(null, valueType, data);
        }
        ResourceEntry resourceEntry = this.getValueAsReference();
        if (validatePackage && resourceEntry == null && this.getPackageBlock() == null) {
            throw new NullPointerException("Parent package block is null");
        }
        if (resourceEntry == null || !resourceEntry.isDeclared()) {
            return ValueCoder.decodeUnknownResourceId(valueType == ValueType.REFERENCE, data);
        }
        return resourceEntry.buildReference(this.getPackageBlock(), valueType);
    }

    @Override
    public JSONObject toJson() {
        if (this.isNull()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        ValueType valueType = this.getValueType();
        jsonObject.put(NAME_value_type, valueType.name());
        if (valueType == ValueType.STRING) {
            jsonObject.put(NAME_data, this.getValueAsString());
        } else if (valueType == ValueType.BOOLEAN) {
            jsonObject.put(NAME_data, this.getValueAsBoolean());
        } else {
            jsonObject.put(NAME_data, this.getData());
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        ValueType valueType = ValueType.fromName(json.getString(NAME_value_type));
        if (valueType == ValueType.STRING) {
            this.setValueAsString(json.optString(NAME_data, ""));
        } else if (valueType == ValueType.BOOLEAN) {
            this.setValueAsBoolean(json.getBoolean(NAME_data));
        } else {
            this.setValueType(valueType);
            this.setData(json.getInt(NAME_data));
        }
    }

    public String toString() {
        if (this.getPackageBlock() != null) {
            return (Object)((Object)this.getValueType()) + ":" + HexUtil.toHex8(this.getData()) + " " + this.decodeValue();
        }
        StringBuilder builder = new StringBuilder();
        int size = this.getSize();
        if (size != 8) {
            builder.append("size=").append(this.getSize());
            builder.append(", ");
        }
        builder.append("type=");
        ValueType valueType = this.getValueType();
        if (valueType != null) {
            builder.append((Object)valueType);
        } else {
            builder.append(HexUtil.toHex2(this.getType()));
        }
        builder.append(", data=");
        int data = this.getData();
        if (valueType == ValueType.STRING) {
            StringItem tableString = this.getDataAsPoolString();
            if (tableString != null) {
                builder.append(tableString.getHtml());
            } else {
                builder.append(HexUtil.toHex8(data));
            }
        } else {
            builder.append(HexUtil.toHex8(data));
        }
        return builder.toString();
    }

    static class ValueStringReference
    implements ReferenceItem {
        private final ValueItem valueItem;

        ValueStringReference(ValueItem valueItem) {
            this.valueItem = valueItem;
        }

        @Override
        public int get() {
            return this.valueItem.getData();
        }

        @Override
        public void set(int value) {
            this.valueItem.writeData(value);
        }

        @Override
        public <T1 extends Block> T1 getReferredParent(Class<T1> parentClass) {
            ValueItem block = this.valueItem;
            if (parentClass.isInstance(block)) {
                return (T1)block;
            }
            return (T1)((Block)block.getParentInstance(parentClass));
        }
    }
}

