/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.graphics.AndroidColor;

public interface Value {
    public void setValue(EncodeResult var1);

    public void setValueType(ValueType var1);

    public ValueType getValueType();

    public int getData();

    public void setData(int var1);

    public String getValueAsString();

    public void setValueAsString(String var1);

    public PackageBlock getPackageBlock();

    public ParentChunk getParentChunk();

    default public AndroidColor getValueAsColor() {
        ValueType valueType = this.getValueType();
        if (valueType == null || !valueType.isColor()) {
            return null;
        }
        return AndroidColor.decode(ValueCoder.decode(valueType, this.getData()));
    }

    default public void setValue(AndroidColor color) {
        this.setValue(ValueCoder.encode(color.toHexString()));
    }

    default public ResourceEntry getValueAsReference() {
        TableBlock tableBlock;
        ValueType valueType = this.getValueType();
        if (valueType == null || !valueType.isReference()) {
            return null;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        int data = this.getData();
        ResourceEntry resourceEntry = packageBlock.getResource(data);
        if (resourceEntry == null && (tableBlock = packageBlock.getTableBlock()) != null) {
            resourceEntry = tableBlock.getResource(packageBlock, data);
        }
        return resourceEntry;
    }
}

