/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public abstract class TableEntry<HEADER extends ValueHeader, VALUE extends Block>
extends Block
implements JSONConvert<JSONObject> {
    private final HEADER header;
    private final VALUE resValue;

    TableEntry(HEADER header, VALUE resValue) {
        this.header = header;
        this.resValue = resValue;
        ((Block)this.header).setParent(this);
        ((Block)this.header).setIndex(0);
        ((Block)this.resValue).setParent(this);
        ((Block)this.resValue).setIndex(1);
    }

    public abstract Iterator<ValueItem> allValues();

    public Entry getParentEntry() {
        return this.getParent(Entry.class);
    }

    public void refresh() {
    }

    public final HEADER getHeader() {
        return this.header;
    }

    public VALUE getValue() {
        return this.resValue;
    }

    @Override
    public byte[] getBytes() {
        byte[] results = ((BlockItem)this.getHeader()).getBytes();
        results = TableEntry.addBytes(results, ((Block)this.getValue()).getBytes());
        return results;
    }

    @Override
    public int countBytes() {
        int result = ((BlockItem)this.getHeader()).countBytes();
        return result += ((Block)this.getValue()).countBytes();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        ((BlockItem)this.getHeader()).onCountUpTo(counter);
        ((Block)this.getValue()).onCountUpTo(counter);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        HEADER header = this.getHeader();
        ((Block)header).readBytes(reader);
        VALUE value = this.getValue();
        this.onHeaderLoaded(value, header);
        ((Block)value).readBytes(reader);
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        int result = ((Block)this.getHeader()).writeBytes(stream);
        return result += ((Block)this.getValue()).writeBytes(stream);
    }

    void onHeaderLoaded(VALUE value, HEADER header) {
    }

    abstract void onRemoved();

    abstract boolean canMerge(TableEntry<?, ?> var1);

    abstract void linkTableStringsInternal(TableStringPool var1);

    public abstract void merge(TableEntry<?, ?> var1);

    public abstract void mergeWithName(ResourceMergeOption var1, TableEntry<?, ?> var2);

    @Override
    public abstract JSONObject toJson();

    @Override
    public abstract void fromJson(JSONObject var1);

    public String toString() {
        return this.getHeader() + ", value={" + this.getValue() + "}";
    }
}

