/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.EntryHeader;
import com.reandroid.arsc.value.ResTableEntry;
import com.reandroid.arsc.value.ValueItem;
import java.io.IOException;

public class ResValue
extends ValueItem {
    private static final int OFFSET_SIZE = 0;

    public ResValue() {
        super(8, 0);
    }

    public boolean isCompact() {
        return this.getHeader().isCompact();
    }

    public void setCompact(boolean compact) {
        EntryHeader header = this.getHeader();
        if (compact == header.isCompact()) {
            return;
        }
        byte type = this.getType();
        int data = this.getData();
        this.updateBytesLength(compact);
        header.setCompact(compact);
        this.setType(type);
        this.setData(data);
        if (compact) {
            this.setRes0((byte)0);
        }
    }

    @Override
    public int getSize() {
        if (this.isCompact()) {
            return 0;
        }
        return super.getSize();
    }

    @Override
    public void setSize(int size) {
        if (!this.isCompact()) {
            super.setSize(size);
        }
    }

    @Override
    void updateSize() {
        if (!this.isCompact()) {
            super.updateSize();
        }
    }

    private void updateBytesLength(boolean compact) {
        int length = compact ? 0 : 8;
        this.setBytesLength(length, false);
    }

    private EntryHeader getHeader() {
        ResTableEntry resTableEntry = this.getParent(ResTableEntry.class);
        if (resTableEntry != null) {
            return (EntryHeader)resTableEntry.getHeader();
        }
        throw new RuntimeException("Unreachable");
    }

    public Entry getEntry() {
        return this.getParent(Entry.class);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean compact = this.isCompact();
        this.updateBytesLength(compact);
        if (!compact) {
            super.onReadBytes(reader);
        }
    }

    @Override
    public int getData() {
        if (this.isCompact()) {
            return this.getHeader().getData();
        }
        return super.getData();
    }

    @Override
    void writeData(int data) {
        if (this.isCompact()) {
            this.getHeader().setData(data);
        } else {
            super.writeData(data);
        }
    }

    @Override
    public byte getType() {
        if (this.isCompact()) {
            return this.getHeader().getType();
        }
        return super.getType();
    }

    @Override
    public void setType(byte type) {
        if (this.isCompact()) {
            this.getHeader().setType(type);
        } else {
            super.setType(type);
        }
    }

    @Override
    public PackageBlock getParentChunk() {
        Entry entry = this.getEntry();
        if (entry != null) {
            return entry.getPackageBlock();
        }
        return null;
    }
}

