/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.value.ResConfigValueContainer;
import java.io.IOException;

class ResConfigBase
extends FixedBlockContainer
implements BlockLoad {
    private final IntegerItem configSize;
    private final ResConfigValueContainer mValuesContainer;
    public static final int SIZE_16 = 16;
    public static final int SIZE_28 = 28;
    public static final int SIZE_32 = 32;
    public static final int SIZE_36 = 36;
    public static final int SIZE_48 = 48;
    public static final int SIZE_52 = 52;
    public static final int SIZE_56 = 56;
    public static final int SIZE_64 = 64;
    private static final int OFFSET_mcc = 0;
    private static final int OFFSET_mnc = 2;
    private static final int OFFSET_language = 4;
    private static final int OFFSET_region = 6;
    private static final int OFFSET_orientation = 8;
    private static final int OFFSET_touchscreen = 9;
    private static final int OFFSET_density = 10;
    private static final int OFFSET_keyboard = 12;
    private static final int OFFSET_navigation = 13;
    private static final int OFFSET_inputFlags = 14;
    private static final int OFFSET_gender = 15;
    private static final int OFFSET_screenWidth = 16;
    private static final int OFFSET_screenHeight = 18;
    private static final int OFFSET_sdkVersion = 20;
    private static final int OFFSET_minorVersion = 22;
    private static final int OFFSET_screenLayout = 24;
    private static final int OFFSET_uiMode = 25;
    private static final int OFFSET_smallestScreenWidthDp = 26;
    private static final int OFFSET_screenWidthDp = 28;
    private static final int OFFSET_screenHeightDp = 30;
    private static final int OFFSET_localeScript = 32;
    private static final int OFFSET_localeVariant = 36;
    private static final int OFFSET_screenLayout2 = 44;
    private static final int OFFSET_colorMode = 45;
    private static final int OFFSET_reservedColorModePadding = 46;
    private static final int OFFSET_unknown = 48;
    static final int LEN_localeScript = 4;
    static final int LEN_localeVariant = 8;
    public static final String NAME_mcc = "mcc";
    public static final String NAME_mnc = "mnc";
    public static final String NAME_language = "language";
    public static final String NAME_region = "region";
    public static final String NAME_orientation = "orientation";
    public static final String NAME_touchscreen = "touchscreen";
    public static final String NAME_density = "density";
    public static final String NAME_keyboard = "keyboard";
    public static final String NAME_navigation = "navigation";
    public static final String NAME_input_flags_keys_hidden = "input_flags_keys_hidden";
    public static final String NAME_input_flags_nav_hidden = "input_flags_nav_hidden";
    public static final String NAME_gender = "gender";
    public static final String NAME_screenWidth = "screenWidth";
    public static final String NAME_screenHeight = "screenHeight";
    public static final String NAME_sdkVersion = "sdkVersion";
    public static final String NAME_minorVersion = "minorVersion";
    public static final String NAME_screen_layout_size = "screen_layout_size";
    public static final String NAME_screen_layout_long = "screen_layout_long";
    public static final String NAME_screen_layout_dir = "screen_layout_dir";
    public static final String NAME_ui_mode_type = "ui_mode_type";
    public static final String NAME_ui_mode_night = "ui_mode_night";
    public static final String NAME_smallestScreenWidthDp = "smallestScreenWidthDp";
    public static final String NAME_screenWidthDp = "screenWidthDp";
    public static final String NAME_screenHeightDp = "screenHeightDp";
    public static final String NAME_localeScript = "localeScript";
    public static final String NAME_localeVariant = "localeVariant";
    public static final String NAME_screen_layout_round = "screen_layout_round";
    public static final String NAME_color_mode_wide = "color_mode_wide";
    public static final String NAME_color_mode_hdr = "color_mode_hdr";
    public static final String NAME_unknownBytes = "unknown_bytes";
    public static final String UNKNOWN_BYTES = "unknown_bytes";
    public static final String NAME_config_size = "config_size";

    public ResConfigBase(int size) {
        super(2);
        this.configSize = new IntegerItem(size);
        this.mValuesContainer = new ResConfigValueContainer(size - 4, this.configSize);
        this.addChild(0, this.configSize);
        this.addChild(1, this.mValuesContainer);
        this.configSize.setBlockLoad(this);
    }

    public int getConfigSize() {
        return this.configSize.get();
    }

    public boolean trimToSize(int size) {
        int current = this.getConfigSize();
        if (current == size) {
            return true;
        }
        if (!ResConfigBase.isValidSize(size)) {
            return false;
        }
        if (current < size) {
            this.setConfigSize(size);
            return true;
        }
        int offset = size - 4;
        int len = current - 4 - offset;
        byte[] bts = this.mValuesContainer.getByteArray(offset, len);
        if (!ResConfigBase.isNullBytes(bts)) {
            return false;
        }
        this.setConfigSize(size);
        return true;
    }

    public void trimToMinimumSize() {
        int size = ByteArray.trimTrailZeros(this.mValuesContainer.getBytes()).length + 4;
        size = ResConfigBase.nearestSize(size);
        this.trimToSize(size);
    }

    public void setConfigSize(int size) {
        if (!ResConfigBase.isValidSize(size)) {
            throw new IllegalArgumentException("Invalid config size = " + size);
        }
        if (size % 4 != 0) {
            size += 4 - size % 4;
        }
        this.configSize.set(size);
        this.mValuesContainer.setSize(size -= 4);
    }

    void resetValueBytes() {
        this.mValuesContainer.fill((byte)0);
    }

    void setValueBytes(byte[] bytes) {
        this.setConfigSize(bytes.length + 4);
        this.mValuesContainer.putByteArray(0, bytes);
    }

    byte[] getValueBytes() {
        return this.mValuesContainer.getBytes();
    }

    public void setMcc(int value) {
        this.mValuesContainer.setShortValue(0, value);
    }

    public int getMcc() {
        return this.mValuesContainer.getShortValue(0);
    }

    public void setMnc(int value) {
        this.mValuesContainer.setShortValue(2, value);
    }

    public int getMnc() {
        return this.mValuesContainer.getShortValue(2);
    }

    public byte[] getLanguageBytes() {
        if (this.getConfigSize() < 16) {
            return new byte[2];
        }
        return this.mValuesContainer.getByteArrayValue(4, 2);
    }

    public void setLanguageBytes(byte[] bytes) {
        this.mValuesContainer.setByteArrayValue(4, bytes, 2);
    }

    public byte[] getRegionBytes() {
        return this.mValuesContainer.getByteArrayValue(6, 2);
    }

    public void setRegionBytes(byte[] bytes) {
        this.mValuesContainer.setByteArrayValue(6, bytes, 2);
    }

    public void setOrientation(int orientation) {
        this.mValuesContainer.setByteValue(8, orientation);
    }

    public int getOrientationValue() {
        return this.mValuesContainer.getByteValue(8);
    }

    public void setTouchscreen(int touchscreen) {
        this.mValuesContainer.setByteValue(9, touchscreen);
    }

    public int getTouchscreenValue() {
        return this.mValuesContainer.getByteValue(9);
    }

    public void setDensity(int density) {
        this.mValuesContainer.setShortValue(10, density);
    }

    public int getDensityValue() {
        return this.mValuesContainer.getShortValue(10);
    }

    public void setKeyboard(int keyboard) {
        this.mValuesContainer.setByteValue(12, keyboard);
    }

    public int getKeyboardValue() {
        return this.mValuesContainer.getByteValue(12);
    }

    public void setNavigation(int navigation) {
        this.mValuesContainer.setByteValue(13, navigation);
    }

    public int getNavigationValue() {
        return this.mValuesContainer.getByteValue(13);
    }

    public void setInputFlags(int inputFlags) {
        this.mValuesContainer.setByteValue(14, inputFlags);
    }

    public int getInputFlagsValue() {
        return this.mValuesContainer.getByteValue(14);
    }

    public void setGenderValue(int value) {
        this.mValuesContainer.setByteValue(15, value);
    }

    public int getGenderValue() {
        return this.mValuesContainer.getByteValue(15);
    }

    public void setScreenWidth(int value) {
        this.mValuesContainer.setShortValue(16, value);
    }

    public int getScreenWidth() {
        return this.mValuesContainer.getShortValue(16);
    }

    public void setScreenHeight(int value) {
        this.mValuesContainer.setShortValue(18, value);
    }

    public int getScreenHeight() {
        return this.mValuesContainer.getShortValue(18);
    }

    public void setSdkVersion(int value) {
        this.mValuesContainer.setShortValue(20, value);
    }

    public int getSdkVersion() {
        return this.mValuesContainer.getShortValue(20);
    }

    public void setMinorVersion(int value) {
        this.mValuesContainer.setShortValue(22, value);
    }

    public int getMinorVersion() {
        return this.mValuesContainer.getShortValue(22);
    }

    public void setScreenLayout(int value) {
        this.mValuesContainer.setByteValue(24, value);
    }

    public int getScreenLayout() {
        return this.mValuesContainer.getByteValue(24);
    }

    public void setUiMode(int mode) {
        this.mValuesContainer.setByteValue(25, mode);
    }

    public int getUiMode() {
        return this.mValuesContainer.getByteValue(25);
    }

    public void setSmallestScreenWidthDp(int value) {
        this.mValuesContainer.setShortValue(26, value);
    }

    public int getSmallestScreenWidthDp() {
        return this.mValuesContainer.getShortValue(26);
    }

    public void setScreenWidthDp(int value) {
        this.mValuesContainer.setShortValue(28, value);
    }

    public int getScreenWidthDp() {
        return this.mValuesContainer.getShortValue(28);
    }

    public void setScreenHeightDp(int value) {
        this.mValuesContainer.setShortValue(30, value);
    }

    public int getScreenHeightDp() {
        return this.mValuesContainer.getShortValue(30);
    }

    public void setLocaleScript(byte[] bts) {
        this.mValuesContainer.setByteArrayValue(32, bts, 4);
    }

    public byte[] getLocaleScriptBytes() {
        return this.mValuesContainer.getByteArrayValue(32, 4);
    }

    public void setLocaleVariant(byte[] bts) {
        this.mValuesContainer.setByteArrayValue(36, bts, 8);
    }

    public byte[] getLocaleVariantBytes() {
        return this.mValuesContainer.getByteArrayValue(36, 8);
    }

    public void setScreenLayout2(int screenLayout2) {
        this.mValuesContainer.setByteValue(44, screenLayout2);
    }

    public int getScreenLayout2() {
        return this.mValuesContainer.getByteValue(44);
    }

    public void setColorMode(int colorMode) {
        this.mValuesContainer.setByteValue(45, colorMode);
    }

    public int getColorMode() {
        return this.mValuesContainer.getByteValue(45);
    }

    public void setReservedColorModePadding(int value) {
        this.mValuesContainer.setByteValue(46, value);
    }

    public int getReservedColorModePadding() {
        return this.mValuesContainer.getByteValue(46);
    }

    public void setUnknownBytes(byte[] bytes) {
        int length = this.getConfigSize() - 4 - 48;
        if (bytes.length > length) {
            length = bytes.length;
        }
        this.mValuesContainer.setByteArrayValue(48, bytes, length);
    }

    public byte[] getUnknownBytes() {
        return this.mValuesContainer.getByteArrayValue(48, this.getConfigSize() - 4 - 48);
    }

    @Override
    protected void onPreRefresh() {
        int count = this.countBytes();
        this.configSize.set(count);
    }

    @Override
    protected void onRefreshed() {
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.configSize) {
            this.mValuesContainer.setSize(this.configSize.get() - 4);
        }
    }

    public static int nearestSize(int size) {
        if (size <= 16) {
            return 16;
        }
        if (size <= 28) {
            return 28;
        }
        if (size <= 32) {
            return 32;
        }
        if (size <= 36) {
            return 36;
        }
        if (size <= 48) {
            return 48;
        }
        if (size <= 52) {
            return 52;
        }
        if (size <= 56) {
            return 56;
        }
        if (size <= 64) {
            return 64;
        }
        return size + (4 - size % 4) % size;
    }

    public static boolean isValidSize(int size) {
        switch (size) {
            case 16: 
            case 28: 
            case 32: 
            case 36: 
            case 48: 
            case 52: 
            case 56: 
            case 64: {
                return true;
            }
        }
        return size > 64;
    }

    static byte[] toByteArray(char[] chs, int len) {
        byte[] bts = new byte[len];
        if (chs == null) {
            return bts;
        }
        int sz = chs.length;
        for (int i = 0; i < sz; ++i) {
            bts[i] = (byte)chs[i];
        }
        return bts;
    }

    static char[] toCharArray(byte[] bts) {
        if (ResConfigBase.isNullBytes(bts)) {
            return null;
        }
        int sz = bts.length;
        char[] chs = new char[sz];
        for (int i = 0; i < sz; ++i) {
            int val = 0xFF & bts[i];
            chs[i] = (char)val;
        }
        return chs;
    }

    static char[] trimEndingZero(char[] chars) {
        if (chars == null) {
            return null;
        }
        int lastNonZero = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\u0000') continue;
            lastNonZero = i;
        }
        if (lastNonZero == -1) {
            return null;
        }
        if (++lastNonZero == chars.length) {
            return chars;
        }
        char[] result = new char[lastNonZero];
        System.arraycopy(chars, 0, result, 0, lastNonZero);
        return result;
    }

    static byte[] trimEndingZero(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int lastNonZero = -1;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 0) continue;
            lastNonZero = i;
        }
        if (lastNonZero == -1) {
            return null;
        }
        if (++lastNonZero == bytes.length) {
            return bytes;
        }
        byte[] result = new byte[lastNonZero];
        System.arraycopy(bytes, 0, result, 0, lastNonZero);
        return result;
    }

    static boolean isNullChars(char[] chars) {
        if (chars == null) {
            return true;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\u0000') continue;
            return false;
        }
        return true;
    }

    static boolean isNullBytes(byte[] bytes) {
        if (bytes == null) {
            return true;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    static String ensureLength(String str, int min, char postfix) {
        int length = str.length();
        if (length >= min) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(str);
        int remain = min - length;
        for (int i = 0; i < remain; ++i) {
            builder.append(postfix);
        }
        return builder.toString();
    }

    static String trimPostfix(String str, char postfix) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        int index = length - 1;
        while (length > 0 && str.charAt(index) == postfix) {
            str = str.substring(0, index);
            length = str.length();
            index = length - 1;
        }
        return str;
    }
}

