/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.value.ResConfigBase;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResConfig
extends ResConfigBase
implements JSONConvert<JSONObject>,
Comparable<ResConfig> {
    private String mQualifiers;
    private int mQualifiersStamp = 0;
    private static final ResConfig DEFAULT_INSTANCE = new ResConfig(16);
    private static final char POSTFIX_locale = '#';

    public ResConfig() {
        this(64);
    }

    private ResConfig(int size) {
        super(size);
    }

    public boolean isEqualOrMoreSpecificThan(ResConfig resConfig) {
        if (resConfig == null) {
            return false;
        }
        if (resConfig == this || resConfig.isDefault()) {
            return true;
        }
        byte[] bytes = ByteArray.trimTrailZeros(this.getValueBytes());
        byte[] otherBytes = ByteArray.trimTrailZeros(resConfig.getValueBytes());
        int max = otherBytes.length;
        if (max > bytes.length) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            byte other = otherBytes[i];
            if (other == 0 || bytes[i] == other) continue;
            return false;
        }
        return true;
    }

    public void copyFrom(ResConfig resConfig) {
        if (resConfig == this || resConfig == null) {
            return;
        }
        this.setValueBytes(resConfig.getValueBytes());
    }

    public String[] parseQualifiers(String qualifiers) {
        QualifierParser parser = new QualifierParser(this, qualifiers);
        parser.parse();
        return parser.getErrors();
    }

    public String getLocale() {
        StringBuilder builder = new StringBuilder();
        String str = this.getLanguage();
        if (str != null) {
            builder.append(str);
        }
        if ((str = this.getRegion()) != null) {
            if (builder.length() != 0) {
                builder.append('-');
            }
            builder.append(str);
        }
        if ((str = this.getLocaleScriptInternal()) != null) {
            if (builder.length() != 0) {
                builder.append('-');
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public String[] parseLocale(String locale) {
        QualifierParser parser = new QualifierParser(this, locale);
        parser.parseLocale();
        return parser.getErrors();
    }

    public char[] getLanguageChars() {
        byte[] bytes = this.getLanguageBytes();
        return ResConfig.unPackLanguage(bytes[0], bytes[1]);
    }

    public void setLanguage(char[] chars) {
        this.setLanguageBytes(ResConfig.packLanguage(chars));
    }

    public void setLanguage(String language) {
        char[] chs = null;
        if (language != null) {
            chs = language.toCharArray();
        }
        this.setLanguage(chs);
    }

    public String getLanguage() {
        char[] chars = this.getLanguageChars();
        if (ResConfig.isNullChars(chars)) {
            return null;
        }
        return new String(chars);
    }

    public char[] getRegionChars() {
        byte[] bytes = this.getRegionBytes();
        return ResConfig.unPackRegion(bytes[0], bytes[1]);
    }

    public void setRegion(char[] chars) {
        this.setRegionBytes(ResConfig.packRegion(chars));
    }

    public void setRegion(String region) {
        char[] chars = null;
        if (region != null) {
            if (region.length() == 3 && region.charAt(0) == 'r') {
                region = region.substring(1);
            }
            chars = region.toCharArray();
        }
        this.setRegion(chars);
    }

    public String getRegion() {
        char[] chars = this.getRegionChars();
        if (ResConfig.isNullChars(chars)) {
            return null;
        }
        return new String(chars);
    }

    public Orientation getOrientation() {
        return Orientation.valueOf(this.getOrientationValue());
    }

    public void setOrientation(Orientation orientation) {
        this.setOrientation(Orientation.update(orientation, this.getOrientationValue()));
    }

    public Touchscreen getTouchscreen() {
        return Touchscreen.valueOf(this.getTouchscreenValue());
    }

    public void setTouchscreen(Touchscreen touchscreen) {
        this.setTouchscreen(Touchscreen.update(touchscreen, this.getTouchscreenValue()));
    }

    public Density getDensity() {
        return Density.valueOf(this.getDensityValue());
    }

    public void setDensity(Density density) {
        this.setDensity(Density.update(density, this.getDensityValue()));
    }

    public Keyboard getKeyboard() {
        return Keyboard.valueOf(this.getKeyboardValue());
    }

    public void setKeyboard(Keyboard keyboard) {
        this.setKeyboard(Keyboard.update(keyboard, this.getKeyboardValue()));
    }

    public Navigation getNavigation() {
        return Navigation.valueOf(this.getNavigationValue());
    }

    public void setNavigation(Navigation navigation) {
        this.setNavigation(Navigation.update(navigation, this.getNavigationValue()));
    }

    public InputFlagsKeysHidden getInputFlagsKeysHidden() {
        return InputFlagsKeysHidden.valueOf(this.getInputFlagsValue());
    }

    public void setInputFlagsKeysHidden(InputFlagsKeysHidden keysHidden) {
        this.setInputFlags(InputFlagsKeysHidden.update(keysHidden, this.getInputFlagsValue()));
    }

    public InputFlagsNavHidden getInputFlagsNavHidden() {
        return InputFlagsNavHidden.valueOf(this.getInputFlagsValue());
    }

    public void setInputFlagsNavHidden(InputFlagsNavHidden navHidden) {
        this.setInputFlags(InputFlagsNavHidden.update(navHidden, this.getInputFlagsValue()));
    }

    public Gender getGender() {
        return Gender.valueOf(this.getGenderValue());
    }

    public void setGender(Gender gender) {
        this.setGenderValue(Gender.update(gender, this.getGenderValue()));
    }

    public void setScreenSize(int width, int height) {
        this.setScreenWidth(width);
        this.setScreenHeight(height);
    }

    public ScreenLayoutSize getScreenLayoutSize() {
        return ScreenLayoutSize.valueOf(this.getScreenLayout());
    }

    public void setScreenLayoutSize(ScreenLayoutSize layoutSize) {
        this.setScreenLayout(ScreenLayoutSize.update(layoutSize, this.getScreenLayout()));
    }

    public ScreenLayoutLong getScreenLayoutLong() {
        return ScreenLayoutLong.valueOf(this.getScreenLayout());
    }

    public void setScreenLayoutLong(ScreenLayoutLong layoutLong) {
        this.setScreenLayout(ScreenLayoutLong.update(layoutLong, this.getScreenLayout()));
    }

    public ScreenLayoutDir getScreenLayoutDir() {
        return ScreenLayoutDir.valueOf(this.getScreenLayout());
    }

    public void setScreenLayoutDir(ScreenLayoutDir layoutDir) {
        this.setScreenLayout(ScreenLayoutDir.update(layoutDir, this.getScreenLayout()));
    }

    public UiModeType getUiModeType() {
        return UiModeType.valueOf(this.getUiMode());
    }

    public void setUiModeType(UiModeType uiModeType) {
        this.setUiMode(UiModeType.update(uiModeType, this.getUiMode()));
    }

    public UiModeNight getUiModeNight() {
        return UiModeNight.valueOf(this.getUiMode());
    }

    public void setUiModeNight(UiModeNight uiModeNight) {
        this.setUiMode(UiModeNight.update(uiModeNight, this.getUiMode()));
    }

    public void setLocaleScript(char[] chs) {
        byte[] bts = ResConfig.toByteArray(chs, 4);
        this.setLocaleScript(bts);
    }

    public void setLocaleScript(String script) {
        char[] chs = null;
        if ((script = ResConfig.trimPostfix(script, '#')) != null) {
            chs = script.toCharArray();
        }
        this.setLocaleScript(chs);
    }

    public char[] getLocaleScriptChars() {
        return ResConfig.trimEndingZero(ResConfig.toCharArray(this.getLocaleScriptBytes()));
    }

    private String getLocaleScriptInternal() {
        char[] chs = this.getLocaleScriptChars();
        if (chs == null) {
            return null;
        }
        return new String(chs);
    }

    public String getLocaleScript() {
        String script = this.getLocaleScriptInternal();
        if (script == null) {
            return null;
        }
        script = ResConfig.ensureLength(script, 3, '#');
        return script;
    }

    public void setLocaleVariant(char[] chs) {
        byte[] bts = ResConfig.toByteArray(chs, 8);
        this.setLocaleVariant(bts);
    }

    public void setLocaleVariant(String variant) {
        if (variant != null) {
            variant = variant.toLowerCase();
        }
        this.setLocaleVariantInternal(variant);
    }

    private void setLocaleVariantInternal(String variant) {
        char[] chs = null;
        if ((variant = ResConfig.trimPostfix(variant, '#')) != null) {
            chs = variant.toCharArray();
        }
        this.setLocaleVariant(chs);
    }

    public char[] getLocaleVariantChars() {
        return ResConfig.trimEndingZero(ResConfig.toCharArray(this.getLocaleVariantBytes()));
    }

    private String getLocaleVariantInternal() {
        char[] chs = this.getLocaleVariantChars();
        if (chs == null) {
            return null;
        }
        return new String(chs);
    }

    public String getLocaleVariant() {
        String variant = this.getLocaleVariantInternal();
        if (variant == null) {
            return null;
        }
        variant = ResConfig.ensureLength(variant, 5, '#');
        return variant.toUpperCase();
    }

    public ScreenLayoutRound getScreenLayoutRound() {
        return ScreenLayoutRound.valueOf(this.getScreenLayout2());
    }

    public void setScreenLayoutRound(ScreenLayoutRound layoutRound) {
        this.setScreenLayout2(ScreenLayoutRound.update(layoutRound, this.getScreenLayout2()));
    }

    public ColorModeWide getColorModeWide() {
        return ColorModeWide.valueOf(this.getColorMode());
    }

    public void setColorModeWide(ColorModeWide colorModeWide) {
        this.setColorMode(ColorModeWide.update(colorModeWide, this.getColorMode()));
    }

    public ColorModeHdr getColorModeHdr() {
        return ColorModeHdr.valueOf(this.getColorMode());
    }

    public void setColorModeHdr(ColorModeHdr colorModeHdr) {
        this.setColorMode(ColorModeHdr.update(colorModeHdr, this.getColorMode()));
    }

    public String getUnknownHexBytes() {
        return this.getUnknownHexBytes(8);
    }

    public String getUnknownHexBytes(int limit) {
        byte[] bytes = ResConfig.trimEndingZero(this.getUnknownBytes());
        if (ResConfig.isNullBytes(bytes)) {
            return null;
        }
        String result = null;
        if (limit < 0) {
            limit = bytes.length;
        }
        if (bytes.length < limit) {
            limit = bytes.length;
        }
        for (int i = 0; i < limit; ++i) {
            result = HexUtil.toHex2(result, bytes[i]);
        }
        return result;
    }

    public void setUnknownBytes(String hexBytes) {
        if (hexBytes == null || hexBytes.length() == 0) {
            return;
        }
        int length = hexBytes.length();
        if (length % 2 != 0) {
            return;
        }
        char[] chars = hexBytes.toCharArray();
        length = chars.length;
        byte[] bytes = new byte[length / 2];
        try {
            for (int i = 0; i < length; i += 2) {
                bytes[i / 2] = (byte)HexUtil.parseHex(new String(chars, i, 2));
            }
        }
        catch (NumberFormatException ignored) {
            return;
        }
        this.setUnknownBytes(bytes);
    }

    public String getQualifiers() {
        int hash = this.hashCode();
        if (this.mQualifiers == null || this.mQualifiersStamp != hash) {
            this.mQualifiers = new QualifierBuilder(this).build();
            this.mQualifiersStamp = hash;
        }
        return this.mQualifiers;
    }

    public boolean isEqualQualifiers(String qualifiers) {
        return this.equals(ResConfig.parse(qualifiers));
    }

    public boolean isDefault() {
        return ResConfig.isNullBytes(this.getValueBytes());
    }

    @Override
    public JSONObject toJson() {
        String str;
        JSONObject jsonObject = new JSONObject();
        if (this.isDefault()) {
            return jsonObject;
        }
        int val = this.getMcc();
        if (val != 0) {
            jsonObject.put("mcc", val);
        }
        if ((val = this.getMnc()) != 0) {
            jsonObject.put("mnc", val);
        }
        if ((str = this.getLanguage()) != null) {
            jsonObject.put("language", str);
        }
        if ((str = this.getRegion()) != null) {
            jsonObject.put("region", str);
        }
        jsonObject.put("orientation", Flag.toString(this.getOrientation()));
        jsonObject.put("touchscreen", Flag.toString(this.getTouchscreen()));
        jsonObject.put("density", Flag.toString(this.getDensity()));
        jsonObject.put("keyboard", Flag.toString(this.getKeyboard()));
        jsonObject.put("navigation", Flag.toString(this.getNavigation()));
        jsonObject.put("input_flags_keys_hidden", Flag.toString(this.getInputFlagsKeysHidden()));
        jsonObject.put("input_flags_nav_hidden", Flag.toString(this.getInputFlagsNavHidden()));
        jsonObject.put("gender", Flag.toString(this.getGender()));
        val = this.getScreenWidth();
        if (val != 0) {
            jsonObject.put("screenWidth", val);
        }
        if ((val = this.getScreenHeight()) != 0) {
            jsonObject.put("screenHeight", val);
        }
        if ((val = this.getSdkVersion()) != 0) {
            jsonObject.put("sdkVersion", val);
        }
        if ((val = this.getMinorVersion()) != 0) {
            jsonObject.put("minorVersion", val);
        }
        jsonObject.put("screen_layout_size", Flag.toString(this.getScreenLayoutSize()));
        jsonObject.put("screen_layout_long", Flag.toString(this.getScreenLayoutLong()));
        jsonObject.put("screen_layout_dir", Flag.toString(this.getScreenLayoutDir()));
        jsonObject.put("ui_mode_type", Flag.toString(this.getUiModeType()));
        jsonObject.put("ui_mode_night", Flag.toString(this.getUiModeNight()));
        val = this.getSmallestScreenWidthDp();
        if (val != 0) {
            jsonObject.put("smallestScreenWidthDp", val);
        }
        if ((val = this.getScreenWidthDp()) != 0) {
            jsonObject.put("screenWidthDp", val);
        }
        if ((val = this.getScreenHeightDp()) != 0) {
            jsonObject.put("screenHeightDp", val);
        }
        if ((str = this.getLocaleScriptInternal()) != null) {
            jsonObject.put("localeScript", str);
        }
        if ((str = this.getLocaleVariantInternal()) != null) {
            jsonObject.put("localeVariant", str);
        }
        jsonObject.put("screen_layout_round", Flag.toString(this.getScreenLayoutRound()));
        jsonObject.put("color_mode_wide", Flag.toString(this.getColorModeWide()));
        jsonObject.put("color_mode_hdr", Flag.toString(this.getColorModeHdr()));
        str = this.getUnknownHexBytes(-1);
        if (str != null) {
            jsonObject.put("unknown_bytes", str);
            jsonObject.put("config_size", this.getConfigSize());
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        if (json.isEmpty()) {
            this.resetValueBytes();
            return;
        }
        int configSize = json.optInt("config_size", 0);
        if (configSize == 0) {
            configSize = 64;
        }
        this.trimToSize(configSize);
        this.setMcc(json.optInt("mcc"));
        this.setMnc(json.optInt("mnc"));
        this.setLanguage(json.optString("language"));
        this.setRegion(json.optString("region"));
        this.setOrientation(Orientation.valueOf(json.optString("orientation")));
        this.setTouchscreen(Touchscreen.valueOf(json.optString("touchscreen")));
        this.setDensity(Density.valueOf(json.optString("density")));
        this.setKeyboard(Keyboard.valueOf(json.optString("keyboard")));
        this.setNavigation(Navigation.valueOf(json.optString("navigation")));
        this.setInputFlagsKeysHidden(InputFlagsKeysHidden.valueOf(json.optString("input_flags_keys_hidden")));
        this.setInputFlagsNavHidden(InputFlagsNavHidden.valueOf(json.optString("input_flags_nav_hidden")));
        this.setGender(Gender.valueOf(json.optString("gender")));
        this.setScreenWidth(json.optInt("screenWidth"));
        this.setScreenHeight(json.optInt("screenHeight"));
        this.setSdkVersion(json.optInt("sdkVersion"));
        this.setMinorVersion(json.optInt("minorVersion"));
        this.setScreenLayoutSize(ScreenLayoutSize.valueOf(json.optString("screen_layout_size")));
        this.setScreenLayoutLong(ScreenLayoutLong.valueOf(json.optString("screen_layout_long")));
        this.setScreenLayoutDir(ScreenLayoutDir.valueOf(json.optString("screen_layout_dir")));
        this.setUiModeType(UiModeType.valueOf(json.optString("ui_mode_type")));
        this.setUiModeNight(UiModeNight.valueOf(json.optString("ui_mode_night")));
        this.setSmallestScreenWidthDp(json.optInt("smallestScreenWidthDp"));
        this.setScreenWidthDp(json.optInt("screenWidthDp"));
        this.setScreenHeightDp(json.optInt("screenHeightDp"));
        this.setLocaleScript(json.optString("localeScript"));
        this.setLocaleVariantInternal(json.optString("localeVariant"));
        this.setScreenLayoutRound(ScreenLayoutRound.valueOf(json.optString("screen_layout_round")));
        this.setColorModeWide(ColorModeWide.valueOf(json.optString("color_mode_wide")));
        this.setColorModeHdr(ColorModeHdr.valueOf(json.optString("color_mode_hdr")));
        this.setUnknownBytes(json.optString("unknown_bytes"));
    }

    public int hashCode() {
        byte[] bts = ByteArray.trimTrailZeros(this.getValueBytes());
        return Arrays.hashCode(bts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ResConfig) {
            ResConfig other = (ResConfig)obj;
            byte[] bts1 = this.getValueBytes();
            byte[] bts2 = other.getValueBytes();
            return ByteArray.equalsIgnoreTrailZero(bts1, bts2);
        }
        return false;
    }

    public String toString() {
        String q = this.getQualifiers();
        if (q.length() == 0) {
            q = "DEFAULT";
        }
        return "[" + q + "]";
    }

    @Override
    public int compareTo(ResConfig resConfig) {
        return this.getQualifiers().compareTo(resConfig.getQualifiers());
    }

    public static ResConfig parse(String qualifiers) {
        ResConfig resConfig = new ResConfig();
        resConfig.parseQualifiers(qualifiers);
        return resConfig;
    }

    public static ResConfig getDefault() {
        ResConfig resConfig = DEFAULT_INSTANCE;
        if (resConfig.isDefault()) {
            return resConfig;
        }
        resConfig.resetValueBytes();
        resConfig.setConfigSize(16);
        return resConfig;
    }

    private static char[] unPackLanguage(byte in0, byte in1) {
        return ResConfig.unpackLanguageOrRegion(in0, in1, 'a');
    }

    private static char[] unPackRegion(byte in0, byte in1) {
        return ResConfig.unpackLanguageOrRegion(in0, in1, '0');
    }

    private static char[] unpackLanguageOrRegion(byte in0, byte in1, char base) {
        char[] out;
        if ((in0 & 0x80) != 0) {
            out = new char[3];
            byte first = (byte)(in1 & 0x1F);
            byte second = (byte)(((in1 & 0xE0) >> 5) + ((in0 & 3) << 3));
            byte third = (byte)((in0 & 0x7C) >> 2);
            out[0] = (char)(first + base);
            out[1] = (char)(second + base);
            out[2] = (char)(third + base);
        } else {
            out = in0 != 0 && in1 != 0 ? new char[]{(char)in0, (char)in1} : new char[2];
        }
        return out;
    }

    private static byte[] packLanguage(char[] language) {
        return ResConfig.packLanguageOrRegion(language, 'a');
    }

    private static byte[] packRegion(char[] region) {
        return ResConfig.packLanguageOrRegion(region, '0');
    }

    private static byte[] packLanguageOrRegion(char[] in, char base) {
        byte[] out = new byte[2];
        if (in == null || in.length < 2) {
            return out;
        }
        if (in.length == 2 || in[2] == '\u0000' || in[2] == '-') {
            out[0] = (byte)in[0];
            out[1] = (byte)in[1];
        } else {
            byte first = (byte)(in[0] - base & 0x7F);
            byte second = (byte)(in[1] - base & 0x7F);
            byte third = (byte)(in[2] - base & 0x7F);
            out[0] = (byte)(0x80 | third << 2 | second >> 3);
            out[1] = (byte)(second << 5 | first);
        }
        return out;
    }

    static class QualifierParser {
        private final ResConfig mConfig;
        private final String[] mQualifiers;
        private final int mPreferredSize;
        private boolean mEmpty;
        private boolean mLanguageRegionParsed;
        private boolean mParseComplete;
        private static final Pattern PATTERN_PREFIX_NUMBER = Pattern.compile("^([mcnv]+)([0-9]+)$");
        private static final Pattern PATTERN_DP = Pattern.compile("^([swh]+)([0-9]+)dp$");
        private static final Pattern PATTERN_WIDTH_HEIGHT = Pattern.compile("^([0-9]+)[xX]([0-9]+)$");
        private static final Pattern PATTERN_LOCALE_NUMBERING_SYSTEM = Pattern.compile("^u\\+nu\\+(.{1,8})$");
        private static final Pattern PATTERN_LOCALE_SCRIPT_VARIANT = Pattern.compile("^b(\\+[a-z]{2})?(\\+r[A-Z]{2})?(\\+[A-Z][a-z]{3})?(\\+[A-Z]{2,8})?$");

        public QualifierParser(ResConfig resConfig, String[] qualifiers) {
            this.mConfig = resConfig;
            this.mQualifiers = qualifiers;
            this.mPreferredSize = resConfig.getConfigSize();
        }

        public QualifierParser(ResConfig resConfig, String qualifiers) {
            this(resConfig, QualifierParser.splitQualifiers(qualifiers));
        }

        public void parse() {
            if (this.mParseComplete) {
                return;
            }
            if (this.isEmpty()) {
                this.onParseComplete();
                return;
            }
            ResConfig resConfig = this.mConfig;
            resConfig.setConfigSize(64);
            this.parsePrefixedNumber();
            this.parseDp();
            this.parseWidthHeight();
            this.parseLocaleNumberingSystem();
            this.parseUnknownBytes();
            if (this.isEmpty()) {
                this.onParseComplete();
                return;
            }
            String[] qualifiers = this.mQualifiers;
            resConfig.setOrientation(Orientation.fromQualifiers(qualifiers));
            resConfig.setTouchscreen(Touchscreen.fromQualifiers(qualifiers));
            resConfig.setDensity(Density.fromQualifiers(qualifiers));
            resConfig.setKeyboard(Keyboard.fromQualifiers(qualifiers));
            resConfig.setNavigation(Navigation.fromQualifiers(qualifiers));
            if (this.isEmpty()) {
                this.onParseComplete();
                return;
            }
            resConfig.setInputFlagsKeysHidden(InputFlagsKeysHidden.fromQualifiers(qualifiers));
            resConfig.setInputFlagsNavHidden(InputFlagsNavHidden.fromQualifiers(qualifiers));
            resConfig.setGender(Gender.fromQualifiers(qualifiers));
            resConfig.setScreenLayoutSize(ScreenLayoutSize.fromQualifiers(qualifiers));
            resConfig.setScreenLayoutLong(ScreenLayoutLong.fromQualifiers(qualifiers));
            resConfig.setScreenLayoutDir(ScreenLayoutDir.fromQualifiers(qualifiers));
            if (this.isEmpty()) {
                this.onParseComplete();
                return;
            }
            resConfig.setUiModeType(UiModeType.fromQualifiers(qualifiers));
            resConfig.setUiModeNight(UiModeNight.fromQualifiers(qualifiers));
            resConfig.setScreenLayoutRound(ScreenLayoutRound.fromQualifiers(qualifiers));
            resConfig.setColorModeWide(ColorModeWide.fromQualifiers(qualifiers));
            resConfig.setColorModeHdr(ColorModeHdr.fromQualifiers(qualifiers));
            if (this.isEmpty()) {
                this.onParseComplete();
                return;
            }
            this.parseLocaleScriptVariant();
            this.parseLanguage();
            this.parseRegion();
            this.onParseComplete();
        }

        public void parseLocale() {
            if (this.mParseComplete) {
                return;
            }
            if (this.isEmpty()) {
                ResConfig resConfig = this.mConfig;
                resConfig.setLanguage((String)null);
                resConfig.setRegion((String)null);
                resConfig.setLocaleScript((String)null);
                this.mParseComplete = true;
                return;
            }
            this.parseLanguage();
            this.parseLocaleRegion();
            String[] qualifiers = this.mQualifiers;
            String script = null;
            if (qualifiers != null) {
                for (int i = 0; i < qualifiers.length; ++i) {
                    String qualifier = qualifiers[i];
                    if (qualifier == null || qualifier.length() < 2) continue;
                    script = qualifier;
                    qualifiers[i] = null;
                    break;
                }
            }
            this.mConfig.setLocaleScript(script);
            this.mParseComplete = true;
        }

        public String[] getErrors() {
            if (!this.mParseComplete) {
                return null;
            }
            String[] qualifiers = this.mQualifiers;
            if (qualifiers == null || qualifiers.length == 0) {
                return null;
            }
            int length = qualifiers.length;
            String[] tmp = new String[length];
            int count = 0;
            for (int i = 0; i < length; ++i) {
                String qualifier = qualifiers[i];
                if (qualifier == null || qualifier.length() == 0) continue;
                tmp[count] = qualifier;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            if (count == length) {
                return tmp;
            }
            String[] errors = new String[count];
            System.arraycopy(tmp, 0, errors, 0, count);
            return errors;
        }

        private void onParseComplete() {
            this.mConfig.trimToSize(this.mPreferredSize);
            this.mParseComplete = true;
        }

        private void parsePrefixedNumber() {
            if (this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parsePrefixedNumber(qualifiers[i])) continue;
                qualifiers[i] = null;
            }
        }

        private boolean parsePrefixedNumber(String qualifier) {
            if (qualifier == null) {
                return false;
            }
            Matcher matcher = PATTERN_PREFIX_NUMBER.matcher(qualifier);
            if (!matcher.find()) {
                return false;
            }
            String prefix = matcher.group(1);
            int value = Integer.parseInt(matcher.group(2));
            ResConfig resConfig = this.mConfig;
            if ("mcc".equals(prefix)) {
                resConfig.setMcc(value);
            } else if ("mnc".equals(prefix)) {
                resConfig.setMnc(value);
            } else if ("v".equals(prefix)) {
                resConfig.setSdkVersion(value);
            } else {
                return false;
            }
            return true;
        }

        private void parseDp() {
            if (this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parseDp(qualifiers[i])) continue;
                qualifiers[i] = null;
            }
        }

        private boolean parseDp(String qualifier) {
            if (qualifier == null) {
                return false;
            }
            Matcher matcher = PATTERN_DP.matcher(qualifier);
            if (!matcher.find()) {
                return false;
            }
            String prefix = matcher.group(1);
            int value = Integer.parseInt(matcher.group(2));
            ResConfig resConfig = this.mConfig;
            if ("sw".equals(prefix)) {
                resConfig.setSmallestScreenWidthDp(value);
            } else if ("w".equals(prefix)) {
                resConfig.setScreenWidthDp(value);
            } else if ("h".equals(prefix)) {
                resConfig.setScreenHeightDp(value);
            } else {
                return false;
            }
            return true;
        }

        private void parseWidthHeight() {
            if (this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parseWidthHeight(qualifiers[i])) continue;
                qualifiers[i] = null;
                return;
            }
        }

        private boolean parseWidthHeight(String qualifier) {
            if (qualifier == null) {
                return false;
            }
            Matcher matcher = PATTERN_WIDTH_HEIGHT.matcher(qualifier);
            if (!matcher.find()) {
                return false;
            }
            int width = Integer.parseInt(matcher.group(1));
            int height = Integer.parseInt(matcher.group(2));
            ResConfig resConfig = this.mConfig;
            resConfig.setScreenWidth(width);
            resConfig.setScreenHeight(height);
            return true;
        }

        private void parseLocaleNumberingSystem() {
            if (this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parseLocaleNumberingSystem(qualifiers[i])) continue;
                qualifiers[i] = null;
                return;
            }
        }

        private void parseUnknownBytes() {
            if (this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parseUnknownBytes(qualifiers[i])) continue;
                qualifiers[i] = null;
                return;
            }
        }

        private boolean parseLocaleNumberingSystem(String qualifier) {
            if (qualifier == null) {
                return false;
            }
            Matcher matcher = PATTERN_LOCALE_NUMBERING_SYSTEM.matcher(qualifier);
            return matcher.find();
        }

        private void parseLocaleScriptVariant() {
            if (this.mLanguageRegionParsed || this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parseLocaleScriptVariant(qualifiers[i])) continue;
                qualifiers[i] = null;
                this.mLanguageRegionParsed = true;
                return;
            }
        }

        private boolean parseLocaleScriptVariant(String qualifier) {
            if (qualifier == null || qualifier.length() < 4) {
                return false;
            }
            char[] chars = qualifier.toCharArray();
            if (chars[0] != 'b' || chars[1] != '+') {
                return false;
            }
            Matcher matcher = PATTERN_LOCALE_SCRIPT_VARIANT.matcher(qualifier);
            if (!matcher.find()) {
                return false;
            }
            String language = QualifierParser.trimPlus(matcher.group(1));
            String region = QualifierParser.trimPlus(matcher.group(2));
            String script = QualifierParser.trimPlus(matcher.group(3));
            String variant = QualifierParser.trimPlus(matcher.group(4));
            if (script == null && variant == null) {
                return false;
            }
            ResConfig resConfig = this.mConfig;
            resConfig.setLanguage(language);
            resConfig.setRegion(region);
            resConfig.setLocaleScript(script);
            resConfig.setLocaleVariant(variant);
            return true;
        }

        private void parseLanguage() {
            if (this.mLanguageRegionParsed || this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parseLanguage(qualifiers[i])) continue;
                qualifiers[i] = null;
                return;
            }
        }

        private boolean parseLanguage(String qualifier) {
            if (!QualifierParser.isLanguage(qualifier)) {
                return false;
            }
            this.mConfig.setLanguage(qualifier);
            return true;
        }

        private void parseLocaleRegion() {
            if (this.mLanguageRegionParsed || this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parseLocaleRegion(qualifiers[i])) continue;
                qualifiers[i] = null;
                return;
            }
        }

        private void parseRegion() {
            if (this.mLanguageRegionParsed || this.isEmpty()) {
                return;
            }
            String[] qualifiers = this.mQualifiers;
            for (int i = 0; i < qualifiers.length; ++i) {
                if (!this.parseRegion(qualifiers[i])) continue;
                qualifiers[i] = null;
                return;
            }
        }

        private boolean parseLocaleRegion(String qualifier) {
            if (!QualifierParser.isLocaleRegion(qualifier)) {
                return false;
            }
            this.mConfig.setRegion(qualifier);
            return true;
        }

        private boolean parseRegion(String qualifier) {
            if (!QualifierParser.isRegion(qualifier)) {
                return false;
            }
            this.mConfig.setRegion(qualifier);
            return true;
        }

        private boolean parseUnknownBytes(String qualifier) {
            if (qualifier == null) {
                return false;
            }
            if (!qualifier.startsWith("unknown_bytes")) {
                return false;
            }
            qualifier = qualifier.substring("unknown_bytes".length());
            this.mConfig.setUnknownBytes(qualifier);
            return true;
        }

        private boolean isEmpty() {
            if (!this.mEmpty) {
                this.mEmpty = QualifierParser.isEmpty(this.mQualifiers);
            }
            return this.mEmpty;
        }

        private static boolean isEmpty(String[] qualifiers) {
            if (qualifiers == null) {
                return true;
            }
            for (int i = 0; i < qualifiers.length; ++i) {
                String qualifier = qualifiers[i];
                if (qualifier == null) continue;
                if (qualifier.length() == 0) {
                    qualifiers[i] = null;
                    continue;
                }
                return false;
            }
            return true;
        }

        private static String trimPlus(String text) {
            if (text == null || text.length() == 0) {
                return null;
            }
            if (text.charAt(0) == '+') {
                text = text.substring(1);
            }
            return text;
        }

        private static boolean isLanguage(String qualifier) {
            if (qualifier == null) {
                return false;
            }
            char[] chars = qualifier.toCharArray();
            int length = chars.length;
            if (length != 2 && length != 3) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (QualifierParser.isAtoZLower(chars[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean isLocaleRegion(String qualifier) {
            if (qualifier == null) {
                return false;
            }
            int length = qualifier.length();
            if (length != 2 && length != 3) {
                return false;
            }
            char[] chars = qualifier.toCharArray();
            if (length == 2) {
                for (char ch : chars) {
                    if (QualifierParser.isAtoZUpper(ch)) continue;
                    return false;
                }
                return true;
            }
            for (char ch : chars) {
                if (QualifierParser.isDigit(ch)) continue;
                return false;
            }
            return true;
        }

        private static boolean isRegion(String qualifier) {
            if (qualifier == null || qualifier.length() != 3) {
                return false;
            }
            char[] chars = qualifier.toCharArray();
            boolean checkDigit = false;
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (i == 0) {
                    if (ch == 'r' || (checkDigit = QualifierParser.isDigit(ch))) continue;
                    return false;
                }
                if (!(checkDigit ? !QualifierParser.isDigit(ch) : !QualifierParser.isAtoZUpper(ch))) continue;
                return false;
            }
            return true;
        }

        private static String[] splitQualifiers(String qualifier) {
            if (qualifier == null || qualifier.length() == 0) {
                return null;
            }
            return qualifier.split("-");
        }

        private static boolean isDigit(char ch) {
            return ch <= '9' && ch >= '0';
        }

        private static boolean isAtoZLower(char ch) {
            return ch <= 'z' && ch >= 'a';
        }

        private static boolean isAtoZUpper(char ch) {
            return ch <= 'Z' && ch >= 'A';
        }
    }

    static class QualifierBuilder {
        private final ResConfig mConfig;
        private StringBuilder mBuilder;
        private String mNumberingSystem;

        public QualifierBuilder(ResConfig resConfig) {
            this.mConfig = resConfig;
        }

        public String build() {
            ResConfig resConfig = this.mConfig;
            if (resConfig.isDefault()) {
                return "";
            }
            this.mBuilder = new StringBuilder();
            this.appendPrefixedNumber("mcc", resConfig.getMcc());
            this.appendPrefixedNumber("mnc", resConfig.getMnc());
            this.appendLanguageAndRegion();
            this.appendFlag(resConfig.getGender());
            this.appendFlag(resConfig.getScreenLayoutDir());
            this.appendDp("sw", resConfig.getSmallestScreenWidthDp());
            this.appendDp("w", resConfig.getScreenWidthDp());
            this.appendDp("h", resConfig.getScreenHeightDp());
            this.appendFlag(resConfig.getScreenLayoutSize());
            this.appendFlag(resConfig.getScreenLayoutLong());
            this.appendFlag(resConfig.getScreenLayoutRound());
            this.appendFlag(resConfig.getColorModeWide());
            this.appendFlag(resConfig.getColorModeHdr());
            this.appendFlag(resConfig.getOrientation());
            this.appendFlag(resConfig.getUiModeType());
            this.appendFlag(resConfig.getUiModeNight());
            this.appendFlag(resConfig.getDensity());
            this.appendFlag(resConfig.getTouchscreen());
            this.appendFlag(resConfig.getInputFlagsKeysHidden());
            this.appendFlag(resConfig.getKeyboard());
            this.appendFlag(resConfig.getInputFlagsNavHidden());
            this.appendFlag(resConfig.getNavigation());
            this.appendScreenWidthHeight();
            this.appendPrefixedNumber("v", resConfig.getSdkVersion());
            this.appendUnknownBytes();
            return this.mBuilder.toString();
        }

        private void appendScreenWidthHeight() {
            ResConfig resConfig = this.mConfig;
            int width = resConfig.getScreenWidth();
            int height = resConfig.getScreenHeight();
            if (width == 0 && height == 0) {
                return;
            }
            this.mBuilder.append('-').append(width).append('x').append(height);
        }

        private void appendLanguageAndRegion() {
            char separator;
            ResConfig resConfig = this.mConfig;
            String language = resConfig.getLanguage();
            String region = resConfig.getRegion();
            String script = resConfig.getLocaleScript();
            String variant = resConfig.getLocaleVariant();
            if (language == null && region == null) {
                return;
            }
            StringBuilder builder = this.mBuilder;
            if (script != null || variant != null) {
                builder.append('-');
                builder.append('b');
                separator = '+';
            } else {
                separator = '-';
            }
            if (language != null) {
                builder.append(separator);
                builder.append(language);
            }
            if (region != null) {
                builder.append(separator);
                if (region.length() == 2) {
                    builder.append('r');
                }
                builder.append(region);
            }
            if (script != null) {
                builder.append(separator);
                builder.append(script);
            }
            if (variant != null) {
                builder.append(separator);
                builder.append(variant);
            }
        }

        private void appendLocaleNumberingSystem() {
            String numberingSystem = this.mNumberingSystem;
            if (numberingSystem == null) {
                return;
            }
            StringBuilder builder = this.mBuilder;
            builder.append("-u+nu+");
            builder.append(numberingSystem);
        }

        private void appendUnknownBytes() {
            String unknownHexBytes = this.mConfig.getUnknownHexBytes();
            if (unknownHexBytes == null) {
                return;
            }
            StringBuilder builder = this.mBuilder;
            builder.append('-');
            builder.append("unknown_bytes");
            builder.append(unknownHexBytes);
        }

        private void appendFlag(Flag flag) {
            if (flag == null) {
                return;
            }
            this.mBuilder.append('-').append(flag.toString());
        }

        private void appendDp(String prefix, int number) {
            if (number == 0) {
                return;
            }
            StringBuilder builder = this.mBuilder;
            builder.append('-');
            if (prefix != null) {
                builder.append(prefix);
            }
            builder.append(number);
            builder.append("dp");
        }

        private void appendPrefixedNumber(String prefix, int number) {
            if (number == 0) {
                return;
            }
            StringBuilder builder = this.mBuilder;
            builder.append('-');
            builder.append(prefix);
            builder.append(number);
        }
    }

    public static class Flag {
        private final String name;
        private final int flag;

        Flag(String name, int flag) {
            this.name = name;
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.name;
        }

        public static String toString(Flag flag) {
            if (flag != null) {
                return flag.toString();
            }
            return null;
        }

        static <T extends Flag> T fromQualifiers(T[] values, String qualifiers) {
            if (qualifiers == null) {
                return null;
            }
            return (T)Flag.fromQualifiers(values, (String[])qualifiers.split("\\s*-\\s*"));
        }

        static <T extends Flag> T fromQualifiers(T[] values, String[] qualifiers) {
            if (qualifiers == null) {
                return null;
            }
            for (int i = 0; i < qualifiers.length; ++i) {
                Flag flag = Flag.valueOf(values, (String)qualifiers[i]);
                if (flag == null) continue;
                qualifiers[i] = null;
                return (T)flag;
            }
            return null;
        }

        static <T extends Flag> T valueOf(T[] values, int mask, int flagValue) {
            flagValue &= mask;
            for (T flag : values) {
                if (flagValue != ((Flag)flag).getFlag()) continue;
                return flag;
            }
            return null;
        }

        static <T extends Flag> T valueOf(T[] values, String name) {
            if (name == null || name.length() == 0) {
                return null;
            }
            if (name.charAt(0) == '-') {
                name = name.substring(1);
            }
            name = name.toLowerCase();
            for (T flag : values) {
                if (!name.equals(((Flag)flag).toString())) continue;
                return flag;
            }
            return null;
        }

        public static int update(int mask, Flag flag, int value) {
            int flip = ~mask & 0xFF;
            value &= flip;
            if (flag != null) {
                value |= flag.getFlag();
            }
            return value;
        }
    }

    public static final class ColorModeHdr
    extends Flag {
        public static final int MASK = 12;
        public static final ColorModeHdr LOWDR = new ColorModeHdr("lowdr", 4);
        public static final ColorModeHdr HIGHDR = new ColorModeHdr("highdr", 8);
        public static final ColorModeHdr[] VALUES = new ColorModeHdr[]{LOWDR, HIGHDR};

        private ColorModeHdr(String name, int flag) {
            super(name, flag);
        }

        public static ColorModeHdr valueOf(int flag) {
            return (ColorModeHdr)Flag.valueOf((Flag[])VALUES, (int)12, (int)flag);
        }

        public static ColorModeHdr valueOf(String name) {
            return (ColorModeHdr)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static ColorModeHdr fromQualifiers(String qualifiers) {
            return (ColorModeHdr)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static ColorModeHdr fromQualifiers(String[] qualifiers) {
            return (ColorModeHdr)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(ColorModeHdr flag, int value) {
            return Flag.update(12, flag, value);
        }
    }

    public static final class ColorModeWide
    extends Flag {
        public static final int MASK = 3;
        public static final ColorModeWide NOWIDECG = new ColorModeWide("nowidecg", 1);
        public static final ColorModeWide WIDECG = new ColorModeWide("widecg", 2);
        public static final ColorModeWide[] VALUES = new ColorModeWide[]{NOWIDECG, WIDECG};

        private ColorModeWide(String name, int flag) {
            super(name, flag);
        }

        public static ColorModeWide valueOf(int flag) {
            return (ColorModeWide)Flag.valueOf((Flag[])VALUES, (int)3, (int)flag);
        }

        public static ColorModeWide valueOf(String name) {
            return (ColorModeWide)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static ColorModeWide fromQualifiers(String qualifiers) {
            return (ColorModeWide)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static ColorModeWide fromQualifiers(String[] qualifiers) {
            return (ColorModeWide)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(ColorModeWide flag, int value) {
            return Flag.update(3, flag, value);
        }
    }

    public static final class ScreenLayoutRound
    extends Flag {
        public static final int MASK = 3;
        public static final ScreenLayoutRound NOTROUND = new ScreenLayoutRound("notround", 1);
        public static final ScreenLayoutRound ROUND = new ScreenLayoutRound("round", 2);
        public static final ScreenLayoutRound[] VALUES = new ScreenLayoutRound[]{NOTROUND, ROUND};

        private ScreenLayoutRound(String name, int flag) {
            super(name, flag);
        }

        public static ScreenLayoutRound valueOf(int flag) {
            return (ScreenLayoutRound)Flag.valueOf((Flag[])VALUES, (int)3, (int)flag);
        }

        public static ScreenLayoutRound valueOf(String name) {
            return (ScreenLayoutRound)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static ScreenLayoutRound fromQualifiers(String qualifiers) {
            return (ScreenLayoutRound)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static ScreenLayoutRound fromQualifiers(String[] qualifiers) {
            return (ScreenLayoutRound)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(ScreenLayoutRound flag, int value) {
            return Flag.update(3, flag, value);
        }
    }

    public static final class ScreenLayoutDir
    extends Flag {
        public static final int MASK = 192;
        public static final ScreenLayoutDir LDLTR = new ScreenLayoutDir("ldltr", 64);
        public static final ScreenLayoutDir LDRTL = new ScreenLayoutDir("ldrtl", 128);
        public static final ScreenLayoutDir[] VALUES = new ScreenLayoutDir[]{LDLTR, LDRTL};

        private ScreenLayoutDir(String name, int flag) {
            super(name, flag);
        }

        public static ScreenLayoutDir valueOf(int flag) {
            return (ScreenLayoutDir)Flag.valueOf((Flag[])VALUES, (int)192, (int)flag);
        }

        public static ScreenLayoutDir valueOf(String name) {
            return (ScreenLayoutDir)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static ScreenLayoutDir fromQualifiers(String qualifiers) {
            return (ScreenLayoutDir)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static ScreenLayoutDir fromQualifiers(String[] qualifiers) {
            return (ScreenLayoutDir)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(ScreenLayoutDir flag, int value) {
            return Flag.update(192, flag, value);
        }
    }

    public static final class ScreenLayoutLong
    extends Flag {
        public static final int MASK = 48;
        public static final ScreenLayoutLong NOTLONG = new ScreenLayoutLong("notlong", 16);
        public static final ScreenLayoutLong LONG = new ScreenLayoutLong("long", 32);
        public static final ScreenLayoutLong[] VALUES = new ScreenLayoutLong[]{NOTLONG, LONG};

        private ScreenLayoutLong(String name, int flag) {
            super(name, flag);
        }

        public static ScreenLayoutLong valueOf(int flag) {
            return (ScreenLayoutLong)Flag.valueOf((Flag[])VALUES, (int)48, (int)flag);
        }

        public static ScreenLayoutLong valueOf(String name) {
            return (ScreenLayoutLong)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static ScreenLayoutLong fromQualifiers(String qualifiers) {
            return (ScreenLayoutLong)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static ScreenLayoutLong fromQualifiers(String[] qualifiers) {
            return (ScreenLayoutLong)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(ScreenLayoutLong flag, int value) {
            return Flag.update(48, flag, value);
        }
    }

    public static final class ScreenLayoutSize
    extends Flag {
        public static final int MASK = 15;
        public static final ScreenLayoutSize SMALL = new ScreenLayoutSize("small", 1);
        public static final ScreenLayoutSize NORMAL = new ScreenLayoutSize("normal", 2);
        public static final ScreenLayoutSize LARGE = new ScreenLayoutSize("large", 3);
        public static final ScreenLayoutSize XLARGE = new ScreenLayoutSize("xlarge", 4);
        public static final ScreenLayoutSize[] VALUES = new ScreenLayoutSize[]{SMALL, NORMAL, LARGE, XLARGE};

        private ScreenLayoutSize(String name, int flag) {
            super(name, flag);
        }

        public static ScreenLayoutSize valueOf(int flag) {
            return (ScreenLayoutSize)Flag.valueOf((Flag[])VALUES, (int)15, (int)flag);
        }

        public static ScreenLayoutSize valueOf(String name) {
            return (ScreenLayoutSize)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static ScreenLayoutSize fromQualifiers(String qualifiers) {
            return (ScreenLayoutSize)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static ScreenLayoutSize fromQualifiers(String[] qualifiers) {
            return (ScreenLayoutSize)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(ScreenLayoutSize flag, int value) {
            return Flag.update(15, flag, value);
        }
    }

    public static final class UiModeNight
    extends Flag {
        public static final int MASK = 48;
        public static final UiModeNight NOTNIGHT = new UiModeNight("notnight", 16);
        public static final UiModeNight NIGHT = new UiModeNight("night", 32);
        private static final UiModeNight[] VALUES = new UiModeNight[]{NOTNIGHT, NIGHT};

        private UiModeNight(String name, int flag) {
            super(name, flag);
        }

        public static UiModeNight valueOf(int flag) {
            return (UiModeNight)Flag.valueOf((Flag[])VALUES, (int)48, (int)flag);
        }

        public static UiModeNight valueOf(String name) {
            return (UiModeNight)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static UiModeNight fromQualifiers(String qualifiers) {
            return (UiModeNight)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static UiModeNight fromQualifiers(String[] qualifiers) {
            return (UiModeNight)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(UiModeNight flag, int value) {
            return Flag.update(48, flag, value);
        }
    }

    public static final class UiModeType
    extends Flag {
        public static final int MASK = 15;
        public static final UiModeType NORMAL = new UiModeType("normal", 1);
        public static final UiModeType DESK = new UiModeType("desk", 2);
        public static final UiModeType CAR = new UiModeType("car", 3);
        public static final UiModeType TELEVISION = new UiModeType("television", 4);
        public static final UiModeType APPLIANCE = new UiModeType("appliance", 5);
        public static final UiModeType WATCH = new UiModeType("watch", 6);
        public static final UiModeType VRHEADSET = new UiModeType("vrheadset", 7);
        public static final UiModeType GODZILLAUI = new UiModeType("godzillaui", 11);
        public static final UiModeType SMALLUI = new UiModeType("smallui", 12);
        public static final UiModeType MEDIUMUI = new UiModeType("mediumui", 13);
        public static final UiModeType LARGEUI = new UiModeType("largeui", 14);
        public static final UiModeType HUGEUI = new UiModeType("hugeui", 15);
        private static final UiModeType[] VALUES = new UiModeType[]{NORMAL, DESK, CAR, TELEVISION, APPLIANCE, WATCH, VRHEADSET, GODZILLAUI, SMALLUI, MEDIUMUI, LARGEUI, HUGEUI};

        private UiModeType(String name, int flag) {
            super(name, flag);
        }

        public static UiModeType valueOf(int flag) {
            return (UiModeType)Flag.valueOf((Flag[])VALUES, (int)15, (int)flag);
        }

        public static UiModeType valueOf(String name) {
            return (UiModeType)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static UiModeType fromQualifiers(String qualifiers) {
            return (UiModeType)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static UiModeType fromQualifiers(String[] qualifiers) {
            return (UiModeType)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(UiModeType flag, int value) {
            return Flag.update(15, flag, value);
        }
    }

    public static final class Gender
    extends Flag {
        public static final int MASK = 3;
        public static final Gender NEUTER = new Gender("neuter", 1);
        public static final Gender FEMININE = new Gender("feminine", 2);
        public static final Gender MASCULINE = new Gender("masculine", 3);
        public static final Gender[] VALUES = new Gender[]{NEUTER, FEMININE, MASCULINE};

        private Gender(String name, int flag) {
            super(name, flag);
        }

        public static Gender valueOf(int flag) {
            return (Gender)Flag.valueOf((Flag[])VALUES, (int)3, (int)flag);
        }

        public static Gender valueOf(String name) {
            return (Gender)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static Gender fromQualifiers(String qualifiers) {
            return (Gender)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static Gender fromQualifiers(String[] qualifiers) {
            return (Gender)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(Gender flag, int value) {
            return Flag.update(3, flag, value);
        }
    }

    public static final class InputFlagsNavHidden
    extends Flag {
        public static final int MASK = 12;
        public static final InputFlagsNavHidden NAVEXPOSED = new InputFlagsNavHidden("navexposed", 4);
        public static final InputFlagsNavHidden NAVHIDDEN = new InputFlagsNavHidden("navhidden", 8);
        public static final InputFlagsNavHidden[] VALUES = new InputFlagsNavHidden[]{NAVEXPOSED, NAVHIDDEN};

        private InputFlagsNavHidden(String name, int flag) {
            super(name, flag);
        }

        public static InputFlagsNavHidden valueOf(int flag) {
            return (InputFlagsNavHidden)Flag.valueOf((Flag[])VALUES, (int)12, (int)flag);
        }

        public static InputFlagsNavHidden valueOf(String name) {
            return (InputFlagsNavHidden)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static InputFlagsNavHidden fromQualifiers(String qualifiers) {
            return (InputFlagsNavHidden)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static InputFlagsNavHidden fromQualifiers(String[] qualifiers) {
            return (InputFlagsNavHidden)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(InputFlagsNavHidden flag, int value) {
            return Flag.update(12, flag, value);
        }
    }

    public static final class InputFlagsKeysHidden
    extends Flag {
        public static final int MASK = 3;
        public static final InputFlagsKeysHidden KEYSEXPOSED = new InputFlagsKeysHidden("keysexposed", 1);
        public static final InputFlagsKeysHidden KEYSHIDDEN = new InputFlagsKeysHidden("keyshidden", 2);
        public static final InputFlagsKeysHidden KEYSSOFT = new InputFlagsKeysHidden("keyssoft", 3);
        public static final InputFlagsKeysHidden[] VALUES = new InputFlagsKeysHidden[]{KEYSEXPOSED, KEYSHIDDEN, KEYSSOFT};

        private InputFlagsKeysHidden(String name, int flag) {
            super(name, flag);
        }

        public static InputFlagsKeysHidden valueOf(int flag) {
            return (InputFlagsKeysHidden)Flag.valueOf((Flag[])VALUES, (int)3, (int)flag);
        }

        public static InputFlagsKeysHidden valueOf(String name) {
            return (InputFlagsKeysHidden)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static InputFlagsKeysHidden fromQualifiers(String qualifiers) {
            return (InputFlagsKeysHidden)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static InputFlagsKeysHidden fromQualifiers(String[] qualifiers) {
            return (InputFlagsKeysHidden)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(InputFlagsKeysHidden flag, int value) {
            return Flag.update(3, flag, value);
        }
    }

    public static final class Navigation
    extends Flag {
        public static final int MASK = 15;
        public static final Navigation NONAV = new Navigation("nonav", 1);
        public static final Navigation DPAD = new Navigation("dpad", 2);
        public static final Navigation TRACKBALL = new Navigation("trackball", 3);
        public static final Navigation WHEEL = new Navigation("wheel", 4);
        public static final Navigation[] VALUES = new Navigation[]{NONAV, DPAD, TRACKBALL, WHEEL};

        private Navigation(String name, int flag) {
            super(name, flag);
        }

        public static Navigation valueOf(int flag) {
            return (Navigation)Flag.valueOf((Flag[])VALUES, (int)15, (int)flag);
        }

        public static Navigation valueOf(String name) {
            return (Navigation)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static Navigation fromQualifiers(String qualifiers) {
            return (Navigation)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static Navigation fromQualifiers(String[] qualifiers) {
            return (Navigation)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(Navigation flag, int value) {
            return Flag.update(15, flag, value);
        }
    }

    public static final class Keyboard
    extends Flag {
        public static final int MASK = 15;
        public static final Keyboard NOKEYS = new Keyboard("nokeys", 1);
        public static final Keyboard QWERTY = new Keyboard("qwerty", 2);
        public static final Keyboard KEY12 = new Keyboard("12key", 3);
        public static final Keyboard[] VALUES = new Keyboard[]{NOKEYS, QWERTY, KEY12};

        private Keyboard(String name, int flag) {
            super(name, flag);
        }

        public static Keyboard valueOf(int flag) {
            return (Keyboard)Flag.valueOf((Flag[])VALUES, (int)15, (int)flag);
        }

        public static Keyboard valueOf(String name) {
            return (Keyboard)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static Keyboard fromQualifiers(String qualifiers) {
            return (Keyboard)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static Keyboard fromQualifiers(String[] qualifiers) {
            return (Keyboard)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(Keyboard flag, int value) {
            return Flag.update(15, flag, value);
        }
    }

    public static final class Density
    extends Flag {
        public static final int MASK = 65535;
        public static final Density LDPI = new Density("ldpi", 120);
        public static final Density MDPI = new Density("mdpi", 160);
        public static final Density TVDPI = new Density("tvdpi", 213);
        public static final Density HDPI = new Density("hdpi", 240);
        public static final Density XHDPI = new Density("xhdpi", 320);
        public static final Density XXHDPI = new Density("xxhdpi", 480);
        public static final Density XXXHDPI = new Density("xxxhdpi", 640);
        public static final Density ANYDPI = new Density("anydpi", 65534);
        public static final Density NODPI = new Density("nodpi", 65535);
        public static final Density[] VALUES = new Density[]{LDPI, MDPI, TVDPI, HDPI, XHDPI, XXHDPI, XXXHDPI, ANYDPI, NODPI};

        private Density(String name, int flag) {
            super(name, flag);
        }

        public static Density valueOf(int flag) {
            if (flag == 0) {
                return null;
            }
            Density density = (Density)Flag.valueOf((Flag[])VALUES, (int)65535, (int)flag);
            if (density == null) {
                density = new Density((flag &= 0xFFFF) + "dpi", flag);
            }
            return density;
        }

        public static Density valueOf(String name) {
            Density density;
            if (name == null || name.length() < 4) {
                return null;
            }
            if ((name = name.toLowerCase()).charAt(0) == '-') {
                name = name.substring(1);
            }
            if ((density = (Density)Flag.valueOf((Flag[])VALUES, (String)name)) == null && name.endsWith("dpi")) {
                name = name.substring(0, name.length() - 3);
                try {
                    int flag = Integer.parseInt(name);
                    density = new Density(flag + "dpi", flag);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return density;
        }

        public static Density fromQualifiers(String qualifiers) {
            return Density.fromQualifiers(qualifiers.split("\\s*-\\s*"));
        }

        public static Density fromQualifiers(String[] qualifiers) {
            if (qualifiers == null) {
                return null;
            }
            for (int i = 0; i < qualifiers.length; ++i) {
                Density density = Density.valueOf(qualifiers[i]);
                if (density == null) continue;
                qualifiers[i] = null;
                return density;
            }
            return null;
        }

        public static int update(Density flag, int value) {
            return Flag.update(65535, flag, value);
        }
    }

    public static final class Touchscreen
    extends Flag {
        public static final int MASK = 15;
        public static final Touchscreen NOTOUCH = new Touchscreen("notouch", 1);
        public static final Touchscreen STYLUS = new Touchscreen("stylus", 2);
        public static final Touchscreen FINGER = new Touchscreen("finger", 3);
        public static final Touchscreen[] VALUES = new Touchscreen[]{NOTOUCH, STYLUS, FINGER};

        private Touchscreen(String name, int flag) {
            super(name, flag);
        }

        public static Touchscreen valueOf(int flag) {
            return (Touchscreen)Flag.valueOf((Flag[])VALUES, (int)15, (int)flag);
        }

        public static Touchscreen valueOf(String name) {
            return (Touchscreen)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static Touchscreen fromQualifiers(String qualifiers) {
            return (Touchscreen)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static Touchscreen fromQualifiers(String[] qualifiers) {
            return (Touchscreen)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(Touchscreen flag, int value) {
            return Flag.update(15, flag, value);
        }
    }

    public static final class Orientation
    extends Flag {
        public static final int MASK = 15;
        public static final Orientation PORT = new Orientation("port", 1);
        public static final Orientation LAND = new Orientation("land", 2);
        public static final Orientation SQUARE = new Orientation("square", 3);
        public static final Orientation[] VALUES = new Orientation[]{PORT, LAND, SQUARE};

        private Orientation(String name, int flag) {
            super(name, flag);
        }

        public static Orientation valueOf(int flag) {
            return (Orientation)Flag.valueOf((Flag[])VALUES, (int)15, (int)flag);
        }

        public static Orientation valueOf(String name) {
            return (Orientation)Flag.valueOf((Flag[])VALUES, (String)name);
        }

        public static Orientation fromQualifiers(String qualifiers) {
            return (Orientation)Flag.fromQualifiers((Flag[])VALUES, (String)qualifiers);
        }

        public static Orientation fromQualifiers(String[] qualifiers) {
            return (Orientation)Flag.fromQualifiers((Flag[])VALUES, (String[])qualifiers);
        }

        public static int update(Orientation flag, int value) {
            return Flag.update(15, flag, value);
        }
    }
}

