/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.array.CompoundItemArray;
import com.reandroid.arsc.base.BlockArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.EntryHeaderMap;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Iterator;

public abstract class CompoundEntry<ITEM extends ResValueMap, ARRAY extends CompoundItemArray<ITEM>>
extends TableEntry<EntryHeaderMap, ARRAY>
implements Iterable<ITEM> {
    public static final String NAME_values = "values";

    public CompoundEntry(ARRAY mapArray) {
        super(new EntryHeaderMap(), mapArray);
    }

    @Override
    public Iterator<ValueItem> allValues() {
        return new ComputeIterator<ResValueMap, ValueItem>(this.iterator(), item -> item);
    }

    @Override
    public Iterator<ITEM> iterator() {
        return ((CompoundItemArray)this.getValue()).iterator();
    }

    public AttributeDataFormat[] getAttributeTypeFormats() {
        ITEM item = this.getByType(AttributeType.FORMATS);
        if (item != null) {
            return ((ResValueMap)item).getAttributeTypeFormats();
        }
        return null;
    }

    public boolean containsType(AttributeType attributeType) {
        return ((CompoundItemArray)this.getValue()).containsType(attributeType);
    }

    public ITEM getByType(AttributeType attributeType) {
        return (ITEM)((CompoundItemArray)this.getValue()).getByType(attributeType);
    }

    @Override
    public void refresh() {
        ((EntryHeaderMap)this.getHeader()).setValuesCount(((CompoundItemArray)this.getValue()).size());
    }

    public ITEM[] listResValueMap() {
        return (ResValueMap[])((CompoundItemArray)this.getValue()).getChildes();
    }

    public String decodeParentId() {
        int parentId = this.getParentId();
        if (parentId == 0) {
            return null;
        }
        return ValueCoder.decodeReference(this.getPackageBlock(), ValueType.REFERENCE, parentId);
    }

    public int getParentId() {
        return ((EntryHeaderMap)this.getHeader()).getParentId();
    }

    public void setParentId(int parentId) {
        ((EntryHeaderMap)this.getHeader()).setParentId(parentId);
    }

    public int childesCount() {
        return ((CompoundItemArray)this.getValue()).size();
    }

    public void setValuesCount(int valuesCount) {
        ((EntryHeaderMap)this.getHeader()).setValuesCount(valuesCount);
        ((CompoundItemArray)this.getValue()).setSize(valuesCount);
    }

    public ResourceEntry resolveParentId() {
        int id = this.getParentId();
        if (id == 0) {
            return null;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        TableBlock tableBlock = packageBlock.getTableBlock();
        if (tableBlock == null) {
            return null;
        }
        return tableBlock.getResource(packageBlock, id);
    }

    public PackageBlock getPackageBlock() {
        Entry entry = this.getParentEntry();
        if (entry != null) {
            return entry.getPackageBlock();
        }
        return null;
    }

    @Override
    void linkTableStringsInternal(TableStringPool tableStringPool) {
        for (ResValueMap item : this.listResValueMap()) {
            item.linkTableStrings(tableStringPool);
        }
    }

    @Override
    void onHeaderLoaded(ARRAY value, EntryHeaderMap header) {
        ((BlockArray)value).setSize(header.getValuesCount());
    }

    @Override
    void onRemoved() {
        ((EntryHeaderMap)this.getHeader()).onRemoved();
        ((CompoundItemArray)this.getValue()).onRemoved();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        ((EntryHeaderMap)this.getHeader()).toJson(jsonObject);
        jsonObject.put(NAME_values, ((CompoundItemArray)this.getValue()).toJson());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        ((EntryHeaderMap)this.getHeader()).fromJson(json);
        ((CompoundItemArray)this.getValue()).fromJson(json.optJSONArray(NAME_values));
        this.refresh();
    }

    @Override
    public String toString() {
        int len;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHeader());
        ResValueMap[] valueMaps = this.listResValueMap();
        int max = len = valueMaps.length;
        if (max > 4) {
            max = 4;
        }
        for (int i = 0; i < max; ++i) {
            builder.append("\n    ");
            builder.append(valueMaps[i]);
        }
        if (len > 0) {
            if (max != len) {
                builder.append("\n    ...");
            }
            builder.append("\n   ");
        }
        return builder.toString();
    }
}

