/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.refactor;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ResFile;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.arsc.array.EntryArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TypeStringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.FilterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResourceBuilder {
    private ResourceMergeOption mMergeOption;
    private final TableBlock sourceTable;
    private ApkModule resultModule;
    private final Map<Integer, Integer> resourceIdMap;
    private boolean mRebuilt;

    public ResourceBuilder(ResourceMergeOption mergeOption, TableBlock sourceTable) {
        this.mMergeOption = mergeOption;
        this.sourceTable = sourceTable;
        this.resourceIdMap = new HashMap<Integer, Integer>();
    }

    public ResourceBuilder(TableBlock sourceTable) {
        this(new ResourceMergeOption(), sourceTable);
    }

    public void rebuildTo(ApkModule apkModule) {
        this.rebuild();
        this.rebuildManifest(apkModule);
        this.transferResFiles(apkModule);
        this.transferTableBlock(apkModule);
    }

    public void rebuild() {
        if (this.mRebuilt) {
            return;
        }
        this.mRebuilt = true;
        this.resultModule = new ApkModule();
        TableBlock resultTable = new TableBlock();
        this.resultModule.setTableBlock(resultTable);
        this.initializeTable();
        this.mergePackages();
    }

    public int applyIdChanges(Iterator<IntegerReference> iterator) {
        int count = 0;
        Map<Integer, Integer> idMap = this.getResourceIdMap();
        while (iterator.hasNext()) {
            IntegerReference reference = iterator.next();
            Integer value = idMap.get(reference.get());
            if (value == null) continue;
            reference.set(value);
            ++count;
        }
        return count;
    }

    public Map<Integer, Integer> getResourceIdMap() {
        return this.resourceIdMap;
    }

    private void addIdMap(int search, int replace) {
        if (search == replace || search == 0 || replace == 0 || search == -1 || replace == -1) {
            return;
        }
        this.resourceIdMap.put(search, replace);
    }

    public TableBlock getResultTable() {
        return this.getResultModule().getTableBlock();
    }

    public ApkModule getResultModule() {
        return this.resultModule;
    }

    public TableBlock getSourceTable() {
        return this.sourceTable;
    }

    public ResourceMergeOption getMergeOption() {
        ResourceMergeOption mergeOption = this.mMergeOption;
        if (mergeOption == null) {
            this.mMergeOption = mergeOption = new ResourceMergeOption();
        }
        return mergeOption;
    }

    public void setMergeOption(ResourceMergeOption mergeOption) {
        this.mMergeOption = mergeOption;
    }

    private void transferTableBlock(ApkModule apkModule) {
        ApkModule resultModule = this.getResultModule();
        TableBlock tableBlock = resultModule.getTableBlock();
        if (tableBlock == null) {
            return;
        }
        apkModule.setTableBlock(tableBlock);
        resultModule.setTableBlock(null);
    }

    private void transferResFiles(ApkModule apkModule) {
        ApkModule resultModule = this.getResultModule();
        List<ResFile> resFileList = resultModule.listResFiles();
        HashSet<String> transferred = new HashSet<String>();
        for (ResFile resFile : resFileList) {
            InputSource inputSource = resFile.getInputSource();
            String path = inputSource.getAlias();
            if (transferred.contains(path)) continue;
            apkModule.add(inputSource);
            transferred.add(path);
        }
        ZipEntryMap zipEntryMap = resultModule.getZipEntryMap();
        for (String path : transferred) {
            zipEntryMap.remove(path);
        }
    }

    private void rebuildManifest(ApkModule apkModule) {
        AndroidManifestBlock moduleManifest = apkModule.getAndroidManifest();
        if (moduleManifest == null) {
            return;
        }
        TableBlock resultTable = this.getResultTable();
        if (resultTable == null) {
            return;
        }
        PackageBlock documentPackage = moduleManifest.getPackageBlock();
        if (documentPackage.getTableBlock() == resultTable) {
            return;
        }
        AndroidManifestBlock resultManifest = new AndroidManifestBlock();
        resultManifest.setPackageBlock(resultTable.pickOne(documentPackage.getId()));
        resultManifest.mergeWithName(this.getMergeOption(), moduleManifest);
        apkModule.setManifest(resultManifest);
    }

    private void mergePackages() {
        TableBlock sourceTable = this.sourceTable;
        TableBlock resultTable = this.getResultTable();
        int size = sourceTable.size();
        for (int i = 0; i < size; ++i) {
            PackageBlock sourcePackage = sourceTable.get(i);
            PackageBlock resultPackage = resultTable.get(i);
            this.mergePackage(sourcePackage, resultPackage);
        }
    }

    private void mergePackage(PackageBlock sourcePackage, PackageBlock resultPackage) {
        ResourceMergeOption mergeOption = this.getMergeOption();
        Iterator<ResourceEntry> iterator = sourcePackage.iterator();
        while (iterator.hasNext()) {
            ResourceEntry sourceEntry = iterator.next();
            if (sourceEntry.isEmpty()) continue;
            ResourceEntry resultEntry = resultPackage.mergeWithName(mergeOption, sourceEntry);
            this.addIdMap(sourceEntry.getResourceId(), resultEntry.getResourceId());
        }
    }

    private void initializeTable() {
        TableBlock sourceTable = this.getSourceTable();
        sourceTable.refresh();
        TableBlock resultTable = this.getResultTable();
        resultTable.addFrameworks(resultTable.frameworks());
        for (PackageBlock sourcePackage : sourceTable) {
            resultTable.newPackage(sourcePackage.getId(), sourcePackage.getName());
        }
        resultTable.getStringPool().merge(sourceTable.getStringPool());
        this.initializePackages();
    }

    private void initializePackages() {
        TableBlock sourceTable = this.getSourceTable();
        TableBlock resultTable = this.getResultTable();
        int size = sourceTable.size();
        for (int i = 0; i < size; ++i) {
            PackageBlock sourcePackage = sourceTable.get(i);
            PackageBlock resultPackage = resultTable.get(i);
            this.initializePackage(sourcePackage, resultPackage);
        }
    }

    private void initializePackage(PackageBlock sourcePackage, PackageBlock resultPackage) {
        this.initializeTypeString(sourcePackage, resultPackage);
        this.initializeSpecString(sourcePackage, resultPackage);
        this.initializeEntries(sourcePackage, resultPackage);
    }

    private void initializeTypeString(PackageBlock sourcePackage, PackageBlock resultPackage) {
        TypeStringPool sourcePool = sourcePackage.getTypeStringPool();
        HashSet<String> typeList = new HashSet<String>(sourcePool.size());
        for (TypeString typeString : sourcePool) {
            String typeName = typeString.get();
            Iterator<ResourceEntry> iterator = FilterIterator.of(sourcePackage.iterator(typeName), ResourceEntry::isDeclared);
            if (!iterator.hasNext()) continue;
            typeList.add(typeName);
        }
        resultPackage.getTypeStringPool().addStrings(typeList);
    }

    private void initializeSpecString(PackageBlock sourcePackage, PackageBlock resultPackage) {
        SpecStringPool sourcePool = sourcePackage.getSpecStringPool();
        HashSet<String> specList = new HashSet<String>(sourcePool.size());
        for (SpecString specString : sourcePool) {
            String name = specString.get();
            specList.add(name);
        }
        resultPackage.getSpecStringPool().addStrings(specList);
    }

    private void initializeEntries(PackageBlock sourcePackage, PackageBlock resultPackage) {
        TypeStringPool resultPool = resultPackage.getTypeStringPool();
        for (TypeString typeString : resultPool) {
            String typeName = typeString.get();
            this.initializeEntries(typeName, sourcePackage, resultPackage);
        }
    }

    private void initializeEntries(String typeName, PackageBlock sourcePackage, PackageBlock resultPackage) {
        ArrayCollection<ResourceEntry> sourceEntryList = new ArrayCollection<ResourceEntry>();
        Iterator<ResourceEntry> iterator = FilterIterator.of(sourcePackage.iterator(typeName), ResourceEntry::isDeclared);
        sourceEntryList.addAll(iterator);
        sourceEntryList.sort(this::compareEntryNames);
        TypeBlock typeBlock = resultPackage.getOrCreateTypeBlock(ResConfig.getDefault(), typeName);
        EntryArray entryArray = typeBlock.getEntryArray();
        int size = sourceEntryList.size();
        entryArray.setSize(sourceEntryList.size());
        for (int i = 0; i < size; ++i) {
            ResourceEntry resourceEntry = (ResourceEntry)sourceEntryList.get(i);
            Entry entry = (Entry)entryArray.get(i);
            assert (entry != null);
            entry.setName(resourceEntry.getName(), true);
        }
    }

    int compareEntryNames(ResourceEntry entry1, ResourceEntry entry2) {
        String name1 = entry1.getName();
        String name2 = entry2.getName();
        if (name1 == null && name2 != null) {
            return 1;
        }
        if (name1 != null && name2 == null) {
            return -1;
        }
        if (name1 == null) {
            return 0;
        }
        if (name1.startsWith("$")) {
            name1 = name1.substring(1);
        }
        if (name2.startsWith("$")) {
            name2 = name2.substring(1);
        }
        int i = name1.compareTo(name2);
        return CompareUtil.compare(i, 0);
    }
}

