/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.array.TableStringArray;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.group.StringGroup;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.TableHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.utils.CompareUtil;
import com.reandroid.xml.StyleDocument;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TableStringPool
extends StringPool<TableString> {
    public TableStringPool(boolean is_utf8) {
        super(is_utf8);
    }

    public TableString getOrCreateStyled(String xmlString) throws IOException, XmlPullParserException {
        StyleDocument document = StyleDocument.parseStyledString(xmlString);
        return this.getOrCreate(document);
    }

    public TableString getOrCreate(XmlPullParser parser) throws IOException, XmlPullParserException {
        StyleDocument document = StyleDocument.parseNext(parser);
        return this.getOrCreate(document);
    }

    public TableString getOrCreate(StyleDocument document) {
        String text = document.getXml();
        if (!document.hasElements()) {
            return (TableString)super.getOrCreate(text);
        }
        StringGroup group = super.get(text);
        if (group != null && group.size() > 0) {
            return (TableString)group.get(0);
        }
        TableString tableString = this.createStyled();
        tableString.set(document.getStyledString());
        StyleItem styleItem = tableString.getStyle();
        styleItem.parse(document);
        this.updateUniqueIdMap(tableString);
        styleItem.linkStringsInternal();
        return tableString;
    }

    private TableString createStyled() {
        int index = this.countStyles();
        TableString tableString = new TableString(this.isUtf8());
        StringArray<TableString> stringsArray = this.getStringsArray();
        stringsArray.addInternal(index, tableString);
        this.getStyleArray().ensureSize(index + 1);
        return tableString;
    }

    public void sort() {
        super.sort(CompareUtil.getComparableComparator());
    }

    @Override
    void linkStrings() {
        super.linkStrings();
        TableBlock tableBlock = this.getParentInstance(TableBlock.class);
        if (tableBlock != null) {
            tableBlock.linkTableStringsInternal(this);
        }
    }

    @Override
    StringArray<TableString> newInstance(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart, boolean is_utf8) {
        return new TableStringArray(offsets, itemCount, itemStart, is_utf8);
    }

    public void merge(TableStringPool stringPool) {
        if (stringPool == null || stringPool == this) {
            return;
        }
        StringArray existArray = this.getStringsArray();
        if (existArray.size() != 0) {
            return;
        }
        StringArray comingArray = stringPool.getStringsArray();
        int count = comingArray.size();
        existArray.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            TableString exist = (TableString)existArray.get(i);
            TableString coming = (TableString)comingArray.get(i);
            assert (coming != null);
            assert (exist != null);
            exist.set(coming.get());
        }
        this.getStyleArray().merge(stringPool.getStyleArray());
        this.refreshUniqueIdMap();
    }

    public static TableStringPool readFromTable(InputStream inputStream) throws IOException {
        TableHeader tableHeader = new TableHeader();
        tableHeader.readBytes(inputStream);
        if (tableHeader.getChunkType() != ChunkType.TABLE) {
            throw new IOException("Not TableBlock: " + tableHeader);
        }
        UnknownChunk poolChunk = new UnknownChunk();
        poolChunk.readBytes(inputStream);
        Object poolHeader = poolChunk.getHeaderBlock();
        if (((HeaderBlock)poolHeader).getChunkType() != ChunkType.STRING) {
            throw new IOException("Not StringPool chunk: " + poolChunk);
        }
        BlockReader blockReader = new BlockReader(poolChunk.getBytes());
        TableStringPool stringPool = new TableStringPool(true);
        stringPool.readBytes(blockReader);
        blockReader.close();
        return stringPool;
    }
}

