/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IndirectInteger;
import com.reandroid.arsc.item.ReferenceBlock;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.xml.Span;

public class StyleSpan
extends BlockItem
implements Span,
JSONConvert<JSONObject> {
    private final SpanStringReference stringReference = new SpanStringReference(this);
    private final IndirectInteger firstChar = new IndirectInteger(this, 4);
    private final IndirectInteger lastChar = new IndirectInteger(this, 8);
    public static final String NAME_tag = ObjectsUtil.of("tag");
    public static final String NAME_first = ObjectsUtil.of("first");
    public static final String NAME_last = ObjectsUtil.of("last");

    public StyleSpan() {
        super(12);
    }

    public String getString() {
        return this.stringReference.getString();
    }

    public void setString(String value) {
        this.stringReference.setString(value);
    }

    @Override
    public int getFirstChar() {
        return this.firstChar.get();
    }

    public void setFirstChar(int value) {
        this.firstChar.set(value);
    }

    @Override
    public int getLastChar() {
        return this.lastChar.get();
    }

    @Override
    public int getSpanOrder() {
        return this.getIndex();
    }

    public void setLastChar(int value) {
        this.lastChar.set(value);
    }

    @Override
    public String getTagName() {
        return Span.splitTagName(this.getString());
    }

    void link() {
        this.stringReference.link();
    }

    void onRemoved() {
        this.stringReference.unlink();
        this.stringReference.set(-1);
    }

    @Override
    public String getSpanAttributes() {
        return Span.splitAttribute(this.getString());
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_tag, this.getString());
        jsonObject.put(NAME_first, this.getFirstChar());
        jsonObject.put(NAME_last, this.getLastChar());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setString(json.getString(NAME_tag));
        this.setFirstChar(json.getInt(NAME_first));
        this.setLastChar(json.getInt(NAME_last));
    }

    public String toString() {
        return this.stringReference + " [" + this.getFirstChar() + ", " + this.getLastChar() + "]";
    }

    static class SpanStringReference
    extends ReferenceBlock<StyleSpan> {
        public SpanStringReference(StyleSpan styleSpan) {
            super(styleSpan, 0);
            this.set(-1);
        }

        public String getString() {
            StringItem stringItem = this.getStringItem();
            if (stringItem != null) {
                return stringItem.get();
            }
            return null;
        }

        public void setString(String value) {
            this.unlink();
            StringPool<?> stringPool = this.getStringPool();
            Object stringItem = stringPool.getOrCreateForSpan(value);
            this.set(((Block)stringItem).getIndex());
            ((StringItem)stringItem).addReference(this);
        }

        public void link() {
            StringItem stringItem = this.getStringItem();
            if (stringItem != null) {
                stringItem.addReference(this);
            }
        }

        public void unlink() {
            StringItem stringItem = this.getStringItem();
            if (stringItem != null) {
                stringItem.removeReference(this);
            }
        }

        private StringItem getStringItem() {
            StringPool<?> stringPool = this.getStringPool();
            if (stringPool != null) {
                return stringPool.get(this.get());
            }
            return null;
        }

        private StringPool<?> getStringPool() {
            return ((StyleSpan)this.getBlock()).getParentInstance(StringPool.class);
        }

        @Override
        public String toString() {
            String value = this.getString();
            if (value != null) {
                return value;
            }
            return "NULL{" + this.get() + "}";
        }
    }
}

