/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.array.StyleArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleSpan;
import com.reandroid.arsc.item.WeakStringReference;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.xml.SpanSet;
import com.reandroid.xml.StyleDocument;
import com.reandroid.xml.StyleElement;
import com.reandroid.xml.StyleSpanEventSet;
import java.io.IOException;
import java.util.Iterator;

public class StyleItem
extends FixedBlockContainer
implements Iterable<StyleSpan>,
SpanSet<StyleSpan>,
JSONConvert<JSONObject> {
    private final BlockList<StyleSpan> spanList = new BlockList();
    private final IntegerItem endBlock = new IntegerItem();
    private StyleIndexReference indexReference;
    private StringItem mStringItem;
    public static final String NAME_spans = ObjectsUtil.of("spans");

    public StyleItem() {
        super(2);
        this.addChild(0, this.spanList);
        this.addChild(1, this.endBlock);
        this.endBlock.set(-1);
    }

    public void add(String tag, int start, int end) {
        StyleSpan styleSpan = this.createNext();
        styleSpan.setString(tag);
        styleSpan.setFirstChar(start);
        styleSpan.setLastChar(end);
    }

    public StyleSpan createNext() {
        StyleSpan styleSpan = new StyleSpan();
        this.spanList.add(styleSpan);
        return styleSpan;
    }

    public StyleSpan get(int i) {
        return this.spanList.get(i);
    }

    public int size() {
        return this.spanList.size();
    }

    @Override
    public Iterator<StyleSpan> iterator() {
        return this.spanList.clonedIterator();
    }

    @Override
    public Iterator<StyleSpan> getSpans() {
        return this.iterator();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        BlockList<StyleSpan> spanList = this.spanList;
        while (reader.readInteger() != -1) {
            StyleSpan styleSpan = new StyleSpan();
            spanList.add(styleSpan);
            styleSpan.onReadBytes(reader);
        }
        this.endBlock.onReadBytes(reader);
    }

    public StyleDocument build(String text) {
        return StyleSpanEventSet.serialize(text, this);
    }

    public void parse(StyleDocument document) {
        this.clearStyle();
        Iterator<StyleElement> iterator = document.getElements();
        while (iterator.hasNext()) {
            this.parse(iterator.next());
        }
    }

    public void parse(StyleElement element) {
        this.add(element.getTagString(), element.getFirstChar(), element.getLastChar());
        Iterator<StyleElement> iterator = element.getElements();
        while (iterator.hasNext()) {
            this.parse(iterator.next());
        }
    }

    protected void clearStyle() {
        if (this.getParent() == null) {
            return;
        }
        for (StyleSpan styleSpan : this) {
            styleSpan.onRemoved();
        }
        this.spanList.clearChildes();
    }

    public void onRemoved() {
        StyleArray parentArray = this.getParentInstance(StyleArray.class);
        this.setParent(null);
        this.setIndex(-1);
        if (parentArray != null) {
            parentArray.remove(this);
        }
    }

    public void linkStringsInternal() {
        this.linkIndexReference();
        for (StyleSpan styleSpan : this) {
            styleSpan.link();
        }
    }

    private void linkIndexReference() {
        StringItem stringItem = this.getStringItem(this.getIndex());
        this.unLinkIndexReference(this.mStringItem);
        if (stringItem == null) {
            return;
        }
        StyleIndexReference reference = new StyleIndexReference(this);
        stringItem.addReference(reference);
        this.indexReference = reference;
        this.mStringItem = stringItem;
    }

    private void unLinkIndexReference(StringItem stringItem) {
        this.mStringItem = null;
        StyleIndexReference reference = this.indexReference;
        if (reference == null) {
            return;
        }
        this.indexReference = null;
        if (stringItem == null) {
            return;
        }
        stringItem.removeReference(reference);
    }

    private StringItem getStringItem(int ref) {
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool != null) {
            return stringPool.get(ref);
        }
        return null;
    }

    private StringPool<?> getStringPool() {
        return this.getParentInstance(StringPool.class);
    }

    public String applyStyle(String text, boolean xml, boolean escapeXmlText) {
        if (text == null) {
            return null;
        }
        StyleDocument styleDocument = this.build(text);
        if (styleDocument == null) {
            return text;
        }
        return styleDocument.getText(xml, escapeXmlText);
    }

    @Override
    public void setNull(boolean is_null) {
        if (!is_null) {
            return;
        }
        this.clearStyle();
    }

    @Override
    public JSONObject toJson() {
        if (this.isNull()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        for (StyleSpan spanInfo : this) {
            if (spanInfo == null) continue;
            JSONObject jsonObjectSpan = spanInfo.toJson();
            jsonArray.put(i, jsonObjectSpan);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        jsonObject.put(NAME_spans, jsonArray);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setNull(true);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = json.getJSONArray(NAME_spans);
        int length = jsonArray.length();
        for (int i = 0; i < length; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            StyleSpan styleSpan = this.createNext();
            styleSpan.fromJson(jsonObject);
        }
    }

    public void merge(StyleItem styleItem) {
        if (styleItem == null || styleItem == this) {
            return;
        }
        for (StyleSpan styleSpan : styleItem) {
            this.add(styleSpan.getString(), styleSpan.getFirstChar(), styleSpan.getLastChar());
        }
    }

    public String toString() {
        return "Spans count = " + this.size();
    }

    static final class StyleIndexReference
    implements WeakStringReference {
        private final StyleItem styleItem;

        StyleIndexReference(StyleItem styleItem) {
            this.styleItem = styleItem;
        }

        @Override
        public void set(int value) {
            StyleItem styleItem = this.styleItem;
            int oldIndex = styleItem.getIndex();
            StyleArray styleArray = styleItem.getParentInstance(StyleArray.class);
            if (styleArray != null) {
                StyleItem previous = (StyleItem)styleArray.get(oldIndex);
                if (previous == styleItem) {
                    styleArray.setItem(oldIndex, null);
                }
                styleArray.setItem(value, styleItem);
            }
        }

        @Override
        public int get() {
            return this.styleItem.getIndex();
        }

        @Override
        public <T1 extends Block> T1 getReferredParent(Class<T1> parentClass) {
            if (parentClass.isInstance(this.styleItem)) {
                return (T1)this.styleItem;
            }
            return null;
        }
    }
}

