/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.item.BlockItem;
import com.reandroid.utils.StringsUtil;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public abstract class StringBlock
extends BlockItem {
    private String mCache = "";
    public static final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();

    public StringBlock() {
        super(0);
    }

    public String get() {
        return this.mCache;
    }

    public void set(String text) {
        String old;
        if (text == null || text.length() == 0) {
            text = StringsUtil.EMPTY;
        }
        if (text.equals(old = this.mCache) && this.countBytes() != 0) {
            return;
        }
        this.mCache = text;
        byte[] bytes = this.encodeString(text);
        this.setBytesInternal(bytes, false);
        this.onStringChanged(old, text);
    }

    @Override
    protected void onBytesChanged() {
        this.mCache = this.decodeString(this.getBytesInternal());
    }

    protected void onStringChanged(String old, String text) {
    }

    protected abstract String decodeString(byte[] var1);

    protected abstract byte[] encodeString(String var1);

    public int compareTo(StringBlock stringBlock) {
        if (stringBlock == null) {
            return -1;
        }
        return StringsUtil.compareStrings(this.get(), stringBlock.get());
    }

    public String toString() {
        return this.get();
    }
}

