/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.utils.HexUtil;

public class ShortItem
extends BlockItem
implements IntegerReference {
    private int mCache;

    public ShortItem() {
        super(2);
    }

    public ShortItem(short value) {
        this();
        this.set(value);
    }

    @Override
    public void set(int value) {
        if (value == this.mCache) {
            return;
        }
        this.mCache = value;
        byte[] bytes = this.getBytesInternal();
        bytes[1] = (byte)(value >>> 8 & 0xFF);
        bytes[0] = (byte)(value & 0xFF);
    }

    @Override
    public int get() {
        return this.mCache;
    }

    public void set(short value) {
        this.set(0xFFFF & value);
    }

    public int unsignedInt() {
        return this.get();
    }

    public short getShort() {
        return (short)this.mCache;
    }

    public String toHex() {
        return HexUtil.toHex4(this.getShort());
    }

    @Override
    protected void onBytesChanged() {
        this.mCache = this.readShortBytes();
    }

    private int readShortBytes() {
        byte[] bytes = this.getBytesInternal();
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8;
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

