/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.StringItem;

public class ResXmlString
extends StringItem {
    public ResXmlString(boolean utf8) {
        super(utf8);
    }

    public ResXmlString(boolean utf8, String value) {
        this(utf8);
        this.set(value);
    }

    public int getResourceId() {
        ResXmlIDMap idMap = this.getResXmlIDMap();
        if (idMap == null) {
            return 0;
        }
        ResXmlID xmlId = idMap.getResXmlID(this.getIndex());
        if (xmlId == null) {
            return 0;
        }
        return xmlId.get();
    }

    private ResXmlIDMap getResXmlIDMap() {
        ResXmlDocument resXmlDocument = this.getParentInstance(ResXmlDocument.class);
        if (resXmlDocument != null) {
            return resXmlDocument.getResXmlIDMap();
        }
        return null;
    }

    @Override
    void ensureStringLinkUnlocked() {
    }

    @Override
    public int compareTo(StringItem stringItem) {
        if (!(stringItem instanceof ResXmlString)) {
            return -1;
        }
        ResXmlString xmlString = (ResXmlString)stringItem;
        int id1 = this.getResourceId();
        int id2 = xmlString.getResourceId();
        if (id1 != 0 && id2 != 0) {
            return Long.compare(0xFFFFFFFFL & (long)id1, 0xFFFFFFFFL & (long)id2);
        }
        if (id1 != 0) {
            return -1;
        }
        if (id2 != 0) {
            return 1;
        }
        return super.compareTo(stringItem);
    }
}

