/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.arsc.value.ResConfig;
import java.io.IOException;

public class TypeHeader
extends HeaderBlock {
    private final ByteItem id = new ByteItem();
    private final ByteItem flags = new ByteItem();
    private final IntegerItem count;
    private final IntegerItem entriesStart;
    private final ResConfig config;
    private static final byte FLAG_SPARSE = 1;
    private static final byte FLAG_OFFSET16 = 2;
    private static final int TYPE_MIN_SIZE = 36;

    public TypeHeader(boolean sparse, boolean offset16) {
        super(ChunkType.TYPE.ID);
        ShortItem reserved = new ShortItem();
        this.count = new IntegerItem();
        this.entriesStart = new IntegerItem();
        this.config = new ResConfig();
        this.addChild(this.id);
        this.addChild(this.flags);
        this.addChild(reserved);
        this.addChild(this.count);
        this.addChild(this.entriesStart);
        this.addChild(this.config);
        this.setSparse(sparse);
        this.setOffset16(offset16);
    }

    @Deprecated
    public TypeHeader(boolean sparse) {
        this(sparse, false);
    }

    public boolean isSparse() {
        return (this.getFlags().get() & 1) == 1;
    }

    public void setSparse(boolean sparse) {
        byte flag = this.getFlags().get();
        flag = sparse ? (byte)(flag | 1) : (byte)(flag & 0xFE);
        this.getFlags().set(flag);
    }

    public boolean isOffset16() {
        return this.getFlags().get() == 2;
    }

    public void setOffset16(boolean offset16) {
        byte flag = this.getFlags().get();
        flag = offset16 ? (byte)(flag | 2) : (byte)(flag & 0xFD);
        this.getFlags().set(flag);
    }

    @Override
    public int getMinimumSize() {
        return 36;
    }

    public ByteItem getId() {
        return this.id;
    }

    public ByteItem getFlags() {
        return this.flags;
    }

    public IntegerItem getCountItem() {
        return this.count;
    }

    public IntegerItem getEntriesStart() {
        return this.entriesStart;
    }

    public ResConfig getConfig() {
        return this.config;
    }

    @Override
    public String toString() {
        if (this.getChunkType() != ChunkType.TYPE) {
            return super.toString();
        }
        return this.getClass().getSimpleName() + " {id=" + this.getId().toHex() + ", flags=" + this.getFlags().toHex() + ", count=" + this.getCountItem() + ", entriesStart=" + this.getEntriesStart() + ", config=" + this.getConfig() + '}';
    }

    public static TypeHeader read(BlockReader reader) throws IOException {
        TypeHeader typeHeader = new TypeHeader(false, false);
        if (reader.available() < typeHeader.getMinimumSize()) {
            throw new IOException("Too few bytes to read type header, available = " + reader.available());
        }
        int pos = reader.getPosition();
        typeHeader.readBytes(reader);
        reader.seek(pos);
        return typeHeader;
    }
}

