/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.header;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ShortItem;

public class StringPoolHeader
extends HeaderBlock {
    private final IntegerItem countStrings = new IntegerItem();
    private final IntegerItem countStyles = new IntegerItem();
    private final ByteItem flagSorted = new ByteItem();
    private final ByteItem flagUtf8 = new ByteItem();
    private final ShortItem flagExtra = new ShortItem();
    private final IntegerItem startStrings = new IntegerItem();
    private final IntegerItem startStyles = new IntegerItem();

    public StringPoolHeader() {
        super(ChunkType.STRING.ID);
        this.addChild(this.countStrings);
        this.addChild(this.countStyles);
        this.addChild(this.flagSorted);
        this.addChild(this.flagUtf8);
        this.addChild(this.flagExtra);
        this.addChild(this.startStrings);
        this.addChild(this.startStyles);
    }

    public IntegerItem getCountStrings() {
        return this.countStrings;
    }

    public IntegerItem getCountStyles() {
        return this.countStyles;
    }

    public ByteItem getFlagUtf8() {
        return this.flagUtf8;
    }

    public ByteItem getFlagSorted() {
        return this.flagSorted;
    }

    public ShortItem getFlagExtra() {
        return this.flagExtra;
    }

    public IntegerItem getStartStrings() {
        return this.startStrings;
    }

    public IntegerItem getStartStyles() {
        return this.startStyles;
    }

    public boolean isUtf8() {
        return (this.getFlagUtf8().get() & 1) != 0;
    }

    public void setUtf8(boolean utf8) {
        this.getFlagUtf8().set((byte)(utf8 ? 1 : 0));
    }

    public boolean isSorted() {
        return (this.getFlagSorted().get() & 1) != 0;
    }

    public void setSorted(boolean sorted) {
        this.getFlagSorted().set((byte)(sorted ? 1 : 0));
    }

    @Override
    public String toString() {
        if (this.getChunkType() != ChunkType.STRING) {
            return super.toString();
        }
        return this.getClass().getSimpleName() + " {strings=" + this.getCountStrings() + ", styles=" + this.getCountStyles() + ", utf8=" + this.isUtf8() + ", sorted=" + this.isSorted() + ", flagExtra=" + this.getFlagExtra().toHex() + ", offset-strings=" + this.getStartStrings().get() + ", offset-styles=" + this.getStartStyles().get() + '}';
    }
}

