/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.array.SpecTypePairArray;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.LibraryBlock;
import com.reandroid.arsc.chunk.Overlayable;
import com.reandroid.arsc.chunk.OverlayablePolicy;
import com.reandroid.arsc.chunk.StagedAlias;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.SpecHeader;
import com.reandroid.arsc.header.TypeHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.list.OverlayableList;
import com.reandroid.arsc.list.StagedAliasList;
import java.io.IOException;

public class PackageBody
extends FixedBlockContainer {
    private final SpecTypePairArray mSpecTypePairArray = new SpecTypePairArray();
    private final LibraryBlock mLibraryBlock = new LibraryBlock();
    private final StagedAliasList mStagedAliasList = new StagedAliasList();
    private final OverlayableList mOverlayableList = new OverlayableList();
    private final BlockList<OverlayablePolicy> mOverlayablePolicyList = new BlockList();
    private final BlockList<UnknownChunk> mUnknownChunkList = new BlockList();

    public PackageBody() {
        super(6);
        this.addChild(0, this.mSpecTypePairArray);
        this.addChild(1, this.mLibraryBlock);
        this.addChild(2, this.mStagedAliasList);
        this.addChild(3, this.mOverlayableList);
        this.addChild(4, this.mOverlayablePolicyList);
        this.addChild(5, this.mUnknownChunkList);
    }

    public boolean isEmpty() {
        return this.getSpecTypePairArray().isEmpty() && this.getLibraryBlock().isEmpty() && this.getStagedAliasList().size() == 0 && this.getOverlayableList().size() == 0 && this.getOverlayablePolicyList().size() == 0 && this.getUnknownChunkList().size() == 0;
    }

    public void destroy() {
        this.getSpecTypePairArray().clear();
        this.getLibraryBlock().getLibraryInfoArray().clear();
        this.getStagedAliasList().clearChildes();
        this.getOverlayableList().clearChildes();
        this.getOverlayablePolicyList().clearChildes();
        this.getUnknownChunkList().clearChildes();
    }

    public OverlayableList getOverlayableList() {
        return this.mOverlayableList;
    }

    public BlockList<OverlayablePolicy> getOverlayablePolicyList() {
        return this.mOverlayablePolicyList;
    }

    public StagedAliasList getStagedAliasList() {
        return this.mStagedAliasList;
    }

    public LibraryBlock getLibraryBlock() {
        return this.mLibraryBlock;
    }

    public SpecTypePairArray getSpecTypePairArray() {
        return this.mSpecTypePairArray;
    }

    public BlockList<UnknownChunk> getUnknownChunkList() {
        return this.mUnknownChunkList;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean readOk = true;
        while (readOk) {
            readOk = this.readNextBlock(reader);
        }
    }

    private boolean readNextBlock(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        int pos = reader.getPosition();
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.SPEC) {
            this.readSpecBlock(reader);
        } else if (chunkType == ChunkType.TYPE) {
            this.readTypeBlock(reader);
        } else if (chunkType == ChunkType.LIBRARY) {
            this.readLibraryBlock(reader);
        } else if (chunkType == ChunkType.OVERLAYABLE) {
            this.readOverlayable(reader);
        } else if (chunkType == ChunkType.OVERLAYABLE_POLICY) {
            this.readOverlayablePolicy(reader);
        } else if (chunkType == ChunkType.STAGED_ALIAS) {
            this.readStagedAlias(reader);
        } else {
            this.readUnknownChunk(reader);
        }
        return pos != reader.getPosition();
    }

    private void readSpecBlock(BlockReader reader) throws IOException {
        SpecHeader specHeader = SpecHeader.read(reader);
        SpecTypePair specTypePair = this.mSpecTypePairArray.getOrCreate(specHeader.getId().get());
        specTypePair.getSpecBlock().readBytes(reader);
    }

    private void readTypeBlock(BlockReader reader) throws IOException {
        TypeHeader typeHeader = TypeHeader.read(reader);
        SpecTypePair specTypePair = this.mSpecTypePairArray.getOrCreate(typeHeader.getId().get());
        TypeBlock typeBlock = specTypePair.getTypeBlockArray().createNext(typeHeader.isSparse(), typeHeader.isOffset16());
        typeBlock.readBytes(reader);
    }

    private void readLibraryBlock(BlockReader reader) throws IOException {
        LibraryBlock libraryBlock = new LibraryBlock();
        libraryBlock.readBytes(reader);
        this.mLibraryBlock.addLibraryInfo(libraryBlock);
    }

    private void readStagedAlias(BlockReader reader) throws IOException {
        StagedAlias stagedAlias = new StagedAlias();
        stagedAlias.readBytes(reader);
        this.mStagedAliasList.add(stagedAlias);
    }

    private void readOverlayable(BlockReader reader) throws IOException {
        Overlayable overlayable = new Overlayable();
        overlayable.readBytes(reader);
        this.mOverlayableList.add(overlayable);
    }

    private void readOverlayablePolicy(BlockReader reader) throws IOException {
        OverlayablePolicy overlayablePolicy = new OverlayablePolicy();
        overlayablePolicy.readBytes(reader);
        this.mOverlayablePolicyList.add(overlayablePolicy);
    }

    private void readUnknownChunk(BlockReader reader) throws IOException {
        UnknownChunk unknownChunk = new UnknownChunk();
        unknownChunk.readBytes(reader);
        this.mUnknownChunkList.add(unknownChunk);
    }
}

