/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.utils.collection.ArrayCollection;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class BlockList<T extends Block>
extends Block
implements BlockRefresh {
    private ArrayCollection<T> mItems = ArrayCollection.empty();
    private Creator<? extends T> mCreator;
    private static final BlockList<?> empty_list = new BlockList<Block>(){

        @Override
        public boolean add(Block item) {
            throw new IllegalArgumentException("Empty BlockList");
        }

        @Override
        public void add(int index, Block item) {
            throw new IllegalArgumentException("Empty BlockList");
        }

        @Override
        public void ensureCapacity(int capacity) {
            if (capacity != 0) {
                throw new IllegalArgumentException("Empty BlockList");
            }
        }

        @Override
        public void setSize(int size) {
            if (size != 0) {
                throw new IllegalArgumentException("Empty BlockList");
            }
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public BlockList(Creator<? extends T> creator) {
        this.mCreator = creator;
    }

    public BlockList() {
        this(null);
    }

    public Creator<? extends T> getCreator() {
        return this.mCreator;
    }

    public void setCreator(Creator<T> creator) {
        this.mCreator = creator;
        if (this.mItems.isImmutableEmpty()) {
            return;
        }
        this.updateCreator();
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void setSize(int size) {
        if (size == 0) {
            this.lockList();
        } else if (this.mCreator != null || size < this.size()) {
            this.unlockList();
            this.mItems.setSize(size);
        }
    }

    public void removeAll() {
        this.mItems.removeAll();
    }

    public void setElements(T[] elements) {
        if (elements == null || elements.length == 0) {
            this.lockList();
            return;
        }
        this.unlockList();
        Creator<T> creator = this.getCreator();
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            T item = elements[i];
            if (item == null && creator != null) {
                elements[i] = item = creator.newInstanceAt(i);
            }
            this.onItemCreated(i, item);
        }
        this.mItems.setElements(elements);
        this.onChanged();
    }

    void onItemCreated(int index, T item) {
        if (item == null) {
            return;
        }
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
    }

    public T createAt(int index) {
        Creator<T> creator = this.getCreator();
        this.ensureSize(index);
        T item = creator.newInstanceAt(index);
        this.add(index, item);
        return item;
    }

    public T createNext() {
        Creator<T> creator = this.getCreator();
        T item = creator.newInstanceAt(this.size());
        this.add(item);
        return item;
    }

    public T getFirst() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            T item = this.get(i);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public T getLast() {
        int size;
        for (int i = size = this.size() - 1; i >= 0; --i) {
            T item = this.get(i);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public Iterator<T> clonedIterator() {
        return this.mItems.clonedIterator();
    }

    public Iterator<T> arrayIterator() {
        return this.mItems.arrayIterator();
    }

    public Iterator<T> iterator() {
        return this.mItems.iterator();
    }

    public Iterator<T> iterator(int start, int length) {
        return this.mItems.iterator(start, length);
    }

    public Iterator<T> iterator(Predicate<? super T> filter) {
        return this.mItems.iterator(filter);
    }

    public <T1> Iterator<T1> iterator(Class<T1> instance) {
        return this.mItems.iterator(instance);
    }

    public void clearChildes() {
        if (this.mItems.isEmpty()) {
            return;
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.remove(this.size() - 1, false);
        }
        this.lockList();
        this.onChanged();
    }

    public void destroy() {
        this.mItems.clear();
        this.lockList();
        this.onChanged();
    }

    public boolean sort(Comparator<? super T> comparator) {
        if (this.size() < 2) {
            return false;
        }
        if (this.mItems.sortItems(comparator)) {
            return this.updateIndex();
        }
        return false;
    }

    public boolean needsSort(Comparator<? super T> comparator) {
        if (comparator == null) {
            return false;
        }
        int length = this.size();
        if (length < 2) {
            return false;
        }
        T previous = this.get(0);
        for (int i = 1; i < length; ++i) {
            T item = this.get(i);
            if (comparator.compare(previous, item) > 0) {
                return true;
            }
            previous = item;
        }
        return false;
    }

    public int remove(Predicate<? super T> filter) {
        int count = 0;
        int minIndex = this.size();
        for (int i = 0; i < this.size(); ++i) {
            T item = this.get(i);
            if (!filter.test(item)) continue;
            this.remove(i, false);
            if (i < minIndex) {
                minIndex = i;
            }
            ++count;
            --i;
        }
        this.updateIndex(minIndex);
        return count;
    }

    public T remove(int index) {
        return this.remove(index, true);
    }

    private T remove(int index, boolean updateIndex) {
        Block item = (Block)this.mItems.remove(index);
        if (item == null) {
            return null;
        }
        this.onPreRemove(item);
        item.setParent(null);
        item.setIndex(-1);
        if (updateIndex) {
            this.updateIndex(index);
        }
        this.onChanged();
        return (T)item;
    }

    public boolean remove(T item) {
        return this.remove(item, true);
    }

    private boolean remove(T item, boolean updateIndex) {
        boolean removed;
        this.onPreRemove(item);
        int index = -1;
        if (item != null) {
            index = this.mItems.indexOfFast(item, ((Block)item).getIndex());
            if (index < 0) {
                index = this.mItems.indexOfFast(item);
            }
            ((Block)item).setParent(null);
            ((Block)item).setIndex(-1);
        }
        if (index < 0) {
            index = this.mItems.indexOfFast(item);
        }
        boolean bl = removed = this.mItems.remove(index) != null;
        if (updateIndex && removed) {
            this.updateIndex(index);
        }
        this.onChanged();
        return removed;
    }

    public void onPreRemove(T item) {
    }

    public void sortSingle(T element, Comparator<? super T> comparator) {
        int count = this.getCount();
        if (count < 2) {
            return;
        }
        int attempts = 0;
        this.mItems.remove(element);
        int speedLimit = count / 20;
        int prev = 0;
        int speed = 0;
        int acceleration = 1;
        boolean skipAcceleration = false;
        for (int i = 0; i < count; ++i) {
            ++attempts;
            T item = this.get(i);
            if (element == item) continue;
            int compare = comparator.compare(item, element);
            if (compare == 0) {
                this.add(i, element);
                return;
            }
            if (compare > 0) {
                if (i == 0 || attempts < 0) {
                    this.add(i, element);
                    return;
                }
                if (prev > 0) {
                    i = prev - 1;
                    prev = -1;
                    continue;
                }
                this.add(i, element);
                return;
            }
            if (prev < 0) continue;
            prev = i;
            if (attempts % 8 == 0) {
                speed += acceleration;
            }
            if (attempts % (16 + acceleration) == 0) {
                if (!skipAcceleration) {
                    ++acceleration;
                    skipAcceleration = true;
                } else {
                    skipAcceleration = false;
                }
            }
            if (speed > speedLimit) {
                speed = speedLimit;
            }
            if ((i += speed) < count) continue;
            i = prev - 1;
            prev = -1;
        }
        this.add(element);
    }

    private void sortSingleBack(T element, Comparator<? super T> comparator, int start) {
        for (int i = start; i >= 0; --i) {
            int compare;
            T item = this.get(i);
            if (element == item || (compare = comparator.compare(item, element)) >= 0) continue;
            if (i != start) {
                ++i;
            }
            this.add(i, element);
            return;
        }
        this.add(start, element);
    }

    public void swap(T item1, T item2) {
        if (item1 == item2) {
            return;
        }
        int i1 = ((Block)item1).getIndex();
        int i2 = ((Block)item2).getIndex();
        this.mItems.swap(i1, i2);
        ((Block)item1).setIndex(i2);
        ((Block)item2).setIndex(i1);
    }

    public void moveTo(T item, int index) {
        if (index < 0) {
            index = 0;
        }
        int i = ((Block)item).getIndex();
        this.mItems.move(i, index);
        this.updateIndex(i, index);
    }

    public void set(int index, T item) {
        if (item == null) {
            return;
        }
        this.unlockList();
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
        this.mItems.set(index, item);
        this.onChanged();
    }

    public void addAll(int index, T[] items) {
        if (items == null) {
            return;
        }
        int length = items.length;
        if (length == 0) {
            return;
        }
        this.unlockList();
        this.mItems.addAll(index, items);
        for (int i = 0; i < length; ++i) {
            T item = items[i];
            if (item == null) continue;
            ((Block)item).setIndex(index);
            ((Block)item).setParent(this);
            ++index;
        }
        this.updateIndex(index);
        this.onChanged();
    }

    public void add(int index, T item) {
        if (item == null) {
            return;
        }
        this.unlockList();
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
        this.mItems.add(index, item);
        this.updateIndex(index);
        this.onChanged();
    }

    private boolean updateIndex() {
        return this.updateIndex(0);
    }

    private boolean updateIndex(int start) {
        return this.updateIndex(start, this.size());
    }

    private boolean updateIndex(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (start > end) {
            int i = start;
            start = end;
            end = i;
        }
        boolean changed = false;
        int count = this.size();
        if (++end > count) {
            end = count;
        }
        List<T> items = this.getChildes();
        for (int i = start; i < end; ++i) {
            Block item = (Block)items.get(i);
            if (item.getIndex() == i) continue;
            item.setIndex(i);
            changed = true;
        }
        return changed;
    }

    public boolean add(T item) {
        if (item == null) {
            return false;
        }
        this.unlockList();
        int index = this.size();
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
        boolean result = this.mItems.add(item);
        this.onChanged();
        return result;
    }

    public T get(int i) {
        if (i >= this.mItems.size() || i < 0) {
            return null;
        }
        return (T)((Block)this.mItems.get(i));
    }

    public int getCount() {
        return this.size();
    }

    public int size() {
        return this.mItems.size();
    }

    public void ensureCapacity(int capacity) {
        this.unlockList();
        this.mItems.ensureCapacity(capacity);
    }

    public void trimToSize() {
        this.mItems.trimToSize();
        if (this.mItems.size() == 0) {
            this.lockList();
        }
    }

    public boolean contains(Object obj) {
        return this.mItems.contains(obj);
    }

    public boolean containsExact(Object obj) {
        return this.mItems.containsFast(obj);
    }

    public Object[] toArray() {
        return this.mItems.toArray();
    }

    public <T1> T1[] toArray(T1[] ts) {
        return this.mItems.toArray(ts);
    }

    public List<T> getChildes() {
        return this.mItems;
    }

    private void lockList() {
        if (this.mItems.isImmutableEmpty()) {
            return;
        }
        this.mItems = ArrayCollection.empty();
    }

    private void unlockList() {
        if (!this.mItems.isImmutableEmpty()) {
            return;
        }
        this.mItems = new ArrayCollection();
        this.updateCreator();
    }

    private void updateCreator() {
        final Creator<T> creator = this.getCreator();
        if (creator == null) {
            this.mItems.setInitializer(null);
            return;
        }
        ArrayCollection.Initializer initializer = new ArrayCollection.Initializer<T>(){

            @Override
            public T createNewItem(int index) {
                Object item = creator.newInstanceAt(index);
                BlockList.this.onItemCreated(index, item);
                return item;
            }

            @Override
            public T[] newArray(int length) {
                return creator.newArrayInstance(length);
            }
        };
        this.mItems.setInitializer(initializer);
    }

    @Override
    public final void refresh() {
        if (this.isNull()) {
            return;
        }
        this.trimToSize();
        this.onPreRefresh();
        this.refreshChildes();
        this.onRefreshed();
        this.onChanged();
    }

    protected void onPreRefresh() {
    }

    protected void onRefreshed() {
        this.onChanged();
    }

    public void onChanged() {
        this.mItems.onChanged();
    }

    private void refreshChildes() {
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!(item instanceof BlockRefresh)) continue;
            ((BlockRefresh)item).refresh();
        }
    }

    @Override
    public byte[] getBytes() {
        byte[] results = null;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            results = BlockList.addBytes(results, ((Block)iterator.next()).getBytes());
        }
        return results;
    }

    @Override
    public int countBytes() {
        int result = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            T item = this.get(i);
            if (item == null) continue;
            result += ((Block)item).countBytes();
        }
        return result;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        int size = this.size();
        for (int i = 0; i < size && !counter.FOUND; ++i) {
            T item = this.get(i);
            if (item == null) continue;
            ((Block)item).onCountUpTo(counter);
        }
    }

    public void readChildes(BlockReader reader) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            T item = this.get(i);
            ((Block)item).readBytes(reader);
        }
        this.onChanged();
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        int result = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            T item = this.get(i);
            if (item == null) continue;
            result += ((Block)item).writeBytes(stream);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockList blockList = (BlockList)obj;
        return this.mItems.equals(blockList.mItems);
    }

    public int hashCode() {
        return this.mItems.hashCode();
    }

    public String toString() {
        return "size=" + this.size();
    }

    public static boolean isImmutableEmpty(Object blockList) {
        return empty_list == blockList;
    }

    public static <T1 extends Block> BlockList<T1> empty() {
        return empty_list;
    }
}

