/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder.xml;

import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.XmlSanitizer;
import com.reandroid.arsc.coder.xml.ValuesDirectorySerializer;
import com.reandroid.arsc.coder.xml.ValuesSerializerFactory;
import com.reandroid.arsc.coder.xml.XmlCoderLogger;
import com.reandroid.arsc.coder.xml.XmlDecodeUtil;
import com.reandroid.arsc.coder.xml.XmlEncodeException;
import com.reandroid.arsc.coder.xml.XmlEncodeUtil;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.io.IOUtil;
import com.reandroid.xml.StyleDocument;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLFactory;
import com.reandroid.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlCoder {
    private static XmlCoder sInstance;
    public final ValuesXml VALUES_XML = new ValuesXml();
    private XmlCoderLogger mLogger;
    static final String ATTR_name = "name";
    static final String ATTR_formats = "formats";
    static final String ATTR_parent = "parent";
    static final String ATTR_quantity = "quantity";
    static final String ATTR_type = "type";
    static final String TAG_item = "item";

    public void setLogger(XmlCoderLogger logger) {
        this.mLogger = logger;
        this.VALUES_XML.setLogger(logger);
    }

    public XmlCoderLogger getLogger() {
        return this.mLogger;
    }

    private void logMessage(String tag, String message) {
        XmlCoderLogger logger = this.getLogger();
        if (logger != null) {
            logger.logMessage(tag, message);
        }
    }

    private void logVerbose(String tag, String message) {
        XmlCoderLogger logger = this.getLogger();
        if (logger != null) {
            logger.logMessage(tag, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlCoder getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        Class<XmlCoder> clazz = XmlCoder.class;
        synchronized (XmlCoder.class) {
            if (sInstance == null) {
                sInstance = new XmlCoder();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    static enum ChildType {
        ATTR,
        ARRAY,
        PLURAL,
        STYLE;


        public static ChildType getType(XMLElement child) {
            String tag = child.getName(false);
            if (AttributeDataFormat.fromBagTypeName(tag) != null) {
                return ATTR;
            }
            if (!XmlCoder.TAG_item.equals(tag)) {
                return null;
            }
            if (child.getAttribute(XmlCoder.ATTR_name) != null) {
                return STYLE;
            }
            int count = child.getAttributeCount();
            if (count == 0 || count == 1 && child.getAttribute(XmlCoder.ATTR_type) != null) {
                return ARRAY;
            }
            AttributeType attributeType = AttributeType.fromName(child.getAttributeValue(XmlCoder.ATTR_quantity));
            if (attributeType != null && attributeType.isPlural()) {
                return PLURAL;
            }
            return STYLE;
        }

        public static ChildType getType(Entry entry) {
            ResTableMapEntry mapEntry = entry.getResTableMapEntry();
            if (mapEntry.isAttr()) {
                return ATTR;
            }
            if (mapEntry.isArray()) {
                return ARRAY;
            }
            if (mapEntry.isPlural()) {
                return PLURAL;
            }
            return STYLE;
        }
    }

    public static class BagRootAttribute {
        public void decode(XmlSerializer serializer, Entry entry) throws IOException {
            this.decodeParent(serializer, entry);
            this.decodeAttrTypes(serializer, entry);
        }

        public void decodeAttrTypes(XmlSerializer serializer, Entry entry) throws IOException {
            if (!entry.getTypeBlock().isTypeAttr()) {
                return;
            }
            ResTableMapEntry mapEntry = entry.getResTableMapEntry();
            ResValueMapArray mapArray = (ResValueMapArray)mapEntry.getValue();
            for (ResValueMap valueMap : (ResValueMap[])mapArray.getChildes()) {
                AttributeType attributeType;
                if (valueMap == null || (attributeType = valueMap.getAttributeType()) == null) continue;
                boolean ignore_empty = mapArray.size() > 1;
                valueMap.serializeAttribute(serializer, attributeType.getName(), ignore_empty);
            }
        }

        public void decodeParent(XmlSerializer serializer, Entry entry) throws IOException {
            ResTableMapEntry mapEntry = entry.getResTableMapEntry();
            String parent = mapEntry.decodeParentId();
            if (parent != null) {
                serializer.attribute(null, XmlCoder.ATTR_parent, parent);
                return;
            }
            if (mapEntry.isStyle() && mapEntry.childesCount() == 0) {
                serializer.attribute(null, XmlCoder.ATTR_parent, "");
            }
        }

        public void encode(XMLElement element, Entry entry) throws IOException {
            Iterator<? extends XMLAttribute> attributes = element.getAttributes();
            while (attributes.hasNext()) {
                XMLAttribute xmlAttribute = attributes.next();
                this.encode(xmlAttribute, entry);
            }
        }

        public void encode(XMLAttribute xmlAttribute, Entry entry) throws IOException {
            if (xmlAttribute.getPrefix() != null) {
                throw new XmlEncodeException("Unknown root attribute: " + xmlAttribute.getDebugText());
            }
            this.encode(xmlAttribute.getName(false), xmlAttribute.getValueAsString(false), entry);
        }

        public void encode(String name, String value, Entry entry) throws IOException {
            if (name.equals(XmlCoder.ATTR_name)) {
                this.encodeName(value, entry);
            } else if (name.equals(XmlCoder.ATTR_parent)) {
                this.encodeParent(value, entry);
            } else if (name.equals(XmlCoder.ATTR_formats)) {
                this.encodeFormats(value, entry);
            } else {
                AttributeType attributeType = AttributeType.fromName(name);
                if (attributeType != null) {
                    this.encodeType(attributeType, value, entry);
                }
            }
        }

        public void encodeType(AttributeType attributeType, String value, Entry entry) throws IOException {
            entry.ensureComplex(true);
            ResValueMapArray mapArray = entry.getResValueMapArray();
            Object valueMap = mapArray.getOrCreateType(attributeType);
            EncodeResult encodeResult = ValueCoder.encodeReference(entry.getPackageBlock(), value);
            if (encodeResult != null) {
                if (encodeResult.isError()) {
                    throw new XmlEncodeException(encodeResult.getError());
                }
                ((ValueItem)valueMap).setValue(encodeResult);
                return;
            }
            encodeResult = ValueCoder.encode(value);
            if (encodeResult != null) {
                if (encodeResult.isError()) {
                    throw new XmlEncodeException(encodeResult.getError());
                }
                ((ValueItem)valueMap).setValue(encodeResult);
                return;
            }
            value = XmlSanitizer.unEscapeUnQuote(value);
            ((ValueItem)valueMap).setValueAsString(value);
        }

        public void encodeFormats(String value, Entry entry) {
            entry.ensureComplex(true);
            ResValueMapArray mapArray = entry.getResValueMapArray();
            Object valueMap = mapArray.getOrCreateType(AttributeType.FORMATS);
            AttributeDataFormat[] dataFormats = AttributeDataFormat.parseValueTypes(value);
            ((ValueItem)valueMap).setData(AttributeDataFormat.sum(dataFormats));
        }

        public void encodeParent(String value, Entry entry) throws IOException {
            PackageBlock packageBlock = entry.getPackageBlock();
            EncodeResult parent = ValueCoder.encodeReference(packageBlock, value);
            if (parent != null) {
                if (parent.isError()) {
                    throw new XmlEncodeException(parent.getError());
                }
                entry.ensureComplex(true);
                entry.getResTableMapEntry().setParentId(parent.value);
            }
        }

        public void encodeName(String value, Entry entry) {
            if (entry.isDefined()) {
                return;
            }
            if (value == null || value.length() == 0) {
                return;
            }
            entry.setName(value);
        }
    }

    public static class BagChild {
        public void encode(XMLElement child, Entry entry) throws IOException {
            ChildType childType = ChildType.getType(child);
            if (childType == null) {
                throw new XmlEncodeException("Unknown child bag: " + child.getDebugText());
            }
            switch (childType) {
                case ATTR: {
                    this.encodeAttr(child, entry);
                    break;
                }
                case ARRAY: {
                    this.encodeArray(child, entry);
                    break;
                }
                case PLURAL: {
                    this.encodePlural(child, entry);
                    break;
                }
                case STYLE: {
                    this.encodeStyle(child, entry);
                }
            }
        }

        public int decode(XmlSerializer serializer, Entry entry) throws IOException {
            ChildType childType = ChildType.getType(entry);
            switch (childType) {
                case ATTR: {
                    return this.decodeAttr(serializer, entry);
                }
                case ARRAY: {
                    return this.decodeArray(serializer, entry);
                }
                case PLURAL: {
                    return this.decodePlural(serializer, entry);
                }
                case STYLE: {
                    return this.decodeStyle(serializer, entry);
                }
            }
            return 0;
        }

        public int decodeAttr(XmlSerializer serializer, Entry entry) throws IOException {
            ResTableMapEntry mapEntry = entry.getResTableMapEntry();
            Object formatsMap = mapEntry.getByType(AttributeType.FORMATS);
            AttributeDataFormat bagType = AttributeDataFormat.typeOfBag(((ValueItem)formatsMap).getData());
            ResValueMap[] bagItems = mapEntry.listResValueMap();
            int childCount = 0;
            for (ResValueMap valueMap : bagItems) {
                AttributeType attributeType = valueMap.getAttributeType();
                if (attributeType != null) continue;
                assert (bagType != null);
                this.startTag(serializer, bagType.getName());
                serializer.attribute(null, XmlCoder.ATTR_name, valueMap.decodeName());
                serializer.text(valueMap.decodeValue());
                this.endTag(serializer, bagType.getName());
                ++childCount;
            }
            return childCount;
        }

        public int decodePlural(XmlSerializer serializer, Entry entry) throws IOException {
            ResTableMapEntry mapEntry = entry.getResTableMapEntry();
            ResValueMapArray mapArray = (ResValueMapArray)mapEntry.getValue();
            int childCount = 0;
            for (ResValueMap valueMap : (ResValueMap[])mapArray.getChildes()) {
                AttributeType attributeType;
                if (valueMap == null || (attributeType = valueMap.getAttributeType()) == null) continue;
                this.startTag(serializer, XmlCoder.TAG_item);
                serializer.attribute(null, XmlCoder.ATTR_quantity, attributeType.getName());
                valueMap.serializeText(serializer);
                this.endTag(serializer, XmlCoder.TAG_item);
                ++childCount;
            }
            return childCount;
        }

        public int decodeStyle(XmlSerializer serializer, Entry entry) throws IOException {
            ResTableMapEntry mapEntry = entry.getResTableMapEntry();
            ResValueMapArray mapArray = (ResValueMapArray)mapEntry.getValue();
            int childCount = 0;
            for (ResValueMap valueMap : (ResValueMap[])mapArray.getChildes()) {
                if (valueMap == null) continue;
                this.startTag(serializer, XmlCoder.TAG_item);
                String name = valueMap.decodeName(true);
                boolean escapeValue = false;
                if (name == null) {
                    name = ValueCoder.decodeUnknownNameId(valueMap.getNameId());
                    escapeValue = true;
                }
                serializer.attribute(null, XmlCoder.ATTR_name, name);
                valueMap.serializeText(serializer, escapeValue);
                this.endTag(serializer, XmlCoder.TAG_item);
                ++childCount;
            }
            return childCount;
        }

        public int decodeArray(XmlSerializer serializer, Entry entry) throws IOException {
            boolean escapeValues = "array".equals(entry.getXmlTag());
            ResTableMapEntry mapEntry = entry.getResTableMapEntry();
            ResValueMapArray mapArray = (ResValueMapArray)mapEntry.getValue();
            int childCount = 0;
            for (ResValueMap valueMap : (ResValueMap[])mapArray.getChildes()) {
                if (valueMap == null) continue;
                this.startTag(serializer, XmlCoder.TAG_item);
                valueMap.serializeText(serializer, escapeValues);
                this.endTag(serializer, XmlCoder.TAG_item);
                ++childCount;
            }
            return childCount;
        }

        public void encodeAttr(XMLElement child, Entry entry) throws IOException {
            AttributeDataFormat dataFormat = AttributeDataFormat.fromBagTypeName(child.getName());
            entry.ensureComplex(true);
            ResValueMapArray mapArray = entry.getResValueMapArray();
            Object formats = mapArray.getOrCreateType(AttributeType.FORMATS);
            ((ResValueMap)formats).addAttributeTypeFormat(dataFormat);
            Block valueMap = mapArray.createNext();
            XMLAttribute attribute = child.getAttribute(XmlCoder.ATTR_name);
            ResourceEntry resourceEntry = ((AttributeValue)valueMap).encodeIdName(attribute.getPrefix(), attribute.getValueAsString());
            if (resourceEntry == null) {
                throw new XmlEncodeException("Unknown " + dataFormat.getName() + " name: " + child.getDebugText());
            }
            EncodeResult encodeResult = ValueCoder.encode(child.getTextContent().trim());
            if (encodeResult == null) {
                throw new XmlEncodeException("Unexpected value: " + child.getDebugText());
            }
            if (encodeResult.isError()) {
                throw new XmlEncodeException(encodeResult.getError() + ": " + child.getDebugText());
            }
            ((ValueItem)valueMap).setValue(encodeResult);
            entry.getHeader().setPublic(true);
        }

        public void encodeArray(XMLElement child, Entry entry) throws IOException {
            entry.ensureComplex(true);
            ResValueMapArray mapArray = entry.getResValueMapArray();
            Block valueMap = mapArray.createNext();
            ((ResValueMap)valueMap).setArrayIndex();
            String text = child.getTextContent();
            EncodeResult encodeResult = ValueCoder.encodeReference(entry.getPackageBlock(), text);
            if (encodeResult == null) {
                AttributeDataFormat dataFormat = this.getParentArrayType(child);
                encodeResult = ValueCoder.encode(text, dataFormat);
            }
            if (encodeResult != null) {
                if (encodeResult.isError()) {
                    throw new XmlEncodeException("Unexpected array value: " + child.getDebugText());
                }
                ((ValueItem)valueMap).setValue(encodeResult);
                return;
            }
            ((ValueItem)valueMap).setValueAsString(StyleDocument.copyInner(child));
        }

        private void startTag(XmlSerializer serializer, String name) throws IOException {
            XmlDecodeUtil.bagIndent(serializer);
            serializer.startTag(null, name);
        }

        private void endTag(XmlSerializer serializer, String name) throws IOException {
            serializer.endTag(null, name);
        }

        private AttributeDataFormat getParentArrayType(XMLElement child) {
            XMLElement parent = child.getParentElement();
            if (parent == null) {
                return null;
            }
            String name = parent.getName();
            int i = name.indexOf(45);
            if (i < 0) {
                return null;
            }
            name = name.substring(0, i);
            return AttributeDataFormat.fromValueTypeName(name);
        }

        public void encodePlural(XMLElement child, Entry entry) throws IOException {
            AttributeType attributeType = AttributeType.fromName(child.getAttributeValue(XmlCoder.ATTR_quantity));
            if (attributeType == null) {
                throw new XmlEncodeException("Failed to get attribute 'quantity'" + child.getDebugText());
            }
            entry.ensureComplex(true);
            ResValueMapArray mapArray = entry.getResValueMapArray();
            Block valueMap = mapArray.createNext();
            ((ResValueMap)valueMap).setAttributeType(attributeType);
            String text = child.getTextContent();
            EncodeResult encodeResult = ValueCoder.encodeReference(entry.getPackageBlock(), text);
            if (encodeResult == null) {
                encodeResult = ValueCoder.encode(text);
            }
            if (encodeResult != null) {
                if (encodeResult.isError()) {
                    throw new XmlEncodeException(encodeResult.getError() + ": " + child.getDebugText());
                }
                ((ValueItem)valueMap).setValue(encodeResult);
                return;
            }
            ((ValueItem)valueMap).setValueAsString(StyleDocument.copyInner(child));
        }

        public void encodeStyle(XMLElement child, Entry entry) throws IOException {
            entry.ensureComplex(true);
            ResValueMapArray mapArray = entry.getResValueMapArray();
            Block valueMap = mapArray.createNext();
            EncodeResult encodeResult = ((ResValueMap)valueMap).encodeStyle(child);
            if (encodeResult.isError()) {
                throw new XmlEncodeException(encodeResult.getError() + ": " + child.getDebugText());
            }
        }
    }

    public static class ValuesXml {
        private final BagRootAttribute BAG_ROOT_ATTRIBUTE = new BagRootAttribute();
        private final BagChild BAG_CHILD = new BagChild();
        private XmlCoderLogger mLogger;

        public void decodeTable(File resourcesDir, TableBlock tableBlock, Predicate<Entry> decodedEntries) throws IOException {
            this.logMessage("Decoding", "Resource table ...");
            ValuesDirectorySerializer directorySerializer = new ValuesDirectorySerializer(resourcesDir);
            this.decodeTable(directorySerializer, tableBlock, decodedEntries);
            this.logMessage("Decoding", "Finished resource table");
        }

        public void decodeTable(ValuesSerializerFactory serializerFactory, TableBlock tableBlock, Predicate<Entry> decodedEntries) throws IOException {
            for (PackageBlock packageBlock : tableBlock.listPackages()) {
                this.decodePackage(serializerFactory, packageBlock, decodedEntries);
            }
        }

        public void decodePackage(ValuesSerializerFactory serializerFactory, PackageBlock packageBlock, Predicate<Entry> decodedEntries) throws IOException {
            packageBlock.sortTypes();
            Collection<SpecTypePair> specs = packageBlock.listSpecTypePairs();
            for (SpecTypePair specTypePair : specs) {
                Set<ResConfig> configs = specTypePair.listResConfig();
                int size = configs.size();
                int i = 0;
                for (ResConfig resConfig : configs) {
                    TypeBlock typeBlock = specTypePair.getTypeBlock(resConfig);
                    this.logVerbose("Decoding", ++i + "/" + size + " " + packageBlock.getName() + ":" + typeBlock.getTypeName() + resConfig.getQualifiers());
                    XmlSerializer serializer = serializerFactory.createSerializer(typeBlock);
                    int entriesCount = this.decode(serializer, specTypePair, resConfig, decodedEntries);
                    serializerFactory.onFinish(serializer, entriesCount);
                }
            }
        }

        public int decode(XmlSerializer serializer, SpecTypePair specTypePair, ResConfig resConfig, Predicate<Entry> decodedEntries) throws IOException {
            Iterator<ResourceEntry> resources = specTypePair.getResources();
            return this.decode(serializer, resources, resConfig, decodedEntries);
        }

        public int decode(XmlSerializer serializer, Iterator<ResourceEntry> resources, ResConfig resConfig, Predicate<Entry> decodedEntries) throws IOException {
            int entriesCount = 0;
            while (resources.hasNext()) {
                ResourceEntry resourceEntry = resources.next();
                boolean decoded = this.decode(serializer, resourceEntry, resConfig, decodedEntries);
                if (!decoded) continue;
                ++entriesCount;
            }
            return entriesCount;
        }

        public boolean decode(XmlSerializer serializer, ResourceEntry resourceEntry, ResConfig resConfig, Predicate<Entry> decodedEntries) throws IOException {
            Entry entry = resourceEntry.get(resConfig);
            if (entry == null || decodedEntries.test(entry)) {
                return false;
            }
            if (entry.isComplex()) {
                this.decodeBag(serializer, entry);
            } else if (!entry.isNull()) {
                this.decodeScalar(serializer, entry);
            } else {
                return false;
            }
            return true;
        }

        private void decodeBag(XmlSerializer serializer, Entry entry) throws IOException {
            String tag = this.startEntry(serializer, entry);
            this.BAG_ROOT_ATTRIBUTE.decode(serializer, entry);
            int childCount = this.BAG_CHILD.decode(serializer, entry);
            this.endEntry(serializer, tag, childCount != 0);
        }

        private void decodeScalar(XmlSerializer serializer, Entry entry) throws IOException {
            String tag = this.startEntry(serializer, entry);
            if (this.ignoreIdValue(entry)) {
                this.endEntry(serializer, tag);
                return;
            }
            ResValue resValue = entry.getResValue();
            boolean escapeValues = resValue.getValueType() == ValueType.STRING ? !TypeString.isTypeString(entry.getTypeName()) : false;
            resValue.serializeText(serializer, escapeValues);
            this.endEntry(serializer, tag);
        }

        private String startEntry(XmlSerializer serializer, Entry entry) throws IOException {
            String tag = entry.getXmlTag();
            XmlDecodeUtil.entryIndent(serializer);
            serializer.startTag(null, tag);
            serializer.attribute(null, XmlCoder.ATTR_name, entry.getName());
            return tag;
        }

        private void endEntry(XmlSerializer serializer, String tag) throws IOException {
            this.endEntry(serializer, tag, false);
        }

        private void endEntry(XmlSerializer serializer, String tag, boolean indent) throws IOException {
            if (indent) {
                XmlDecodeUtil.entryIndent(serializer);
            }
            serializer.endTag(null, tag);
        }

        private boolean ignoreIdValue(Entry entry) {
            if (!TypeString.isTypeId(entry.getTypeName())) {
                return false;
            }
            ResValue resValue = entry.getResValue();
            ValueType valueType = resValue.getValueType();
            if (valueType == ValueType.BOOLEAN) {
                return true;
            }
            if (valueType == ValueType.STRING) {
                String value = resValue.getValueAsString();
                return value == null || value.length() == 0;
            }
            return false;
        }

        public void encode(File valuesXmlFile, PackageBlock packageBlock) throws IOException, XmlPullParserException {
            XmlPullParser parser = XMLFactory.newPullParser(valuesXmlFile);
            TypeBlock typeBlock = packageBlock.getOrCreateTypeBlock(XmlEncodeUtil.getQualifiersFromValuesXml(valuesXmlFile), XmlEncodeUtil.getTypeFromValuesXml(valuesXmlFile));
            this.encode(parser, typeBlock);
        }

        public void encode(XmlPullParser parser, TypeBlock typeBlock) throws IOException, XmlPullParserException {
            int event = parser.getEventType();
            boolean documentStarted = false;
            if (event == 0) {
                documentStarted = true;
                parser.next();
            }
            if ((event = XMLUtil.ensureStartTag(parser)) != 2) {
                throw new XmlEncodeException("Expecting xml state START_TAG but found: " + XMLUtil.toEventName(parser.getEventType()));
            }
            if (PackageBlock.TAG_resources.equals(parser.getName())) {
                parser.next();
            } else if (documentStarted) {
                throw new XmlEncodeException("Expecting <resources> tag but found: " + parser.getName());
            }
            while (XMLUtil.ensureStartTag(parser) == 2) {
                XMLElement element = XMLElement.parseElement(parser);
                this.encodeEntry(element, typeBlock);
            }
            IOUtil.close(parser);
        }

        public void encodeEntry(XMLElement entryElement, TypeBlock typeBlock) throws IOException {
            Entry entry = typeBlock.getOrCreateDefinedEntry(entryElement.getAttributeValue(XmlCoder.ATTR_name));
            if (entry == null) {
                throw new XmlEncodeException("Undefined entry name: " + entryElement.getDebugText());
            }
            if (this.isBag(entryElement)) {
                this.encodeBag(entryElement, entry);
            } else {
                this.encodeScalar(entryElement, entry);
            }
        }

        public void encodeScalar(XMLElement element, Entry entry) throws IOException {
            entry.ensureComplex(false);
            if (this.isTypeId(element)) {
                this.encodeScalarId(element, entry);
            } else {
                this.encodeScalarAny(element, entry);
            }
            this.checkVisibility(entry);
        }

        public void encodeBag(XMLElement element, Entry entry) throws IOException {
            entry.ensureComplex(true);
            this.BAG_ROOT_ATTRIBUTE.encode(element, entry);
            Iterator<? extends XMLElement> childes = element.getElements();
            while (childes.hasNext()) {
                this.BAG_CHILD.encode(childes.next(), entry);
            }
            this.checkVisibility(entry);
        }

        private boolean isBag(XMLElement element) {
            String tag = element.getName();
            if ("string".equals(tag)) {
                return false;
            }
            if (element.hasChildElements()) {
                return true;
            }
            if (element.hasTextNode()) {
                return false;
            }
            return element.hasAttribute(XmlCoder.ATTR_parent) || element.hasAttribute(XmlCoder.ATTR_formats) || TypeString.isTypeArray(tag);
        }

        private void encodeScalarId(XMLElement element, Entry entry) throws IOException {
            if (!element.hasTextNode()) {
                entry.setValueAsBoolean(false);
            } else {
                this.encodeScalarAny(element, entry);
            }
            ValueHeader header = entry.getHeader();
            header.setPublic(true);
            header.setWeak(true);
        }

        private void encodeScalarAny(XMLElement element, Entry entry) throws IOException {
            ResValue resValue = entry.getResValue();
            if (element.hasChildElements()) {
                resValue.setValueAsString(StyleDocument.copyInner(element));
                return;
            }
            String text = element.getTextContent();
            EncodeResult encodeResult = ValueCoder.encodeReference(entry.getPackageBlock(), text);
            if (encodeResult == null) {
                AttributeDataFormat dataFormat = AttributeDataFormat.fromValueTypeName(element.getAttributeValue(XmlCoder.ATTR_type));
                if (dataFormat == null && (dataFormat = AttributeDataFormat.fromValueTypeName(element.getName())) != AttributeDataFormat.STRING) {
                    dataFormat = null;
                }
                if ((encodeResult = ValueCoder.encode(text, dataFormat)) == null && dataFormat != null && !dataFormat.contains(ValueType.STRING)) {
                    throw new XmlEncodeException("Invalid value: " + element);
                }
            }
            if (encodeResult != null) {
                if (encodeResult.isError()) {
                    throw new XmlEncodeException(encodeResult.getError() + ": " + element.getDebugText());
                }
                resValue.setValue(encodeResult);
            } else {
                resValue.setValueAsString(StyleDocument.copyInner(element));
            }
        }

        private boolean isTypeId(XMLElement element) {
            if (element.hasChildElements()) {
                return false;
            }
            return TypeString.isTypeId(element.getName());
        }

        private void checkVisibility(Entry entry) {
            ValueHeader valueHeader = entry.getHeader();
            if (valueHeader == null) {
                return;
            }
            TypeBlock typeBlock = entry.getTypeBlock();
            if (typeBlock == null) {
                return;
            }
            if (typeBlock.isTypeAttr() || typeBlock.isTypeId()) {
                valueHeader.setPublic(true);
            }
        }

        public void setLogger(XmlCoderLogger logger) {
            this.mLogger = logger;
        }

        public XmlCoderLogger getLogger() {
            return this.mLogger;
        }

        private void logMessage(String tag, String message) {
            XmlCoderLogger logger = this.getLogger();
            if (logger != null) {
                logger.logMessage(tag, message);
            }
        }

        private void logVerbose(String tag, String message) {
            XmlCoderLogger logger = this.getLogger();
            if (logger != null) {
                logger.logMessage(tag, message);
            }
        }
    }
}

