/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.ComplexUnit;
import com.reandroid.arsc.coder.UnitDimension;
import com.reandroid.arsc.coder.UnitFraction;

public class ComplexUtil {
    private static final int COMPLEX_RADIX_SHIFT = 4;
    private static final int COMPLEX_RADIX_MASK = 3;
    private static final int COMPLEX_MANTISSA_SHIFT = 8;
    private static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final int COMPLEX_UNIT_SHIFT = 0;
    private static final int COMPLEX_UNIT_MASK = 15;

    public static String decodeComplex(boolean fraction, int complex_value) {
        int radixFlag = complex_value >> 4 & 3;
        Radix radix = Radix.forFlag(radixFlag);
        int mantissa = complex_value & 0xFFFFFF00;
        float value = (float)mantissa * radix.getMultiplier();
        int unit_flag = complex_value >> 0 & 0xF;
        ComplexUnit unit = fraction ? UnitFraction.valueOf(unit_flag) : UnitDimension.valueOf(unit_flag);
        return radix.formatFloat(fraction, value) + unit;
    }

    public static int encodeComplex(float value, ComplexUnit unit) {
        boolean neg;
        boolean bl = neg = value < 0.0f;
        if (neg) {
            value = -value;
        }
        if (unit.isFraction()) {
            value /= 100.0f;
        }
        long bits = (long)(value * 8388608.0f + 0.5f);
        Radix radix = Radix.getRadix(bits);
        int mantissa = (int)(bits >> radix.getShift() & 0xFFFFFFL);
        if (neg) {
            mantissa = -mantissa & 0xFFFFFF;
        }
        int result = radix.getFlag() << 4 | mantissa << 8;
        return result |= unit.getFlag();
    }

    public static enum Radix {
        RADIX_23p0(0, 23, 0.00390625f),
        RADIX_16p7(1, 16, 3.0517578E-5f),
        RADIX_8p15(2, 8, 1.1920929E-7f),
        RADIX_0p23(3, 0, 4.656613E-10f);

        private final int flag;
        private final int shift;
        private final float multiplier;

        private Radix(int flag, int shift, float multiplier) {
            this.flag = flag;
            this.shift = shift;
            this.multiplier = multiplier;
        }

        public String formatFloat(boolean scale, float value) {
            boolean neg;
            boolean bl = neg = value < 0.0f;
            if (neg) {
                value = -value;
            }
            int multiplier = 1;
            int decimalPlaces = this.flag * 2;
            for (int i = 0; i < decimalPlaces; ++i) {
                multiplier *= 10;
            }
            float f = value * (float)multiplier;
            int i = (int)f;
            if (f - (float)i >= 0.5f) {
                ++i;
            }
            value = (float)i / (float)multiplier;
            if (neg) {
                value = -value;
            }
            if (scale) {
                value *= 100.0f;
            }
            return Float.toString(value);
        }

        public static Radix forFlag(int flag) {
            if (flag == 0) {
                return RADIX_23p0;
            }
            if (flag == 1) {
                return RADIX_16p7;
            }
            if (flag == 2) {
                return RADIX_8p15;
            }
            if (flag == 3) {
                return RADIX_0p23;
            }
            throw new NumberFormatException("Unknown radix flag = " + flag);
        }

        public static Radix getRadix(long bits) {
            if ((bits & 0x7FFFFFL) == 0L) {
                return RADIX_23p0;
            }
            if ((bits & 0xFFFFFFFFFF800000L) == 0L) {
                return RADIX_0p23;
            }
            if ((bits & Integer.MIN_VALUE) == 0L) {
                return RADIX_8p15;
            }
            if ((bits & 0xFFFFFF8000000000L) == 0L) {
                return RADIX_16p7;
            }
            throw new NumberFormatException("Radix bits out of range bits = " + bits);
        }

        public int getFlag() {
            return this.flag;
        }

        public int getShift() {
            return this.shift;
        }

        public float getMultiplier() {
            return this.multiplier;
        }
    }
}

