/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ParserEvent;
import com.reandroid.arsc.chunk.xml.ParserEventList;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlText;
import com.reandroid.arsc.coder.XmlSanitizer;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.json.JSONObject;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlTextNode
extends ResXmlNode {
    private final ResXmlText resXmlText;
    private String mIndentText;
    public static final String NAME_text = "text";

    public ResXmlTextNode(ResXmlText resXmlText) {
        super(1);
        this.resXmlText = resXmlText;
        this.addChild(0, resXmlText);
    }

    public ResXmlTextNode() {
        this(new ResXmlText());
    }

    void makeIndent(int length) {
        if (!this.isIndent()) {
            throw new IllegalArgumentException("Not indent text: '" + this.getText() + "'");
        }
        if (length < 2) {
            this.setText("\n");
            return;
        }
        char[] chars = new char[length];
        chars[0] = 10;
        for (int i = 1; i < length; ++i) {
            chars[i] = 32;
        }
        this.setText(new String(chars));
    }

    public boolean isIndent() {
        return ResXmlTextNode.isIndent(this.getText());
    }

    ResXmlText getResXmlText() {
        return this.resXmlText;
    }

    public int getLineNumber() {
        return this.getResXmlText().getLineNumber();
    }

    @Override
    int autoSetLineNumber(int start) {
        String text = this.getText();
        int lineNumber = start;
        if (ResXmlTextNode.isIndent(text) && this.isNextElement()) {
            ++lineNumber;
        } else {
            char[] chars;
            for (char ch : chars = text.toCharArray()) {
                if (ch != '\n') continue;
                ++start;
            }
        }
        this.setLineNumber(lineNumber);
        return start;
    }

    private boolean isNextElement() {
        ResXmlElement parent = this.getParentResXmlElement();
        if (parent != null) {
            return parent.get(this.getIndex() + 1) instanceof ResXmlElement;
        }
        return false;
    }

    public String getComment() {
        return this.getResXmlText().getComment();
    }

    @Override
    public int getDepth() {
        ResXmlElement parent = this.getParentResXmlElement();
        if (parent != null) {
            return parent.getDepth() + 1;
        }
        return 0;
    }

    @Override
    void addEvents(ParserEventList parserEventList) {
        String comment = this.getComment();
        if (comment != null) {
            parserEventList.add(new ParserEvent(9, this, comment, false));
        }
        parserEventList.add(new ParserEvent(4, this));
    }

    public ResXmlElement getParentResXmlElement() {
        return this.getResXmlText().getParentResXmlElement();
    }

    public void setLineNumber(int lineNumber) {
        this.getResXmlText().setLineNumber(lineNumber);
    }

    public String getText() {
        return this.getResXmlText().getText();
    }

    public void setText(String text) {
        this.getResXmlText().setText(text);
        this.mIndentText = null;
    }

    public void append(String text) {
        String exist = this.getText();
        if (exist == null || exist.length() == 0) {
            exist = this.mIndentText;
        }
        if (exist == null && ResXmlTextNode.isIndent(text)) {
            this.mIndentText = text;
            return;
        }
        if (exist != null) {
            text = exist + text;
        }
        this.setText(text);
    }

    @Override
    public boolean isNull() {
        return this.getResXmlText().isNull();
    }

    @Override
    void onRemoved() {
        this.getResXmlText().onRemoved();
    }

    @Override
    void linkStringReferences() {
        this.getResXmlText().linkStringReferences();
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        if (this.isNull()) {
            return;
        }
        serializer.text(this.getText());
    }

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        String text;
        this.setLineNumber(parser.getLineNumber());
        int event = parser.getEventType();
        if (event == 6) {
            text = ResXmlTextNode.decodeEntityRef(parser.getText());
        } else if (event == 4) {
            text = parser.getText();
            text = XmlSanitizer.unEscapeUnQuote(text);
        } else {
            throw new XmlPullParserException("Invalid text event: " + event + ", " + parser.getPositionDescription());
        }
        this.append(text);
    }

    @Override
    public XMLNode toXml(boolean decode) {
        return new XMLText(this.getText());
    }

    public void mergeWithName(ResourceMergeOption mergeOption, ResXmlTextNode textNode) {
        this.setText(textNode.getText());
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("node_type", NAME_text);
        jsonObject.put(NAME_text, this.getText());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setText(json.optString(NAME_text, null));
        this.setLineNumber(this.getParentResXmlElement().getStartLineNumber());
    }

    public XMLText decodeToXml() {
        XMLText xmlText = new XMLText(XmlSanitizer.escapeSpecialCharacter(this.getText()));
        xmlText.setLineNumber(this.getLineNumber());
        return xmlText;
    }

    public String toString() {
        return "line = " + this.getLineNumber() + ", \"" + this.getText() + "\"";
    }

    private static String decodeEntityRef(String entityRef) {
        if (entityRef == null) {
            return "";
        }
        String decode = entityRef.equals("lt") ? "<" : (entityRef.equals("gt") ? ">" : (entityRef.equals("amp") ? "&" : (entityRef.equals("quote") ? "\"" : "&" + entityRef + ";")));
        return decode;
    }

    static boolean isTextEvent(int event) {
        return event == 4 || event == 6;
    }

    private static boolean isIndent(String text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        char[] chars = text.toCharArray();
        if (chars[0] != '\n') {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] == ' ') continue;
            return false;
        }
        return true;
    }
}

