/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.array.ResXmlAttributeArray;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.BaseXmlChunk;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.XmlNodeHeader;
import com.reandroid.arsc.item.ShortItem;
import java.util.Collection;
import java.util.Iterator;

public class ResXmlStartElement
extends BaseXmlChunk {
    private final ShortItem mAttributeStart = new ShortItem(20);
    private final ShortItem mAttributeUnitSize = new ShortItem(20);
    private final ShortItem mAttributeCount = new ShortItem();
    private final ShortItem mIdAttributePosition = new ShortItem();
    private final ShortItem mClassAttributePosition = new ShortItem();
    private final ShortItem mStyleAttributePosition = new ShortItem();
    private final ResXmlAttributeArray mAttributeArray = new ResXmlAttributeArray((HeaderBlock)this.getHeaderBlock(), this.mAttributeStart, this.mAttributeCount, this.mAttributeUnitSize);
    private ResXmlEndElement mResXmlEndElement;
    private static final short ATTRIBUTES_UNIT_SIZE = 20;
    private static final short ATTRIBUTES_DEFAULT_START = 20;
    private static final String ATTRIBUTE_NAME_CLASS = "class";
    private static final String ATTRIBUTE_NAME_STYLE = "style";
    private static final int ATTRIBUTE_RESOURCE_ID_id = 0x10100D0;

    public ResXmlStartElement() {
        super(ChunkType.XML_START_ELEMENT, 7);
        this.addChild(this.mAttributeStart);
        this.addChild(this.mAttributeUnitSize);
        this.addChild(this.mAttributeCount);
        this.addChild(this.mIdAttributePosition);
        this.addChild(this.mClassAttributePosition);
        this.addChild(this.mStyleAttributePosition);
        this.addChild(this.mAttributeArray);
    }

    public int removeUndefinedAttributes() {
        return this.getResXmlAttributeArray().removeUndefinedAttributes();
    }

    public ResXmlAttribute getIdAttribute() {
        return (ResXmlAttribute)this.getResXmlAttributeArray().get(this.mIdAttributePosition.unsignedInt() - 1);
    }

    public ResXmlAttribute getClassAttribute() {
        return (ResXmlAttribute)this.getResXmlAttributeArray().get(this.mClassAttributePosition.unsignedInt() - 1);
    }

    public ResXmlAttribute getStyleAttribute() {
        return (ResXmlAttribute)this.getResXmlAttributeArray().get(this.mStyleAttributePosition.unsignedInt() - 1);
    }

    void setAttributesUnitSize(int size) {
        this.mAttributeArray.setAttributesUnitSize(size);
    }

    public ResXmlAttribute newAttribute() {
        ResXmlAttributeArray attributeArray = this.getResXmlAttributeArray();
        return (ResXmlAttribute)attributeArray.createNext();
    }

    @Override
    void linkStringReferences() {
        super.linkStringReferences();
        ResXmlEndElement end = this.getResXmlEndElement();
        if (end != null) {
            end.linkStringReferences();
        }
        this.linkNamespace();
    }

    @Override
    void onRemoved() {
        super.onRemoved();
        this.unlinkNamespace();
        ResXmlEndElement end = this.getResXmlEndElement();
        if (end != null) {
            end.onRemoved();
        }
        Iterator<ResXmlAttribute> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().onRemoved();
        }
    }

    @Override
    protected void onPreRefresh() {
        this.sortAttributes();
    }

    void unlinkNamespace() {
        ResXmlStartNamespace namespace = this.getResXmlStartNamespace();
        if (namespace != null) {
            namespace.removeElementReference(this);
        }
    }

    void linkNamespace() {
        ResXmlStartNamespace namespace = this.getResXmlStartNamespace();
        if (namespace != null) {
            namespace.addElementReference(this);
        }
    }

    private void sortAttributes() {
        ResXmlAttributeArray array = this.getResXmlAttributeArray();
        ResXmlAttribute idAttribute = (ResXmlAttribute)array.get(this.mIdAttributePosition.get() - 1);
        ResXmlAttribute classAttribute = (ResXmlAttribute)array.get(this.mClassAttributePosition.get() - 1);
        ResXmlAttribute styleAttribute = (ResXmlAttribute)array.get(this.mStyleAttributePosition.get() - 1);
        array.sortAttributes();
        if (idAttribute != null) {
            this.mIdAttributePosition.set(idAttribute.getIndex() + 1);
        }
        if (classAttribute != null) {
            this.mClassAttributePosition.set(classAttribute.getIndex() + 1);
            if (!ATTRIBUTE_NAME_CLASS.equals(classAttribute.getName())) {
                classAttribute.setName(ATTRIBUTE_NAME_CLASS, 0);
            }
        }
        if (styleAttribute != null) {
            this.mStyleAttributePosition.set(styleAttribute.getIndex() + 1);
            if (!ATTRIBUTE_NAME_STYLE.equals(styleAttribute.getName())) {
                styleAttribute.setName(ATTRIBUTE_NAME_STYLE, 0);
            }
        }
    }

    void calculatePositions() {
        ResXmlAttribute idAttribute = this.getAttribute(0x10100D0);
        ResXmlAttribute classAttribute = this.getNoIdAttribute(ATTRIBUTE_NAME_CLASS);
        ResXmlAttribute styleAttribute = this.getNoIdAttribute(ATTRIBUTE_NAME_STYLE);
        if (idAttribute != null) {
            this.mIdAttributePosition.set(idAttribute.getIndex() + 1);
        }
        if (classAttribute != null) {
            this.mClassAttributePosition.set(classAttribute.getIndex() + 1);
        }
        if (styleAttribute != null) {
            this.mStyleAttributePosition.set(styleAttribute.getIndex() + 1);
        }
    }

    public ResXmlAttribute getAttribute(int resourceId) {
        Iterator<ResXmlAttribute> iterator = this.iterator();
        while (iterator.hasNext()) {
            ResXmlAttribute attribute = iterator.next();
            if (resourceId != attribute.getNameId()) continue;
            return attribute;
        }
        return null;
    }

    private ResXmlAttribute getNoIdAttribute(String name) {
        Iterator<ResXmlAttribute> iterator = this.iterator();
        while (iterator.hasNext()) {
            ResXmlAttribute attribute = iterator.next();
            if (attribute.getNameId() != 0 || !name.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public ResXmlAttribute getAttribute(String uri, String name) {
        if (name == null) {
            return null;
        }
        Iterator<ResXmlAttribute> iterator = this.iterator();
        while (iterator.hasNext()) {
            ResXmlAttribute attribute = iterator.next();
            if (!attribute.equalsName(name)) continue;
            if (uri != null) {
                if (!uri.equals(attribute.getUri())) continue;
                return attribute;
            }
            return attribute;
        }
        return null;
    }

    public ResXmlAttribute searchAttributeByName(String name) {
        if (name == null) {
            return null;
        }
        Iterator iterator = this.getResXmlAttributeArray().iterator();
        ResXmlAttribute withIdAttribute = null;
        while (iterator.hasNext()) {
            ResXmlAttribute attribute = (ResXmlAttribute)iterator.next();
            if (!attribute.equalsName(name)) continue;
            if (attribute.getNameId() != 0) {
                withIdAttribute = attribute;
                continue;
            }
            return attribute;
        }
        return withIdAttribute;
    }

    public ResXmlAttribute searchAttributeByResourceId(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        Iterator<ResXmlAttribute> iterator = this.iterator();
        while (iterator.hasNext()) {
            ResXmlAttribute attribute = iterator.next();
            if (resourceId != attribute.getNameId()) continue;
            return attribute;
        }
        return null;
    }

    public String getTagName() {
        return this.getTagName(true);
    }

    public String getTagName(boolean includePrefix) {
        String prefix;
        String name = this.getName();
        if (includePrefix && (prefix = this.getPrefix()) != null) {
            name = prefix + ":" + name;
        }
        return name;
    }

    public String getName(boolean includePrefix) {
        String prefix;
        String name = super.getName();
        if (includePrefix && (prefix = this.getPrefix()) != null) {
            name = prefix + ":" + name;
        }
        return name;
    }

    public void setName(String name) {
        if (name == null) {
            this.setStringReference(-1);
        } else {
            this.setString(name);
        }
        ResXmlEndElement endElement = this.getResXmlEndElement();
        if (endElement != null) {
            endElement.setString(name);
        }
    }

    public Collection<ResXmlAttribute> listResXmlAttributes() {
        return this.getResXmlAttributeArray().listItems();
    }

    public Iterator<ResXmlAttribute> iterator() {
        return this.getResXmlAttributeArray().iterator();
    }

    public ResXmlAttributeArray getResXmlAttributeArray() {
        return this.mAttributeArray;
    }

    @Override
    public String getUri() {
        ResXmlStartNamespace startNamespace = this.getResXmlStartNamespace();
        if (startNamespace != null) {
            return startNamespace.getUri();
        }
        return null;
    }

    public String getPrefix() {
        ResXmlStartNamespace startNamespace = this.getResXmlStartNamespace();
        if (startNamespace != null) {
            return startNamespace.getPrefix();
        }
        return null;
    }

    public void setTagNamespace(String uri, String prefix) {
        this.unlinkNamespace();
        if (uri == null || prefix == null) {
            this.setNamespaceReference(-1);
            return;
        }
        ResXmlElement parentElement = this.getParentResXmlElement();
        if (parentElement == null) {
            return;
        }
        ResXmlNamespace ns = parentElement.getOrCreateNamespace(uri, prefix);
        this.setNamespaceReference(ns.getUriReference());
        this.linkNamespace();
    }

    ResXmlStartNamespace getResXmlStartNamespace() {
        int uriRef = this.getNamespaceReference();
        if (uriRef < 0) {
            return null;
        }
        ResXmlElement parentElement = this.getParentResXmlElement();
        if (parentElement != null) {
            return parentElement.getStartNamespaceByUriRef(uriRef);
        }
        return null;
    }

    public void setResXmlEndElement(ResXmlEndElement element) {
        this.mResXmlEndElement = element;
    }

    public ResXmlEndElement getResXmlEndElement() {
        return this.mResXmlEndElement;
    }

    @Override
    protected void onChunkRefreshed() {
        this.refreshAttributeStart();
        this.refreshAttributeCount();
    }

    private void refreshAttributeStart() {
        int start = this.countUpTo(this.mAttributeArray);
        this.mAttributeStart.set(start -= ((XmlNodeHeader)this.getHeaderBlock()).getHeaderSize());
    }

    private void refreshAttributeCount() {
        int count = this.mAttributeArray.size();
        this.mAttributeCount.set(count);
    }

    @Override
    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        ResXmlEndElement endElement = this.getResXmlEndElement();
        if (endElement != null) {
            endElement.setLineNumber(lineNumber);
        }
    }

    @Override
    public String toString() {
        String txt = this.getTagName();
        if (txt == null) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(txt);
        ResXmlAttribute[] allAttr = (ResXmlAttribute[])this.mAttributeArray.getChildes();
        if (allAttr != null) {
            for (int i = 0; i < allAttr.length && i <= 10; ++i) {
                builder.append(" ");
                builder.append(allAttr[i].toString());
            }
        }
        return builder.toString();
    }
}

