/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.FilterIterator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public interface ResXmlNodeTree
extends Iterable<ResXmlNode>,
JSONConvert<JSONObject> {
    public BlockList<ResXmlNode> getNodeListBlockInternal();

    @Override
    default public Iterator<ResXmlNode> iterator() {
        return this.getNodeListBlockInternal().clonedIterator();
    }

    default public ResXmlNode get(int i) {
        return this.getNodeListBlockInternal().get(i);
    }

    default public int size() {
        return this.getNodeListBlockInternal().size();
    }

    default public void add(ResXmlNode resXmlNode) {
        if (resXmlNode == null || resXmlNode == this) {
            return;
        }
        BlockList<ResXmlNode> blockList = this.getNodeListBlockInternal();
        if (!blockList.containsExact(resXmlNode)) {
            blockList.add(resXmlNode);
        }
    }

    default public void add(int index, ResXmlNode resXmlNode) {
        if (resXmlNode == null || resXmlNode == this) {
            return;
        }
        BlockList<ResXmlNode> blockList = this.getNodeListBlockInternal();
        if (!blockList.containsExact(resXmlNode)) {
            blockList.add(index, resXmlNode);
        }
    }

    default public int removeIf(Predicate<? super ResXmlNode> predicate) {
        return this.getNodeListBlockInternal().remove(predicate);
    }

    default public boolean remove(ResXmlNode xmlNode) {
        if (xmlNode != null && xmlNode.getParent() != null) {
            xmlNode.onRemoved();
        }
        return this.getNodeListBlockInternal().remove(xmlNode);
    }

    default public void clear() {
        for (ResXmlNode xmlNode : this) {
            if (xmlNode.getParent() == null) continue;
            xmlNode.onRemoved();
        }
        this.getNodeListBlockInternal().clearChildes();
    }

    default public Iterator<ResXmlNode> iterator(Predicate<? super ResXmlNode> predicate) {
        return this.getNodeListBlockInternal().iterator(predicate);
    }

    default public <T1 extends ResXmlNode> Iterator<T1> iterator(Class<T1> instance) {
        return this.getNodeListBlockInternal().iterator(instance);
    }

    default public Iterator<ResXmlElement> getElements() {
        return this.iterator(ResXmlElement.class);
    }

    default public Iterator<ResXmlElement> getElements(Predicate<? super ResXmlElement> filter) {
        return FilterIterator.of(this.getElements(), filter);
    }

    default public Iterator<ResXmlElement> getElements(String name) {
        return this.getElements((? super ResXmlElement element) -> element.equalsName(name));
    }

    default public ResXmlElement getElement(String name) {
        return CollectionUtil.getFirst(this.getElements(name));
    }

    default public List<ResXmlElement> listElements() {
        return CollectionUtil.toList(this.getElements());
    }

    default public List<ResXmlElement> listElements(String name) {
        return CollectionUtil.toList(this.getElements(name));
    }
}

