/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.array.ResXmlAttributeArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ParserEvent;
import com.reandroid.arsc.chunk.xml.ParserEventList;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeTree;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlTextNode;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.model.ResourceLibrary;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.common.Namespace;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.RecursiveIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlElement
extends ResXmlNode
implements ResXmlNodeTree,
JSONConvert<JSONObject>,
Comparator<ResXmlNode> {
    private final BlockList<ResXmlStartNamespace> mStartNamespaceList = new BlockList();
    private final SingleBlockContainer<ResXmlStartElement> mStartElementContainer = new SingleBlockContainer();
    private final BlockList<ResXmlNode> mBody = new BlockList();
    private final SingleBlockContainer<ResXmlEndElement> mEndElementContainer = new SingleBlockContainer();
    private final BlockList<ResXmlEndNamespace> mEndNamespaceList = new BlockList();
    public static final String NAME_element = ObjectsUtil.of("element");
    public static final String NAME_name = ObjectsUtil.of("name");
    public static final String NAME_comment = ObjectsUtil.of("comment");
    public static final String NAME_text = ObjectsUtil.of("text");
    public static final String NAME_namespaces = ObjectsUtil.of("namespaces");
    public static final String NAME_namespace_uri = ObjectsUtil.of("namespace_uri");
    public static final String NAME_namespace_prefix = ObjectsUtil.of("namespace_prefix");
    public static final String NAME_line = ObjectsUtil.of("line");
    public static final String NAME_line_end = ObjectsUtil.of("line_end");
    public static final String NAME_attributes = ObjectsUtil.of("attributes");
    public static final String NAME_childes = ObjectsUtil.of("childes");
    private static final String FEATURE_INDENT_OUTPUT = "http://xmlpull.org/v1/doc/features.html#indent-output";
    private static final int MAX_INDENT_DEPTH = 25;

    public ResXmlElement() {
        super(5);
        this.addChild(0, this.mStartNamespaceList);
        this.addChild(1, this.mStartElementContainer);
        this.addChild(2, this.mBody);
        this.addChild(3, this.mEndElementContainer);
        this.addChild(4, this.mEndNamespaceList);
    }

    @Override
    public BlockList<ResXmlNode> getNodeListBlockInternal() {
        return this.mBody;
    }

    public boolean isUndefined() {
        return this.size() == 0 && this.getAttributeCount() == 0 && this.getNamespaceCount() == 0 && StringsUtil.isEmpty(this.getName());
    }

    public ResXmlElement getParentElement() {
        return this.getParentInstance(ResXmlElement.class);
    }

    public ResXmlDocument getParentDocument() {
        return this.getParentInstance(ResXmlDocument.class);
    }

    public ResXmlElement getRootElement() {
        ResXmlElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getRootElement();
        }
        return this;
    }

    public ResXmlNamespace getNamespace() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getResXmlStartNamespace();
        }
        return null;
    }

    public void addIndent(int scale) {
        if (this.hasText()) {
            return;
        }
        int depth = this.getDepth();
        if (depth > 25) {
            depth = 25;
        }
        int indent = (depth + 1) * scale;
        ResXmlTextNode textNode = null;
        for (ResXmlElement element : this.listElements()) {
            textNode = this.createResXmlTextNode(element.getIndex());
            textNode.makeIndent(indent);
            element.addIndent(scale);
        }
        if (textNode != null) {
            indent = depth * scale;
            textNode = new ResXmlTextNode();
            this.addNode(textNode);
            textNode.makeIndent(indent);
        }
    }

    public int clearIndents() {
        return this.removeIf(resXmlNode -> {
            if (resXmlNode instanceof ResXmlTextNode) {
                return ((ResXmlTextNode)resXmlNode).isIndent();
            }
            return false;
        });
    }

    public Iterator<ResXmlNode> recursiveXmlNodes() throws ConcurrentModificationException {
        return CombiningIterator.of(SingleIterator.of(this), ComputeIterator.of(this.iterator(), xmlNode -> {
            if (xmlNode instanceof ResXmlElement) {
                return ((ResXmlElement)xmlNode).recursiveXmlNodes();
            }
            return SingleIterator.of(xmlNode);
        }));
    }

    public Iterator<ResXmlAttribute> recursiveAttributes() throws ConcurrentModificationException {
        return RecursiveIterator.compute(this, ResXmlNodeTree::getElements, ResXmlElement::getAttributes);
    }

    public Iterator<ResXmlElement> recursiveElements() {
        return RecursiveIterator.of(this, ResXmlNodeTree::getElements);
    }

    public ResXmlAttribute getIdAttribute() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getIdAttribute();
        }
        return null;
    }

    public ResXmlAttribute getClassAttribute() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getClassAttribute();
        }
        return null;
    }

    public ResXmlAttribute getStyleAttribute() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getStyleAttribute();
        }
        return null;
    }

    public ResXmlNamespace getNamespaceAt(int i) {
        return this.mStartNamespaceList.get(i);
    }

    public int getNamespaceCount() {
        return this.mStartNamespaceList.size();
    }

    public ResXmlNamespace getNamespace(String uri, String prefix) {
        return this.getXmlStartNamespace(uri, prefix);
    }

    public ResXmlNamespace getOrCreateNamespace(String uri, String prefix) {
        return this.getOrCreateXmlStartNamespace(uri, prefix);
    }

    public ResXmlNamespace newNamespace(String uri, String prefix) {
        return this.createXmlStartNamespace(uri, prefix);
    }

    public ResXmlNamespace getNamespaceByUri(String uri) {
        return this.getStartNamespaceByUri(uri);
    }

    public ResXmlNamespace getNamespaceByPrefix(String prefix) {
        return this.getStartNamespaceByPrefix(prefix, null);
    }

    public ResXmlNamespace getOrCreateNamespaceByPrefix(String prefix) {
        if (prefix == null || prefix.trim().length() == 0) {
            return null;
        }
        ResXmlNamespace namespace = this.getNamespaceByPrefix(prefix);
        if (namespace != null) {
            return namespace;
        }
        String uri = ResourceLibrary.PREFIX_ANDROID.equals(prefix) ? ResourceLibrary.URI_ANDROID : ResourceLibrary.URI_RES_AUTO;
        return this.getOrCreateNamespace(uri, prefix);
    }

    public int autoSetAttributeNamespaces() {
        return this.autoSetAttributeNamespaces(true);
    }

    public int autoSetAttributeNamespaces(boolean removeNoIdPrefix) {
        int changedCount = 0;
        for (ResXmlAttribute attribute : this.listAttributes()) {
            boolean changed = attribute.autoSetNamespace(removeNoIdPrefix);
            if (!changed) continue;
            ++changedCount;
        }
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            changedCount += iterator.next().autoSetAttributeNamespaces(removeNoIdPrefix);
        }
        if (removeNoIdPrefix && this.fixEmptyNamespaces()) {
            ++changedCount;
        }
        return changedCount;
    }

    public boolean fixEmptyNamespaces() {
        boolean changed = false;
        for (ResXmlStartNamespace ns : this.getStartNamespaceList()) {
            if (!ns.fixEmpty()) continue;
            changed = true;
        }
        return changed;
    }

    public int autoSetAttributeNames() {
        return this.autoSetAttributeNames(true);
    }

    public int autoSetAttributeNames(boolean removeNoIdPrefix) {
        int changedCount = 0;
        for (ResXmlAttribute attribute : this.listAttributes()) {
            boolean changed = attribute.autoSetName(removeNoIdPrefix);
            if (!changed) continue;
            ++changedCount;
        }
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            changedCount += iterator.next().autoSetAttributeNames(removeNoIdPrefix);
        }
        return changedCount;
    }

    @Override
    int autoSetLineNumber(int start) {
        this.setLineNumber(++start);
        int attrCount = this.getAttributeCount();
        if (attrCount != 0) {
            start += attrCount - 1;
        }
        boolean haveElement = false;
        for (ResXmlNode xmlNode : this) {
            start = xmlNode.autoSetLineNumber(start);
            if (haveElement || !(xmlNode instanceof ResXmlElement)) continue;
            haveElement = true;
        }
        if (haveElement) {
            ++start;
        }
        return start;
    }

    public void clearNullNodes() {
        this.clearNullNodes(true);
    }

    private void clearNullNodes(boolean recursive) {
        for (ResXmlNode node : this.listXmlNodes()) {
            if (node.isNull()) {
                this.remove(node);
            }
            if (!recursive || !(node instanceof ResXmlElement)) continue;
            ((ResXmlElement)node).clearNullNodes(true);
        }
    }

    int removeUnusedNamespaces() {
        int count = 0;
        ArrayList<ResXmlStartNamespace> nsList = new ArrayList<ResXmlStartNamespace>(this.getStartNamespaceList());
        for (ResXmlStartNamespace ns : nsList) {
            boolean removed = ns.removeIfNoReference();
            if (!removed) continue;
            ++count;
        }
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            count += iterator.next().removeUnusedNamespaces();
        }
        return count;
    }

    public int removeUndefinedAttributes() {
        int count = 0;
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            count += start.removeUndefinedAttributes();
        }
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            count += iterator.next().removeUndefinedAttributes();
        }
        return count;
    }

    @Deprecated
    public int remove(Predicate<? super ResXmlNode> predicate) {
        return this.removeIf(predicate);
    }

    public void changeIndex(ResXmlElement element, int index) {
        this.getNodeListBlockInternal().moveTo(element, index);
    }

    public int indexOf(String tagName) {
        ResXmlElement element = this.getElement(tagName);
        if (element != null) {
            return element.getIndex();
        }
        return -1;
    }

    public int lastIndexOf(String tagName) {
        return this.lastIndexOf(tagName, -1);
    }

    public int lastIndexOf(String tagName, int def) {
        ResXmlElement last = CollectionUtil.getLast(this.getElements(tagName));
        if (last != null) {
            def = this.indexOf(last, def);
        }
        return def;
    }

    public int indexOf(ResXmlElement element) {
        return this.indexOf(element, -1);
    }

    public int indexOf(ResXmlNode resXmlNode, int def) {
        int index = 0;
        for (ResXmlNode xmlNode : this.mBody.getChildes()) {
            if (xmlNode == resXmlNode) {
                return index;
            }
            ++index;
        }
        return def;
    }

    public void setAttributesUnitSize(int size, boolean setToAll) {
        ResXmlStartElement startElement = this.getStartElement();
        startElement.setAttributesUnitSize(size);
        if (setToAll) {
            for (ResXmlElement child : this.listElements()) {
                child.setAttributesUnitSize(size, setToAll);
            }
        }
    }

    public String getStartComment() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            return start.getComment();
        }
        return null;
    }

    String getEndComment() {
        ResXmlEndElement end = this.getEndElement();
        if (end != null) {
            return end.getComment();
        }
        return null;
    }

    public int getLineNumber() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            return start.getLineNumber();
        }
        return 0;
    }

    public void setLineNumber(int lineNumber) {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.setLineNumber(lineNumber);
            start.getResXmlEndElement().setLineNumber(lineNumber);
        }
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            this.getNamespaceAt(i).setLineNumber(lineNumber);
        }
    }

    public int getStartLineNumber() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            return start.getLineNumber();
        }
        return 0;
    }

    public int getEndLineNumber() {
        ResXmlEndElement end = this.getEndElement();
        if (end != null) {
            return end.getLineNumber();
        }
        return 0;
    }

    public void setStartLineNumber(int lineNumber) {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.setLineNumber(lineNumber);
        }
    }

    public void setEndLineNumber(int lineNumber) {
        ResXmlEndElement end = this.getEndElement();
        if (end != null) {
            end.setLineNumber(lineNumber);
        }
    }

    public void setComment(String comment) {
        this.getStartElement().setComment(comment);
    }

    public void calculateAttributesOrder() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.calculatePositions();
        }
    }

    public ResXmlAttribute newAttribute() {
        return this.getStartElement().newAttribute();
    }

    @Override
    void onRemoved() {
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.onRemoved();
        }
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.onRemoved();
        }
        for (ResXmlNode xmlNode : this.listXmlNodes()) {
            xmlNode.onRemoved();
        }
    }

    @Override
    void linkStringReferences() {
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.linkStringReferences();
        }
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.linkStringReferences();
        }
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            iterator.next().linkStringReferences();
        }
    }

    public ResXmlElement createChildElement() {
        return this.createChildElement(-1, null);
    }

    public ResXmlElement createChildElement(int position) {
        return this.createChildElement(position, null);
    }

    public ResXmlElement createChildElement(String name) {
        return this.createChildElement(-1, name);
    }

    public ResXmlElement createChildElement(int position, String name) {
        int lineNo = this.getStartElement().getLineNumber() + 1;
        ResXmlElement resXmlElement = new ResXmlElement();
        resXmlElement.newStartElement(lineNo);
        if (position >= 0) {
            this.addNode(position, resXmlElement);
        } else {
            this.addNode(resXmlElement);
        }
        if (name != null) {
            resXmlElement.setName(name);
        }
        return resXmlElement;
    }

    public ResXmlTextNode createResXmlTextNode() {
        return this.createResXmlTextNode(-1, null);
    }

    public ResXmlTextNode createResXmlTextNode(int position) {
        return this.createResXmlTextNode(position, null);
    }

    public ResXmlTextNode createResXmlTextNode(String text) {
        return this.createResXmlTextNode(-1, text);
    }

    public ResXmlTextNode createResXmlTextNode(int position, String text) {
        ResXmlTextNode xmlTextNode = new ResXmlTextNode();
        if (position >= 0) {
            this.addNode(position, xmlTextNode);
        } else {
            this.addNode(xmlTextNode);
        }
        if (text != null) {
            xmlTextNode.setText(text);
        }
        return xmlTextNode;
    }

    public void addResXmlText(String text) {
        if (text == null) {
            return;
        }
        this.createResXmlTextNode(text);
    }

    public ResXmlAttribute getOrCreateAndroidAttribute(String name, int resourceId) {
        return this.getOrCreateAttribute(ResourceLibrary.URI_ANDROID, ResourceLibrary.PREFIX_ANDROID, name, resourceId);
    }

    public ResXmlAttribute getOrCreateAttribute(String uri, String prefix, String name, int resourceId) {
        ResXmlAttribute attribute = this.searchAttribute(name, resourceId);
        if (attribute == null) {
            attribute = this.createAttribute(name, resourceId);
            attribute.setNamespace(uri, prefix);
        }
        return attribute;
    }

    public ResXmlAttribute getOrCreateAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = this.searchAttribute(name, resourceId);
        if (attribute == null) {
            attribute = this.createAttribute(name, resourceId);
        }
        return attribute;
    }

    public ResXmlAttribute createAndroidAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = this.createAttribute(name, resourceId);
        ResXmlStartNamespace ns = this.getOrCreateXmlStartNamespace(ResourceLibrary.URI_ANDROID, ResourceLibrary.PREFIX_ANDROID);
        attribute.setNamespaceReference(ns.getUriReference());
        return attribute;
    }

    public ResXmlAttribute createAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = new ResXmlAttribute();
        this.addAttribute(attribute);
        attribute.setName(name, resourceId);
        return attribute;
    }

    public void addAttribute(ResXmlAttribute attribute) {
        this.getStartElement().getResXmlAttributeArray().add(attribute);
    }

    private ResXmlAttribute searchAttribute(String name, int resourceId) {
        if (resourceId == 0) {
            return this.searchAttributeByName(name);
        }
        return this.searchAttributeByResourceId(resourceId);
    }

    public ResXmlAttribute searchAttributeByName(String name) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.searchAttributeByName(name);
        }
        return null;
    }

    public ResXmlAttribute searchAttributeByResourceId(int resourceId) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.searchAttributeByResourceId(resourceId);
        }
        return null;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean includePrefix) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getTagName(includePrefix);
        }
        return null;
    }

    public void setName(String uri, String prefix, String name) {
        this.setName(name);
        this.setNamespace(uri, prefix);
    }

    public void setName(String name) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        this.ensureStartEndElement();
        ResXmlStartElement startElement = this.getStartElement();
        if (name == null) {
            startElement.setName(null);
            return;
        }
        String prefix = null;
        int i = name.lastIndexOf(58);
        if (i >= 0) {
            prefix = name.substring(0, i);
            name = name.substring(++i);
        }
        startElement.setName(name);
        if (prefix == null) {
            return;
        }
        ResXmlNamespace namespace = this.getOrCreateNamespaceByPrefix(prefix);
        if (namespace != null) {
            startElement.setNamespaceReference(namespace.getUriReference());
        }
    }

    public boolean equalsName(String name) {
        if (name == null) {
            return this.getName() == null;
        }
        name = XMLUtil.splitName(name);
        return name.equals(this.getName(false));
    }

    public String getUri() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getUri();
        }
        return null;
    }

    public String getPrefix() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getPrefix();
        }
        return null;
    }

    @Deprecated
    public void setTag(String tag) {
        this.setName(tag);
    }

    @Deprecated
    public String getTagName() {
        return this.getName(true);
    }

    @Deprecated
    public String getTag() {
        return this.getName();
    }

    @Deprecated
    public String getTagUri() {
        return this.getUri();
    }

    @Deprecated
    public String getTagPrefix() {
        return this.getPrefix();
    }

    @Deprecated
    public ResXmlNamespace getTagNamespace() {
        return this.getNamespace();
    }

    @Deprecated
    public void setTagNamespace(Namespace namespace) {
        this.setNamespace(namespace);
    }

    public void setNamespace(Namespace namespace) {
        if (namespace != null) {
            this.setNamespace(namespace.getUri(), namespace.getPrefix());
        } else {
            this.setNamespace(null, null);
        }
    }

    @Deprecated
    public void setTagNamespace(String uri, String prefix) {
        this.setNamespace(uri, prefix);
    }

    public void setNamespace(String uri, String prefix) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            startElement.setTagNamespace(uri, prefix);
        }
    }

    public int removeAttributesWithId(int resourceId) {
        return this.removeAttributes(this.getAttributesWithId(resourceId));
    }

    public int removeAttributesWithName(String name) {
        return this.removeAttributes(this.getAttributesWithName(name));
    }

    public int removeAttributes(Predicate<? super ResXmlAttribute> predicate) {
        return this.removeAttributes(this.getAttributes(predicate));
    }

    public int removeAttributes(Iterator<? extends ResXmlAttribute> attributes) {
        Iterator<? extends ResXmlAttribute> iterator = CollectionUtil.copyOf(attributes);
        int count = 0;
        while (iterator.hasNext()) {
            boolean removed = this.removeAttribute(iterator.next());
            if (!removed) continue;
            ++count;
        }
        return count;
    }

    public Iterator<ResXmlAttribute> getAttributes() {
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null) {
            if (attributeArray.size() == 0) {
                return EmptyIterator.of();
            }
            return attributeArray.iterator();
        }
        return EmptyIterator.of();
    }

    public Iterator<ResXmlAttribute> getAttributes(Predicate<? super ResXmlAttribute> filter) {
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null) {
            if (attributeArray.size() == 0) {
                return EmptyIterator.of();
            }
            return attributeArray.iterator(filter);
        }
        return EmptyIterator.of();
    }

    public Iterator<ResXmlAttribute> getAttributesWithId(int resourceId) {
        return this.getAttributes(attribute -> attribute.getNameId() == resourceId);
    }

    public Iterator<ResXmlAttribute> getAttributesWithName(String name) {
        return this.getAttributes(attribute -> attribute.getNameId() == 0 && attribute.equalsName(name));
    }

    public int getAttributeCount() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getResXmlAttributeArray().size();
        }
        return 0;
    }

    public ResXmlAttribute getAttributeAt(int index) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return (ResXmlAttribute)startElement.getResXmlAttributeArray().get(index);
        }
        return null;
    }

    public Collection<ResXmlAttribute> listAttributes() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.listResXmlAttributes();
        }
        return new ArrayList<ResXmlAttribute>();
    }

    public ResXmlStringPool getStringPool() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ResXmlDocument) {
                return ((ResXmlDocument)parent).getStringPool();
            }
            if (!(parent instanceof ResXmlElement)) continue;
            return ((ResXmlElement)parent).getStringPool();
        }
        return null;
    }

    public ResXmlIDMap getResXmlIDMap() {
        ResXmlDocument resXmlDocument = this.getParentDocument();
        if (resXmlDocument != null) {
            return resXmlDocument.getResXmlIDMap();
        }
        return null;
    }

    @Override
    public int getDepth() {
        ResXmlElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getDepth() + 1;
        }
        return 0;
    }

    @Override
    void addEvents(ParserEventList parserEventList) {
        String comment = this.getStartComment();
        if (comment != null) {
            parserEventList.add(new ParserEvent(9, this, comment, false));
        }
        parserEventList.add(new ParserEvent(2, this));
        for (ResXmlNode xmlNode : this) {
            xmlNode.addEvents(parserEventList);
        }
        comment = this.getEndComment();
        if (comment != null) {
            parserEventList.add(new ParserEvent(9, this, comment, true));
        }
        parserEventList.add(new ParserEvent(3, this));
    }

    public void addElement(ResXmlElement element) {
        this.addNode(element);
    }

    public boolean removeAttribute(ResXmlAttribute resXmlAttribute) {
        if (resXmlAttribute != null) {
            resXmlAttribute.onRemoved();
        }
        return this.getStartElement().getResXmlAttributeArray().remove(resXmlAttribute);
    }

    public boolean removeSelf() {
        ResXmlElement parent = this.getParentElement();
        if (parent != null) {
            return parent.remove(this);
        }
        return false;
    }

    @Deprecated
    public boolean removeElement(ResXmlElement element) {
        return this.remove(element);
    }

    @Deprecated
    public boolean removeNode(ResXmlNode node) {
        return this.remove(node);
    }

    public int countElements() {
        return CollectionUtil.count(this.getElements());
    }

    @Deprecated
    public void clearChildes() {
        ResXmlNode[] copyOfNodeList;
        for (ResXmlNode xmlNode : copyOfNodeList = this.mBody.getChildes().toArray(new ResXmlNode[0])) {
            if (xmlNode == null) continue;
            xmlNode.onRemoved();
            this.mBody.remove(xmlNode);
        }
    }

    public boolean hasText() {
        return this.iterator(ResXmlTextNode.class).hasNext();
    }

    public boolean hasElement() {
        return this.iterator(ResXmlElement.class).hasNext();
    }

    public List<ResXmlNode> listXmlNodes() {
        return CollectionUtil.toList(this.iterator());
    }

    public Iterator<ResXmlTextNode> getTextNodes() {
        return this.iterator(ResXmlTextNode.class);
    }

    public List<ResXmlTextNode> listXmlTextNodes() {
        return CollectionUtil.toList(this.getTextNodes());
    }

    public int removeElements(Predicate<? super ResXmlElement> predicate) {
        List<ResXmlElement> removeList = CollectionUtil.toList(this.getElements(predicate));
        Iterator<ResXmlElement> iterator = removeList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            boolean removed = this.remove(iterator.next());
            if (!removed) continue;
            ++count;
        }
        return count;
    }

    ResXmlStartNamespace getStartNamespaceByUriRef(int uriRef) {
        if (uriRef < 0) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (uriRef != ns.getUriReference()) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByUriRef(uriRef);
        }
        return null;
    }

    ResXmlStartNamespace getXmlStartNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (!uri.equals(ns.getUri()) || !prefix.equals(ns.getPrefix())) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentElement();
        if (xmlElement != null) {
            return xmlElement.getXmlStartNamespace(uri, prefix);
        }
        return null;
    }

    private ResXmlStartNamespace getOrCreateXmlStartNamespace(String uri, String prefix) {
        ResXmlStartNamespace exist = this.getXmlStartNamespace(uri, prefix);
        if (exist != null) {
            return exist;
        }
        return this.getRootElement().createXmlStartNamespace(uri, prefix);
    }

    private ResXmlStartNamespace createXmlStartNamespace(String uri, String prefix) {
        ResXmlStartNamespace startNamespace = new ResXmlStartNamespace();
        ResXmlEndNamespace endNamespace = new ResXmlEndNamespace();
        startNamespace.setEnd(endNamespace);
        this.addStartNamespace(startNamespace);
        this.addEndNamespace(endNamespace, true);
        ResXmlStringPool stringPool = this.getStringPool();
        ResXmlString xmlString = stringPool.createNew(uri);
        startNamespace.setUriReference(xmlString.getIndex());
        startNamespace.setPrefix(prefix);
        return startNamespace;
    }

    ResXmlStartNamespace getStartNamespaceByUri(String uri) {
        if (uri == null) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (!uri.equals(ns.getUri())) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByUri(uri);
        }
        return null;
    }

    private ResXmlStartNamespace getStartNamespaceByPrefix(String prefix, ResXmlStartNamespace result) {
        if (prefix == null) {
            return result;
        }
        for (ResXmlStartNamespace ns : this.getStartNamespaceList()) {
            if (!prefix.equals(ns.getPrefix())) continue;
            String uri = ns.getUri();
            if (uri != null && uri.length() != 0) {
                return ns;
            }
            result = ns;
        }
        ResXmlElement xmlElement = this.getParentElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByPrefix(prefix, result);
        }
        return result;
    }

    private List<ResXmlStartNamespace> getStartNamespaceList() {
        return this.mStartNamespaceList.getChildes();
    }

    private void addStartNamespace(ResXmlStartNamespace item) {
        this.mStartNamespaceList.add(item);
    }

    private void addEndNamespace(ResXmlEndNamespace item, boolean at_first) {
        if (at_first) {
            this.mEndNamespaceList.add(0, item);
        } else {
            this.mEndNamespaceList.add(item);
        }
    }

    void removeNamespace(ResXmlStartNamespace startNamespace) {
        if (startNamespace == null) {
            return;
        }
        startNamespace.onRemoved();
        this.mStartNamespaceList.remove(startNamespace);
        this.mEndNamespaceList.remove(startNamespace.getEnd());
    }

    ResXmlStartElement newStartElement(int lineNo) {
        ResXmlStartElement startElement = new ResXmlStartElement();
        this.setStartElement(startElement);
        ResXmlEndElement endElement = new ResXmlEndElement();
        startElement.setResXmlEndElement(endElement);
        this.setEndElement(endElement);
        endElement.setResXmlStartElement(startElement);
        startElement.setLineNumber(lineNo);
        endElement.setLineNumber(lineNo);
        return startElement;
    }

    private ResXmlAttributeArray getAttributeArray() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getResXmlAttributeArray();
        }
        return null;
    }

    private ResXmlStartElement getStartElement() {
        return this.mStartElementContainer.getItem();
    }

    private void setStartElement(ResXmlStartElement item) {
        this.mStartElementContainer.setItem(item);
    }

    private ResXmlEndElement getEndElement() {
        return this.mEndElementContainer.getItem();
    }

    private void setEndElement(ResXmlEndElement item) {
        this.mEndElementContainer.setItem(item);
    }

    private ResXmlTextNode getOrCreateResXmlText() {
        ResXmlNode last = this.get(this.size() - 1);
        if (last instanceof ResXmlTextNode) {
            return (ResXmlTextNode)last;
        }
        return this.createResXmlTextNode();
    }

    public void addNode(ResXmlNode xmlNode) {
        this.mBody.add(xmlNode);
    }

    public void addNode(int position, ResXmlNode xmlNode) {
        this.mBody.add(position, xmlNode);
    }

    private boolean isBalanced() {
        return this.isElementBalanced() && this.isNamespaceBalanced();
    }

    private boolean isNamespaceBalanced() {
        return this.mStartNamespaceList.size() == this.mEndNamespaceList.size();
    }

    private boolean isElementBalanced() {
        return this.hasStartElement() && this.hasEndElement();
    }

    private boolean hasStartElement() {
        return this.mStartElementContainer.hasItem();
    }

    private boolean hasEndElement() {
        return this.mEndElementContainer.hasItem();
    }

    private void linkStartEnd() {
        this.linkStartEndElement();
        this.linkStartEndNameSpaces();
    }

    private void linkStartEndElement() {
        ResXmlStartElement start = this.getStartElement();
        ResXmlEndElement end = this.getEndElement();
        if (start == null || end == null) {
            return;
        }
        start.setResXmlEndElement(end);
        end.setResXmlStartElement(start);
    }

    private void ensureStartEndElement() {
        ResXmlStartElement start = this.getStartElement();
        ResXmlEndElement end = this.getEndElement();
        if (start != null && end != null) {
            return;
        }
        if (start == null) {
            start = new ResXmlStartElement();
            this.setStartElement(start);
        }
        if (end == null) {
            end = new ResXmlEndElement();
            this.setEndElement(end);
        }
        this.linkStartEndElement();
    }

    private void linkStartEndNameSpaces() {
        if (!this.isNamespaceBalanced()) {
            return;
        }
        int max = this.mStartNamespaceList.size();
        for (int i = 0; i < max; ++i) {
            ResXmlStartNamespace start = this.mStartNamespaceList.get(i);
            ResXmlEndNamespace end = this.mEndNamespaceList.get(max - i - 1);
            start.setEnd(end);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int pos = reader.getPosition();
        while (this.readNext(reader) && pos != reader.getPosition()) {
            pos = reader.getPosition();
        }
    }

    private boolean readNext(BlockReader reader) throws IOException {
        int pos = reader.getPosition();
        if (this.isBalanced()) {
            return false;
        }
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == null) {
            this.unknownChunk(headerBlock);
            return false;
        }
        if (chunkType == ChunkType.XML_START_ELEMENT) {
            this.onStartElement(reader);
        } else if (chunkType == ChunkType.XML_END_ELEMENT) {
            this.onEndElement(reader);
        } else if (chunkType == ChunkType.XML_START_NAMESPACE) {
            this.onStartNamespace(reader);
        } else if (chunkType == ChunkType.XML_END_NAMESPACE) {
            this.onEndNamespace(reader);
        } else if (chunkType == ChunkType.XML_CDATA) {
            this.onXmlText(reader);
        } else {
            this.unexpectedChunk(headerBlock);
        }
        if (!this.isBalanced()) {
            if (!reader.isAvailable()) {
                this.unBalancedFinish();
            } else if (pos != reader.getPosition()) {
                return true;
            }
        }
        this.linkStartEnd();
        return false;
    }

    private void onStartElement(BlockReader reader) throws IOException {
        if (this.hasStartElement()) {
            ResXmlElement childElement = new ResXmlElement();
            this.addElement(childElement);
            childElement.readBytes(reader);
        } else {
            ResXmlStartElement startElement = new ResXmlStartElement();
            this.setStartElement(startElement);
            startElement.readBytes(reader);
        }
    }

    private void onEndElement(BlockReader reader) throws IOException {
        if (this.hasEndElement()) {
            this.multipleEndElement(reader);
            return;
        }
        ResXmlEndElement endElement = new ResXmlEndElement();
        this.setEndElement(endElement);
        endElement.readBytes(reader);
    }

    private void onStartNamespace(BlockReader reader) throws IOException {
        ResXmlStartNamespace startNamespace = new ResXmlStartNamespace();
        this.addStartNamespace(startNamespace);
        startNamespace.readBytes(reader);
    }

    private void onEndNamespace(BlockReader reader) throws IOException {
        ResXmlEndNamespace endNamespace = new ResXmlEndNamespace();
        this.addEndNamespace(endNamespace, false);
        endNamespace.readBytes(reader);
    }

    private void onXmlText(BlockReader reader) throws IOException {
        ResXmlTextNode textNode = this.createResXmlTextNode();
        textNode.getResXmlText().readBytes(reader);
    }

    private void unknownChunk(HeaderBlock headerBlock) throws IOException {
        throw new IOException("Unknown chunk: " + headerBlock.toString());
    }

    private void multipleEndElement(BlockReader reader) throws IOException {
        throw new IOException("Multiple end element: " + reader.toString());
    }

    private void unexpectedChunk(HeaderBlock headerBlock) throws IOException {
        throw new IOException("Unexpected chunk: " + headerBlock.toString());
    }

    private void unBalancedFinish() throws IOException {
        if (!this.isNamespaceBalanced()) {
            throw new IOException("Unbalanced namespace: start=" + this.mStartNamespaceList.size() + ", end=" + this.mEndNamespaceList.size());
        }
        if (!this.isElementBalanced()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unbalanced element: start=");
            ResXmlStartElement startElement = this.getStartElement();
            if (startElement != null) {
                builder.append(startElement);
            } else {
                builder.append("null");
            }
            builder.append(", end=");
            ResXmlEndElement endElement = this.getEndElement();
            if (endElement != null) {
                builder.append(endElement);
            } else {
                builder.append("null");
            }
            throw new IOException(builder.toString());
        }
    }

    public void mergeWithName(ResourceMergeOption mergeOption, ResXmlElement element) {
        this.setName(element.getName(false));
        this.setNamespace(element.getNamespace());
        Iterator<ResXmlAttribute> attributes = element.getAttributes();
        while (attributes.hasNext()) {
            ResXmlAttribute attribute = attributes.next();
            ResXmlAttribute resXmlAttribute = this.newAttribute();
            resXmlAttribute.mergeWithName(mergeOption, attribute);
        }
        for (ResXmlNode node : element) {
            if (node instanceof ResXmlElement) {
                this.createChildElement().mergeWithName(mergeOption, (ResXmlElement)node);
                continue;
            }
            if (!(node instanceof ResXmlTextNode)) continue;
            this.createResXmlTextNode().mergeWithName(mergeOption, (ResXmlTextNode)node);
        }
        this.getStartElement().setComment(element.getStartComment());
        this.getEndElement().setComment(element.getEndComment());
        this.getStartElement().setLineNumber(element.getStartElement().getLineNumber());
        this.getEndElement().setLineNumber(element.getEndElement().getLineNumber());
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            ResXmlNamespace namespace = this.getNamespaceAt(i);
            serializer.setPrefix(namespace.getPrefix(), namespace.getUri());
        }
        String comment = this.getStartComment();
        if (comment != null) {
            serializer.comment(comment);
        }
        boolean indent = ResXmlElement.getFeatureSafe(serializer, FEATURE_INDENT_OUTPUT);
        ResXmlElement.setIndent(serializer, indent);
        boolean indentChanged = indent;
        serializer.startTag(this.getUri(), this.getName());
        count = this.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ResXmlAttribute attribute = this.getAttributeAt(i);
            attribute.serialize(serializer);
        }
        for (ResXmlNode xmlNode : this) {
            if (indentChanged && xmlNode instanceof ResXmlTextNode) {
                indentChanged = false;
                ResXmlElement.setIndent(serializer, false);
            }
            xmlNode.serialize(serializer);
        }
        serializer.endTag(this.getUri(), this.getName());
        if (indent != indentChanged) {
            ResXmlElement.setIndent(serializer, true);
        }
        serializer.flush();
    }

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        if (parser.getEventType() != 2) {
            throw new XmlPullParserException("Invalid state START_TAG != " + parser.getEventType());
        }
        String name = parser.getName();
        String prefix = ResXmlElement.splitPrefix(name);
        name = ResXmlElement.splitName(name);
        this.setName(name);
        String uri = parser.getNamespace();
        if (prefix == null) {
            prefix = parser.getPrefix();
        }
        this.parseNamespaces(parser);
        this.setLineNumber(parser.getLineNumber());
        this.parseAttributes(parser);
        this.parseChildes(parser);
        if (prefix != null) {
            ResXmlNamespace ns;
            if ((uri == null || uri.length() == 0) && (ns = this.getNamespaceByPrefix(prefix)) != null) {
                uri = ns.getUri();
            }
            this.setNamespace(uri, prefix);
        }
        this.clearNullNodes(false);
        this.calculateAttributesOrder();
    }

    private void parseChildes(XmlPullParser parser) throws IOException, XmlPullParserException {
        ResXmlElement currentElement = this;
        int event = parser.next();
        while (event != 3 && event != 1) {
            if (event == 2) {
                ResXmlElement element = this.createChildElement();
                element.parse(parser);
                currentElement = element;
            } else if (ResXmlTextNode.isTextEvent(event)) {
                ResXmlTextNode textNode = this.getOrCreateResXmlText();
                textNode.parse(parser);
            } else if (event == 9) {
                currentElement.setComment(parser.getText());
            }
            event = parser.next();
        }
    }

    private void parseNamespaces(XmlPullParser parser) throws XmlPullParserException {
        int i;
        int count = parser.getNamespaceCount(parser.getDepth());
        for (i = 0; i < count; ++i) {
            ResXmlStartNamespace namespace = this.createXmlStartNamespace(parser.getNamespaceUri(i), parser.getNamespacePrefix(i));
            namespace.setLineNumber(parser.getLineNumber());
        }
        count = parser.getAttributeCount();
        for (i = 0; i < count; ++i) {
            String name = parser.getAttributeName(i);
            String prefix = ResXmlElement.splitPrefix(name);
            name = ResXmlElement.splitName(name);
            String value = parser.getAttributeValue(i);
            if (!ResXmlElement.looksNamespace(value, prefix)) continue;
            this.getOrCreateNamespace(value, name);
        }
    }

    private void parseAttributes(XmlPullParser parser) throws IOException {
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String uri;
            String name = parser.getAttributeName(i);
            String prefix = ResXmlElement.splitPrefix(name);
            name = ResXmlElement.splitName(name);
            String value = parser.getAttributeValue(i);
            if (ResXmlElement.looksNamespace(value, prefix)) continue;
            if (prefix == null && (prefix = parser.getAttributePrefix(i)) != null && prefix.length() == 0) {
                prefix = null;
            }
            if (prefix != null) {
                ResXmlNamespace ns;
                uri = parser.getAttributeNamespace(i);
                if (uri.length() == 0 && (ns = this.getNamespaceByPrefix(prefix)) != null) {
                    uri = ns.getUri();
                }
            } else {
                uri = null;
            }
            ResXmlAttribute attribute = this.newAttribute();
            attribute.encode(false, uri, prefix, name, value);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONArray attrArray;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("node_type", NAME_element);
        jsonObject.put(NAME_name, this.getName(false));
        jsonObject.put(NAME_namespace_uri, this.getUri());
        jsonObject.put(NAME_namespace_prefix, this.getPrefix());
        int lineStart = this.getStartLineNumber();
        int lineEnd = this.getEndLineNumber();
        jsonObject.put(NAME_line, lineStart);
        if (lineStart != lineEnd) {
            jsonObject.put(NAME_line_end, lineEnd);
        }
        JSONArray nsList = new JSONArray();
        for (ResXmlStartNamespace namespace : this.getStartNamespaceList()) {
            JSONObject ns = new JSONObject();
            ns.put(NAME_namespace_uri, namespace.getUri());
            ns.put(NAME_namespace_prefix, namespace.getPrefix());
            nsList.put(ns);
        }
        if (!nsList.isEmpty()) {
            jsonObject.put(NAME_namespaces, nsList);
        }
        jsonObject.put(NAME_comment, this.getStartComment());
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null && !(attrArray = attributeArray.toJson()).isEmpty()) {
            jsonObject.put(NAME_attributes, attrArray);
        }
        JSONArray childes = new JSONArray();
        for (ResXmlNode xmlNode : this) {
            childes.put(xmlNode.toJson());
        }
        if (!childes.isEmpty()) {
            jsonObject.put(NAME_childes, childes);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        JSONArray childArray;
        this.ensureStartEndElement();
        int startLineNumber = json.optInt(NAME_line, 0);
        int endLineNo = json.optInt(NAME_line_end, 0);
        if (endLineNo == 0 && startLineNumber != 0) {
            endLineNo = startLineNumber;
        }
        this.setStartLineNumber(startLineNumber);
        this.setEndLineNumber(endLineNo);
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.setLineNumber(startLineNumber);
        }
        JSONArray nsArray = json.optJSONArray(NAME_namespaces);
        if (nsArray != null) {
            int length = nsArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject nsObject = nsArray.getJSONObject(i);
                String uri = nsObject.optString(NAME_namespace_uri, "");
                String prefix = nsObject.optString(NAME_namespace_prefix, "");
                this.newNamespace(uri, prefix);
            }
        }
        this.setName(json.getString(NAME_name));
        this.setNamespace(json.optString(NAME_namespace_uri, null), json.optString(NAME_namespace_prefix, null));
        this.setComment(json.optString(NAME_comment));
        this.addResXmlText(json.optString(NAME_text, null));
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null) {
            attributeArray.fromJson(json.optJSONArray(NAME_attributes));
        }
        if ((childArray = json.optJSONArray(NAME_childes)) != null) {
            int length = childArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject childObject = childArray.getJSONObject(i);
                if (this.isTextNode(childObject)) {
                    this.createResXmlTextNode().fromJson(childObject);
                    continue;
                }
                this.createChildElement().fromJson(childObject);
            }
        }
        this.getStartElement().calculatePositions();
    }

    private boolean isTextNode(JSONObject childObject) {
        String type = childObject.optString("node_type", null);
        if ("text".equals(type)) {
            return true;
        }
        if (NAME_element.equals(type)) {
            return false;
        }
        return childObject.has(NAME_text);
    }

    public XMLElement toXml() {
        return this.toXml(null, false);
    }

    @Override
    public XMLElement toXml(boolean decode) {
        return this.toXml(null, decode);
    }

    public XMLElement decodeToXml() {
        return this.toXml(null, true);
    }

    private XMLElement toXml(XMLElement parent, boolean decode) {
        XMLElement xmlElement = parent == null ? new XMLElement() : parent.newElement();
        xmlElement.setName(this.getName(false));
        xmlElement.setLineNumber(this.getStartElement().getLineNumber());
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            xmlElement.addNamespace(startNamespace.decodeToXml());
        }
        xmlElement.setNamespace(this.getNamespace());
        for (ResXmlAttribute resXmlAttribute : this.listAttributes()) {
            XMLAttribute xmlAttribute = resXmlAttribute.toXml(decode);
            xmlElement.addAttribute(xmlAttribute);
            if (decode) {
                xmlAttribute.setNamespace(resXmlAttribute.decodeUri(), resXmlAttribute.decodePrefix());
                continue;
            }
            xmlAttribute.setNamespace(resXmlAttribute.getUri(), resXmlAttribute.decodePrefix());
        }
        String comment = this.getStartComment();
        if (comment != null) {
            xmlElement.add(new XMLComment(comment));
        }
        if ((comment = this.getEndComment()) != null) {
            xmlElement.add(new XMLComment(comment));
        }
        for (ResXmlNode xmlNode : this) {
            if (xmlNode instanceof ResXmlElement) {
                ResXmlElement childResXmlElement = (ResXmlElement)xmlNode;
                childResXmlElement.toXml(xmlElement, decode);
                continue;
            }
            xmlElement.add(xmlNode.toXml(decode));
        }
        return xmlElement;
    }

    @Override
    public int compare(ResXmlNode node1, ResXmlNode node2) {
        return Integer.compare(node1.getIndex(), node2.getIndex());
    }

    public String toString() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            builder.append(this.getStartLineNumber());
            builder.append(":");
            builder.append(this.getEndLineNumber());
            builder.append(") ");
            builder.append("<");
            builder.append(start.toString());
            if (this.hasText() && !this.hasElement()) {
                builder.append(">");
                for (ResXmlTextNode textNode : this.listXmlTextNodes()) {
                    builder.append(textNode.getText());
                }
                builder.append("</");
                builder.append(start.getTagName());
                builder.append(">");
            } else {
                builder.append("/>");
            }
            return builder.toString();
        }
        return "NULL";
    }

    @Deprecated
    public ResXmlElement getElementByTagName(String name) {
        return this.getElement(name);
    }

    @Deprecated
    public ResXmlElement getRootResXmlElement() {
        ResXmlElement parent = this.getParentElement();
        if (parent != null) {
            return parent.getRootElement();
        }
        return this.getRootElement();
    }

    @Deprecated
    public ResXmlElement getParentResXmlElement() {
        return this.getParentElement();
    }

    @Deprecated
    public Iterator<ResXmlTextNode> getResXmlTextNodes() {
        return this.getTextNodes();
    }

    @Deprecated
    public int removeNodes(Predicate<? super ResXmlNode> predicate) {
        return this.removeIf(predicate);
    }

    @Deprecated
    public Iterator<ResXmlNode> getResXmlNodes(Predicate<? super ResXmlNode> predicate) {
        return this.iterator(predicate);
    }

    @Deprecated
    public Iterator<ResXmlNode> getResXmlNodes() {
        return this.iterator();
    }

    @Deprecated
    public ResXmlNode getResXmlNode(int position) {
        return this.get(position);
    }

    @Deprecated
    public int countResXmlNodes() {
        return this.size();
    }

    private static boolean looksNamespace(String uri, String prefix) {
        return uri.length() != 0 && "xmlns".equals(prefix);
    }

    private static boolean getFeatureSafe(XmlSerializer serializer, String name) {
        try {
            return serializer.getFeature(name);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static String splitPrefix(String name) {
        int i = name.indexOf(58);
        if (i >= 0) {
            return name.substring(0, i);
        }
        return null;
    }

    private static String splitName(String name) {
        int i = name.indexOf(58);
        if (i >= 0) {
            return name.substring(i + 1);
        }
        return name;
    }

    static void setIndent(XmlSerializer serializer, boolean state) {
        ResXmlElement.setFeatureSafe(serializer, FEATURE_INDENT_OUTPUT, state);
    }

    private static void setFeatureSafe(XmlSerializer serializer, String name, boolean state) {
        try {
            serializer.setFeature(name, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

