/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.archive.InputSource;
import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.MainChunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.ParserEvent;
import com.reandroid.arsc.chunk.xml.ParserEventList;
import com.reandroid.arsc.chunk.xml.ResIdBuilder;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeTree;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.common.BytesOutputStream;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlDocument
extends Chunk<HeaderBlock>
implements ResXmlNodeTree,
MainChunk,
ParentChunk,
JSONConvert<JSONObject> {
    private final ResXmlStringPool mResXmlStringPool = new ResXmlStringPool(true);
    private final ResXmlIDMap mResXmlIDMap = new ResXmlIDMap();
    private final BlockList<ResXmlNode> mNodeList = new BlockList();
    private ApkFile mApkFile;
    private PackageBlock mPackageBlock;
    private boolean mDestroyed;
    private static final String NAME_element = "element";
    private static final String NAME_styled_strings = "styled_strings";

    public ResXmlDocument() {
        super(new HeaderBlock(ChunkType.XML), 3);
        this.addChild(this.mResXmlStringPool);
        this.addChild(this.mResXmlIDMap);
        this.addChild(this.mNodeList);
        this.mNodeList.add(new ResXmlElement());
    }

    @Override
    public BlockList<ResXmlNode> getNodeListBlockInternal() {
        return this.mNodeList;
    }

    public Iterator<ResXmlAttribute> recursiveAttributes() throws ConcurrentModificationException {
        return new IterableIterator<ResXmlElement, ResXmlAttribute>(this.getElements()){

            @Override
            public Iterator<ResXmlAttribute> iterator(ResXmlElement element) {
                return element.recursiveAttributes();
            }
        };
    }

    public Iterator<ResXmlNode> recursiveXmlNodes() throws ConcurrentModificationException {
        return new IterableIterator<ResXmlNode, ResXmlNode>(this.iterator()){

            @Override
            public Iterator<ResXmlNode> iterator(ResXmlNode resXmlNode) {
                if (resXmlNode instanceof ResXmlElement) {
                    return ((ResXmlElement)resXmlNode).recursiveXmlNodes();
                }
                return SingleIterator.of(resXmlNode);
            }
        };
    }

    public Iterator<ResXmlElement> recursiveElements() throws ConcurrentModificationException {
        return new IterableIterator<ResXmlElement, ResXmlElement>(this.getElements()){

            @Override
            public Iterator<ResXmlElement> iterator(ResXmlElement element) {
                return element.recursiveElements();
            }
        };
    }

    public int autoSetAttributeNamespaces() {
        return this.autoSetAttributeNamespaces(true);
    }

    public int autoSetAttributeNamespaces(boolean removeNoIdPrefix) {
        int changedCount = 0;
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            ResXmlElement element = iterator.next();
            changedCount += element.autoSetAttributeNamespaces(removeNoIdPrefix);
        }
        if (changedCount > 0) {
            this.removeUnusedNamespaces();
            this.getStringPool().removeUnusedStrings();
        }
        return changedCount;
    }

    public int autoSetAttributeNames() {
        return this.autoSetAttributeNames(true);
    }

    public int autoSetAttributeNames(boolean removeNoIdPrefix) {
        int changedCount = 0;
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            changedCount += iterator.next().autoSetAttributeNames(removeNoIdPrefix);
        }
        if (changedCount > 0) {
            this.removeUnusedNamespaces();
            this.getStringPool().removeUnusedStrings();
        }
        return changedCount;
    }

    public void autoSetLineNumber() {
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            iterator.next().autoSetLineNumber();
        }
    }

    public int removeUnusedNamespaces() {
        int count = 0;
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            count += iterator.next().removeUnusedNamespaces();
        }
        return count;
    }

    public String refreshFull() {
        int count;
        int sizeOld = ((HeaderBlock)this.getHeaderBlock()).getChunkSize();
        StringBuilder message = new StringBuilder();
        boolean appendOnce = false;
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            ResXmlElement element = iterator.next();
            count = element.removeUndefinedAttributes();
            if (count == 0) continue;
            message.append("Removed undefined attributes = ");
            message.append(count);
            appendOnce = true;
        }
        count = this.removeUnusedNamespaces();
        if (count != 0) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Removed unused namespaces = ");
            message.append(count);
            appendOnce = true;
        }
        if ((count = this.getStringPool().removeUnusedStrings().size()) != 0) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Removed xml strings = ");
            message.append(count);
            appendOnce = true;
        }
        this.refresh();
        int sizeNew = ((HeaderBlock)this.getHeaderBlock()).getChunkSize();
        if (sizeOld != sizeNew) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Xml size changed = ");
            message.append(sizeOld);
            message.append(", ");
            message.append(sizeNew);
            appendOnce = true;
        }
        if (appendOnce) {
            return message.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ResXmlDocument resXmlDocument = this;
        synchronized (resXmlDocument) {
            if (this.mDestroyed) {
                return;
            }
            this.mDestroyed = true;
            this.mNodeList.clearChildes();
            this.getResXmlIDMap().destroy();
            this.getStringPool().clear();
            this.refresh();
        }
    }

    public void setAttributesUnitSize(int size, boolean setToAll) {
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            iterator.next().setAttributesUnitSize(size, setToAll);
        }
    }

    public ResXmlElement getOrCreateElement(String tag) {
        ResXmlElement element = this.getElement(tag);
        if (element == null) {
            element = this.createRootElement(tag);
        } else if (tag != null) {
            element.setName(tag);
        }
        return element;
    }

    public ResXmlElement createRootElement(String tag) {
        int lineNo = 1;
        ResXmlElement resXmlElement = this.newElement();
        resXmlElement.newStartElement(lineNo);
        if (tag != null) {
            resXmlElement.setName(tag);
        }
        return resXmlElement;
    }

    void linkStringReferences() {
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            iterator.next().linkStringReferences();
        }
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream(((HeaderBlock)this.getHeaderBlock()).getChunkSize());
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        boolean readOk;
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            throw new IOException("Not bin xml: " + reader);
        }
        int chunkSize = headerBlock.getChunkSize();
        if (chunkSize < 0) {
            throw new IOException("Negative chunk size: " + chunkSize);
        }
        if (chunkSize > reader.available()) {
            throw new IOException("Higher chunk size: " + chunkSize + ", available = " + reader.available());
        }
        if (chunkSize < headerBlock.getHeaderSize()) {
            throw new IOException("Higher header size: " + headerBlock);
        }
        BlockReader chunkReader = reader.create(chunkSize);
        headerBlock = this.getHeaderBlock();
        headerBlock.readBytes(chunkReader);
        headerBlock.setType(ChunkType.XML);
        this.clear();
        while (chunkReader.isAvailable() && (readOk = this.readNext(chunkReader))) {
        }
        reader.offset(headerBlock.getChunkSize());
        chunkReader.close();
        this.onChunkLoaded();
    }

    @Override
    public void onChunkLoaded() {
        super.onChunkLoaded();
        this.linkStringReferences();
    }

    private boolean readNext(BlockReader reader) throws IOException {
        if (!reader.isAvailable()) {
            return false;
        }
        int position = reader.getPosition();
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == ChunkType.STRING) {
            this.mResXmlStringPool.readBytes(reader);
        } else if (chunkType == ChunkType.XML_RESOURCE_MAP) {
            this.mResXmlIDMap.readBytes(reader);
        } else {
            if (this.isElementChunk(chunkType)) {
                this.newElement().readBytes(reader);
                return reader.isAvailable();
            }
            throw new IOException("Unexpected chunk " + headerBlock);
        }
        return reader.isAvailable() && position != reader.getPosition();
    }

    private boolean isElementChunk(ChunkType chunkType) {
        if (chunkType == ChunkType.XML_START_ELEMENT) {
            return true;
        }
        if (chunkType == ChunkType.XML_END_ELEMENT) {
            return true;
        }
        if (chunkType == ChunkType.XML_START_NAMESPACE) {
            return true;
        }
        if (chunkType == ChunkType.XML_END_NAMESPACE) {
            return true;
        }
        if (chunkType == ChunkType.XML_CDATA) {
            return true;
        }
        return chunkType == ChunkType.XML_LAST_CHUNK;
    }

    public ResXmlStringPool getStringPool() {
        return this.mResXmlStringPool;
    }

    @Override
    public ApkFile getApkFile() {
        return this.mApkFile;
    }

    @Override
    public void setApkFile(ApkFile apkFile) {
        this.mApkFile = apkFile;
    }

    @Override
    public PackageBlock getPackageBlock() {
        ApkFile apkFile = this.mApkFile;
        PackageBlock packageBlock = this.mPackageBlock;
        if (apkFile == null || packageBlock != null) {
            return packageBlock;
        }
        TableBlock tableBlock = apkFile.getLoadedTableBlock();
        if (tableBlock != null) {
            this.mPackageBlock = packageBlock = this.selectPackageBlock(tableBlock);
        }
        return packageBlock;
    }

    public void setPackageBlock(PackageBlock packageBlock) {
        this.mPackageBlock = packageBlock;
    }

    PackageBlock selectPackageBlock(TableBlock tableBlock) {
        PackageBlock packageBlock = tableBlock.pickOne();
        if (packageBlock == null) {
            packageBlock = tableBlock.pickOrEmptyPackage();
        }
        return packageBlock;
    }

    @Override
    public TableBlock getTableBlock() {
        TableBlock tableBlock;
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null && (tableBlock = packageBlock.getTableBlock()) != null) {
            return tableBlock;
        }
        ApkFile apkFile = this.getApkFile();
        if (apkFile != null) {
            return apkFile.getLoadedTableBlock();
        }
        return null;
    }

    @Override
    public StringPool<?> getSpecStringPool() {
        return null;
    }

    @Override
    public MainChunk getMainChunk() {
        return this;
    }

    public ResXmlIDMap getResXmlIDMap() {
        return this.mResXmlIDMap;
    }

    public ResXmlElement getDocumentElement() {
        return CollectionUtil.getFirst(this.getElements());
    }

    public ResXmlElement newElement() {
        ResXmlElement element = new ResXmlElement();
        this.add(element);
        return element;
    }

    public void addElement(int index, ResXmlElement element) {
        this.clearEmptyElements();
        this.add(index, element);
    }

    public void clearEmptyElements() {
        this.removeIf(xmlNode -> {
            if (xmlNode instanceof ResXmlElement) {
                return ((ResXmlElement)xmlNode).isUndefined();
            }
            return false;
        });
    }

    @Deprecated
    public void setDocumentElement(ResXmlElement resXmlElement) {
        this.clear();
        this.add(resXmlElement);
    }

    @Override
    protected void onPreRefresh() {
        this.getNodeListBlockInternal().refresh();
        super.onPreRefresh();
    }

    @Override
    protected void onChunkRefreshed() {
    }

    public void readBytes(File file) throws IOException {
        BlockReader reader = new BlockReader(file);
        super.readBytes(reader);
    }

    public void readBytes(InputStream inputStream) throws IOException {
        BlockReader reader = new BlockReader(inputStream);
        super.readBytes(reader);
    }

    public final int writeBytes(File file) throws IOException {
        if (this.isNull()) {
            throw new IOException("Can NOT save null block");
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        int length = super.writeBytes(outputStream);
        ((OutputStream)outputStream).close();
        return length;
    }

    public void mergeWithName(ResourceMergeOption mergeOption, ResXmlDocument document) {
        if (document == this) {
            return;
        }
        Iterator<ResXmlElement> iterator = document.getElements();
        while (iterator.hasNext()) {
            ResXmlElement coming = iterator.next();
            ResXmlElement element = this.getOrCreateElement(coming.getName());
            element.mergeWithName(mergeOption, coming);
        }
    }

    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        if (this.mDestroyed) {
            throw new IOException("Destroyed document");
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            throw new IOException("Can not decode without package");
        }
        this.setPackageBlock(packageBlock);
        int event = parser.getEventType();
        if (event == 0) {
            this.clear();
            parser.next();
        }
        while (this.parseNext(parser)) {
            parser.next();
        }
        this.refreshFull();
    }

    private boolean parseNext(XmlPullParser parser) throws IOException, XmlPullParserException {
        int event = parser.getEventType();
        while (event != 2 && event != 1) {
            event = parser.next();
        }
        if (event == 2) {
            this.newElement().parse(parser);
            return true;
        }
        return false;
    }

    public String serializeToXml() throws IOException {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XMLFactory.newSerializer(writer);
        this.serialize(serializer);
        serializer.flush();
        writer.flush();
        writer.close();
        return writer.toString();
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        if (this.mDestroyed) {
            throw new IOException("Destroyed document");
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            throw new IOException("Can not decode without package");
        }
        ResXmlElement.setIndent(serializer, true);
        serializer.startDocument("utf-8", null);
        this.autoSetAttributeNamespaces();
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            iterator.next().serialize(serializer);
        }
        serializer.endDocument();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_element, this.getDocumentElement().toJson());
        JSONArray pool = this.getStringPool().toJson();
        if (pool != null) {
            jsonObject.put(NAME_styled_strings, pool);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.onFromJson(json);
        ResXmlElement xmlElement = this.getDocumentElement();
        xmlElement.fromJson(json.optJSONObject(NAME_element));
        this.refresh();
    }

    public XMLDocument decodeToXml() {
        return this.toXml(true);
    }

    public XMLDocument toXml() {
        return this.toXml(false);
    }

    public XMLDocument toXml(boolean decode) {
        XMLDocument xmlDocument = new XMLDocument();
        xmlDocument.setEncoding("utf-8");
        for (ResXmlNode node : this) {
            xmlDocument.add(node.toXml(decode));
        }
        return xmlDocument;
    }

    private void onFromJson(JSONObject json) {
        ArrayList<JSONObject> attributeList = new ArrayList<JSONObject>();
        this.recursiveAttributes(json.optJSONObject(NAME_element), attributeList);
        this.buildResourceIds(attributeList);
        HashSet<String> strings = new HashSet<String>();
        this.recursiveStrings(json.optJSONObject(NAME_element), strings);
        ResXmlStringPool stringPool = this.getStringPool();
        stringPool.addStrings(strings);
        stringPool.refresh();
    }

    private void buildResourceIds(List<JSONObject> attributeList) {
        ResIdBuilder builder = new ResIdBuilder();
        for (JSONObject attribute : attributeList) {
            int id = attribute.getInt("id");
            if (id == 0) continue;
            String name = attribute.getString("name");
            builder.add(id, name);
        }
        builder.buildTo(this.getResXmlIDMap());
    }

    private void recursiveAttributes(JSONObject elementJson, List<JSONObject> results) {
        JSONArray childElements;
        if (elementJson == null) {
            return;
        }
        JSONArray attributes = elementJson.optJSONArray(ResXmlElement.NAME_attributes);
        if (attributes != null) {
            int length = attributes.length();
            for (int i = 0; i < length; ++i) {
                JSONObject attr = attributes.optJSONObject(i);
                if (attr == null) continue;
                results.add(attr);
            }
        }
        if ((childElements = elementJson.optJSONArray(ResXmlElement.NAME_childes)) != null) {
            int length = childElements.length();
            for (int i = 0; i < length; ++i) {
                this.recursiveAttributes(childElements.getJSONObject(i), results);
            }
        }
    }

    private void recursiveStrings(JSONObject elementJson, Set<String> results) {
        JSONArray childElements;
        JSONArray attributes;
        if (elementJson == null) {
            return;
        }
        results.add(elementJson.optString(ResXmlElement.NAME_namespace_uri));
        results.add(elementJson.optString(ResXmlElement.NAME_name));
        JSONArray namespaces = elementJson.optJSONArray(ResXmlElement.NAME_namespaces);
        if (namespaces != null) {
            int length = namespaces.length();
            for (int i = 0; i < length; ++i) {
                JSONObject nsObject = namespaces.getJSONObject(i);
                results.add(nsObject.getString(ResXmlElement.NAME_namespace_uri));
                results.add(nsObject.getString(ResXmlElement.NAME_namespace_prefix));
            }
        }
        if ((attributes = elementJson.optJSONArray(ResXmlElement.NAME_attributes)) != null) {
            int length = attributes.length();
            for (int i = 0; i < length; ++i) {
                JSONObject attr = attributes.optJSONObject(i);
                if (attr == null) continue;
                results.add(attr.getString("name"));
                if (ValueType.fromName(attr.getString("value_type")) != ValueType.STRING) continue;
                results.add(attr.optString("data"));
            }
        }
        if ((childElements = elementJson.optJSONArray(ResXmlElement.NAME_childes)) != null) {
            int length = childElements.length();
            for (int i = 0; i < length; ++i) {
                this.recursiveStrings(childElements.getJSONObject(i), results);
            }
        }
    }

    void addEvents(ParserEventList parserEventList) {
        ResXmlElement xmlElement = this.getDocumentElement();
        parserEventList.add(new ParserEvent(0, xmlElement));
        Iterator<ResXmlElement> iterator = this.getElements();
        while (iterator.hasNext()) {
            ResXmlElement element = iterator.next();
            element.addEvents(parserEventList);
        }
        parserEventList.add(new ParserEvent(1, xmlElement));
    }

    public static boolean isResXmlBlock(File file) {
        if (file == null) {
            return false;
        }
        try {
            InfoHeader infoHeader = InfoHeader.readHeaderBlock(file);
            return ResXmlDocument.isResXmlBlock(infoHeader);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(InputSource inputSource) {
        boolean result = false;
        try {
            InputStream inputStream = inputSource.openStream();
            result = ResXmlDocument.isResXmlBlock(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isResXmlBlock(InputStream inputStream) {
        try {
            InfoHeader headerBlock = BlockReader.readHeaderBlock(inputStream);
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(byte[] bytes) {
        try {
            InfoHeader headerBlock = BlockReader.readHeaderBlock(bytes);
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(BlockReader blockReader) {
        if (blockReader == null) {
            return false;
        }
        try {
            InfoHeader headerBlock = blockReader.readHeaderBlock();
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(HeaderBlock headerBlock) {
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        return chunkType == ChunkType.XML;
    }
}

