/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.coder.XmlSanitizer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ReferenceBlock;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.attribute.AttributeBag;
import com.reandroid.common.Namespace;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlAttribute
extends AttributeValue
implements Comparable<ResXmlAttribute> {
    private ReferenceItem mNSReference;
    private ReferenceItem mNameReference;
    private ReferenceItem mNameIdReference;
    private ReferenceItem mValueStringReference;
    private ResXmlStartNamespace mLinkedNamespace;
    public static final String NAME_id = "id";
    public static final String NAME_name = "name";
    public static final String NAME_namespace_uri = "namespace_uri";
    private static final int OFFSET_NS = 0;
    private static final int OFFSET_NAME = 4;
    private static final int OFFSET_STRING = 8;
    private static final int OFFSET_SIZE = 12;

    public ResXmlAttribute(int attributeUnitSize) {
        super(attributeUnitSize, 12);
        byte[] bts = this.getBytesInternal();
        ResXmlAttribute.putInteger(bts, 0, -1);
        ResXmlAttribute.putInteger(bts, 4, -1);
        ResXmlAttribute.putInteger(bts, 8, -1);
    }

    public ResXmlAttribute() {
        this(20);
    }

    public boolean autoSetNamespace() {
        return this.autoSetNamespace(true);
    }

    public boolean autoSetNamespace(boolean removeNoIdPrefix) {
        if (this.getNameId() == 0) {
            String uri;
            if (!(!removeNoIdPrefix || Namespace.isExternalUri(uri = this.getUri()) && Namespace.isValidUri(uri) && Namespace.isValidPrefix(this.getPrefix()))) {
                return this.setNamespace(null, null);
            }
            return false;
        }
        return this.autoSetNamespace(this.resolveName());
    }

    public boolean autoSetName() {
        return this.autoSetName(true);
    }

    public boolean autoSetName(boolean removeNoIdPrefix) {
        int nameId = this.getNameId();
        if (nameId == 0) {
            String uri;
            if (!(!removeNoIdPrefix || Namespace.isExternalUri(uri = this.getUri()) && Namespace.isValidUri(uri) && Namespace.isValidPrefix(this.getPrefix()))) {
                return this.setNamespace(null, null);
            }
            return false;
        }
        ResourceEntry nameEntry = this.resolveName();
        if (nameEntry == null || nameEntry.isEmpty()) {
            return false;
        }
        String name = nameEntry.getName();
        if (name == null) {
            return false;
        }
        boolean nsChanged = this.autoSetNamespace(nameEntry);
        String nameOld = this.getName();
        this.setName(name, nameId);
        return nsChanged || Objects.equals(nameOld, name);
    }

    private boolean autoSetNamespace(ResourceEntry nameEntry) {
        if (nameEntry == null) {
            return false;
        }
        PackageBlock packageBlock = nameEntry.getPackageBlock();
        String prefix = this.getPrefix();
        String uri = this.getUri();
        String packageName = packageBlock.getName();
        if (!packageBlock.isMultiPackage() && Namespace.isValidPrefix(prefix, packageName) && Namespace.isValidUri(uri, packageName)) {
            return false;
        }
        prefix = packageBlock.getPrefix();
        uri = packageBlock.getUri();
        return this.setNamespace(uri, prefix);
    }

    @Override
    public boolean isUndefined() {
        return this.getNameReference() < 0;
    }

    public String getUri() {
        return this.getString(this.getNamespaceReference());
    }

    public boolean equalsName(String name) {
        if (name == null) {
            return this.getName() == null;
        }
        String prefix = XMLUtil.splitPrefix(name);
        if (prefix != null && !prefix.equals(this.getPrefix())) {
            return false;
        }
        return name.equals(this.getName());
    }

    public String getName(boolean includePrefix) {
        String name = this.getName();
        if (name == null || !includePrefix) {
            return name;
        }
        String prefix = this.getPrefix();
        if (prefix == null) {
            return name;
        }
        return prefix + ":" + name;
    }

    public String getName() {
        return this.getString(this.getNameReference());
    }

    @Override
    public String decodePrefix() {
        int resourceId = this.getNameId();
        String prefix = this.getPrefix();
        if (resourceId == 0) {
            if (Namespace.isValidPrefix(prefix) && Namespace.isExternalUri(this.getUri())) {
                return prefix;
            }
            return null;
        }
        ResourceEntry resourceEntry = this.resolveName();
        if (resourceEntry != null) {
            PackageBlock packageBlock = resourceEntry.getPackageBlock();
            if (packageBlock.isMultiPackage() || !Namespace.isValidPrefix(prefix, packageBlock.getName())) {
                prefix = packageBlock.getPrefix();
            }
        } else {
            prefix = Namespace.prefixForResourceId(resourceId);
        }
        return prefix;
    }

    public String decodeUri() {
        String uri = this.getUri();
        int resourceId = this.getNameId();
        if (resourceId == 0) {
            if (!Namespace.isExternalUri(uri)) {
                uri = null;
            }
            return uri;
        }
        ResourceEntry resourceEntry = this.resolveName();
        if (!Namespace.isValidUri(uri, resourceId)) {
            uri = resourceEntry == null ? Namespace.uriForResourceId(resourceId) : resourceEntry.getPackageBlock().getUri();
        }
        return uri;
    }

    @Override
    public String decodeName(boolean includePrefix) {
        String prefix;
        int resourceId = this.getNameId();
        if (resourceId == 0) {
            String name = this.getName(false);
            if (!includePrefix) {
                return name;
            }
            String prefix2 = this.decodePrefix();
            if (prefix2 == null) {
                return name;
            }
            return prefix2 + ":" + name;
        }
        ResourceEntry resourceEntry = this.resolveName();
        if (resourceEntry == null || !resourceEntry.isDeclared()) {
            String prefix3;
            String name = ValueCoder.decodeUnknownNameId(resourceId);
            if (includePrefix && (prefix3 = this.decodePrefix()) != null) {
                name = prefix3 + ":" + name;
            }
            return name;
        }
        String name = resourceEntry.getName();
        if (includePrefix && name != null && (prefix = this.decodePrefix()) != null) {
            name = prefix + ":" + name;
        }
        return name;
    }

    public String getPrefix() {
        ResXmlStartNamespace namespace = this.getStartNamespace();
        if (namespace != null) {
            return namespace.getPrefix();
        }
        return null;
    }

    @Deprecated
    public String getNamePrefix() {
        return this.getPrefix();
    }

    public ResXmlNamespace getNamespace() {
        return this.getStartNamespace();
    }

    public void setNamespace(Namespace namespace) {
        if (namespace != null) {
            this.setNamespace(namespace.getUri(), namespace.getPrefix());
        } else {
            this.setNamespace(null, null);
        }
    }

    public String getValueString() {
        return this.getString(this.getValueStringReference());
    }

    @Override
    public int getNameId() {
        ResXmlID xmlID = this.getResXmlID();
        if (xmlID != null) {
            return xmlID.get();
        }
        return 0;
    }

    @Override
    public void setNameId(int resourceId) {
        ResXmlIDMap xmlIDMap = this.getResXmlIDMap();
        if (xmlIDMap == null) {
            return;
        }
        ResXmlID xmlID = xmlIDMap.getOrCreate(resourceId);
        this.setNameReference(xmlID.getIndex());
    }

    @Override
    public void setName(String name, int resourceId) {
        if (ObjectsUtil.equals(name, this.getName()) && resourceId == this.getNameId()) {
            return;
        }
        this.unlink(this.mNameReference);
        this.unLinkNameId(this.getResXmlID());
        ResXmlString xmlString = this.getOrCreateAttributeName(name, resourceId);
        if (xmlString == null) {
            return;
        }
        this.setNameReference(xmlString.getIndex());
        this.mNameReference = this.link(4);
        this.linkNameId();
    }

    private void linkStartNameSpace() {
        this.unLinkStartNameSpace();
        ResXmlStartNamespace startNamespace = this.getStartNamespace();
        if (startNamespace == null) {
            return;
        }
        this.mLinkedNamespace = startNamespace;
        startNamespace.addAttributeReference(this);
    }

    private void unLinkStartNameSpace() {
        ResXmlStartNamespace namespace = this.mLinkedNamespace;
        if (namespace == null) {
            return;
        }
        this.mLinkedNamespace = null;
        namespace.removeAttributeReference(this);
    }

    private ResXmlStartNamespace getStartNamespace() {
        int uriRef = this.getNamespaceReference();
        if (uriRef < 0) {
            return null;
        }
        ResXmlStartNamespace namespace = this.mLinkedNamespace;
        if (namespace != null && namespace.getUriReference() == uriRef) {
            return namespace;
        }
        ResXmlElement parentElement = this.getParentElement();
        if (parentElement != null) {
            return parentElement.getStartNamespaceByUriRef(uriRef);
        }
        return null;
    }

    private ResXmlString getOrCreateAttributeName(String name, int resourceId) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        return stringPool.getOrCreateAttribute(resourceId, name);
    }

    public boolean removeSelf() {
        ResXmlElement parent = this.getParentElement();
        if (parent != null) {
            return parent.removeAttribute(this);
        }
        return false;
    }

    public ResXmlElement getParentElement() {
        return this.getParent(ResXmlElement.class);
    }

    @Deprecated
    public ResXmlElement getParentResXmlElement() {
        return this.getParent(ResXmlElement.class);
    }

    public int getAttributesUnitSize() {
        return 12 + super.getSize();
    }

    public void setAttributesUnitSize(int size) {
        int eight = size - 12;
        super.setSize(eight);
    }

    private String getString(int ref) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        StringItem stringItem = this.getStringItem(ref);
        if (stringItem == null) {
            return null;
        }
        return stringItem.getHtml();
    }

    private StringItem getStringItem(int ref) {
        if (ref < 0) {
            return null;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        return stringPool.get(ref);
    }

    private ResXmlID getResXmlID() {
        ResXmlIDMap xmlIDMap = this.getResXmlIDMap();
        if (xmlIDMap == null) {
            return null;
        }
        return (ResXmlID)xmlIDMap.getResXmlIDArray().get(this.getNameReference());
    }

    private ResXmlIDMap getResXmlIDMap() {
        ResXmlElement xmlElement = this.getParentElement();
        if (xmlElement != null) {
            return xmlElement.getResXmlIDMap();
        }
        return null;
    }

    int getNamespaceReference() {
        return ResXmlAttribute.getInteger(this.getBytesInternal(), 0);
    }

    public boolean setNamespace(String uri, String prefix) {
        uri = StringsUtil.emptyToNull(uri);
        prefix = StringsUtil.emptyToNull(prefix);
        if (uri == null && prefix == null) {
            return this.setNamespaceReference(-1);
        }
        ResXmlElement parentElement = this.getParentElement();
        if (parentElement == null) {
            return false;
        }
        ResXmlNamespace namespace = uri != null && prefix != null ? parentElement.getOrCreateNamespace(uri, prefix) : (uri != null ? parentElement.getStartNamespaceByUri(uri) : parentElement.getNamespaceByPrefix(prefix));
        if (namespace == null) {
            return false;
        }
        return this.setNamespaceReference(namespace.getUriReference());
    }

    public boolean setNamespaceReference(int ref) {
        if (ref == this.getNamespaceReference()) {
            return false;
        }
        this.setUriReference(ref);
        this.linkStartNameSpace();
        return true;
    }

    void setUriReference(int ref) {
        StringItem stringItem = this.getStringItem(this.getNamespaceReference());
        ResXmlAttribute.putInteger(this.getBytesInternal(), 0, ref);
        if (stringItem != null) {
            stringItem.removeReference(this.mNSReference);
        }
        this.mNSReference = this.link(0);
    }

    int getNameReference() {
        return ResXmlAttribute.getInteger(this.getBytesInternal(), 4);
    }

    void setNameReference(int ref) {
        if (ref == this.getNameReference()) {
            return;
        }
        this.unLinkNameId(this.getResXmlID());
        this.unlink(this.mNameReference);
        ResXmlAttribute.putInteger(this.getBytesInternal(), 4, ref);
        this.mNameReference = this.link(4);
        this.linkNameId();
    }

    int getValueStringReference() {
        return ResXmlAttribute.getInteger(this.getBytesInternal(), 8);
    }

    void setValueStringReference(int ref) {
        if (ref == this.getValueStringReference() && this.mValueStringReference != null) {
            return;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        Object stringItem = stringPool.get(ref);
        this.unlink(this.mValueStringReference);
        if (stringItem != null) {
            ref = ((Block)stringItem).getIndex();
        }
        ResXmlAttribute.putInteger(this.getBytesInternal(), 8, ref);
        ReferenceBlock<ResXmlAttribute> referenceItem = null;
        if (stringItem != null) {
            referenceItem = new ReferenceBlock<ResXmlAttribute>(this, 8);
            ((StringItem)stringItem).addReference(referenceItem);
        }
        this.mValueStringReference = referenceItem;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        super.onDataLoaded();
        this.linkAll();
        this.linkStartNameSpace();
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.unLinkStartNameSpace();
        this.unlinkAll();
    }

    @Override
    protected void onUnlinkDataString(ReferenceItem referenceItem) {
        this.unlink(referenceItem);
    }

    @Override
    protected void onDataChanged() {
        if (this.getValueType() == ValueType.STRING) {
            this.setValueStringReference(this.getData());
        } else {
            this.setValueStringReference(-1);
        }
    }

    @Override
    public ResXmlDocument getParentChunk() {
        ResXmlElement element = this.getParentElement();
        if (element != null) {
            return element.getParentDocument();
        }
        return null;
    }

    private void linkNameId() {
        ResXmlID xmlID = this.getResXmlID();
        if (xmlID == null) {
            return;
        }
        this.unLinkNameId(xmlID);
        ReferenceBlock<ResXmlAttribute> referenceItem = new ReferenceBlock<ResXmlAttribute>(this, 4);
        xmlID.addReference(referenceItem);
        this.mNameIdReference = referenceItem;
    }

    private void unLinkNameId(ResXmlID xmlID) {
        ReferenceItem referenceItem = this.mNameIdReference;
        if (referenceItem == null || xmlID == null) {
            return;
        }
        xmlID.removeReference(referenceItem);
        this.mNameIdReference = null;
        if (xmlID.hasReference()) {
            return;
        }
        ResXmlIDMap xmlIDMap = this.getResXmlIDMap();
        if (xmlIDMap == null) {
            return;
        }
        xmlIDMap.removeSafely(xmlID);
    }

    private void linkAll() {
        this.unlink(this.mNSReference);
        this.mNSReference = this.link(0);
        this.unlink(this.mNameReference);
        this.mNameReference = this.link(4);
        this.unlink(this.mValueStringReference);
        this.mValueStringReference = this.link(8);
        this.linkNameId();
    }

    private void unlinkAll() {
        this.unlink(this.mNSReference);
        this.unlink(this.mNameReference);
        this.unlink(this.mValueStringReference);
        this.mNSReference = null;
        this.mNameReference = null;
        this.mValueStringReference = null;
        this.unLinkNameId(this.getResXmlID());
    }

    private ReferenceItem link(int offset) {
        if (offset < 0) {
            return null;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        int ref = ResXmlAttribute.getInteger(this.getBytesInternal(), offset);
        Object stringItem = stringPool.get(ref);
        if (stringItem == null) {
            return null;
        }
        ReferenceBlock<ResXmlAttribute> referenceItem = new ReferenceBlock<ResXmlAttribute>(this, offset);
        ((StringItem)stringItem).addReference(referenceItem);
        return referenceItem;
    }

    private void unlink(ReferenceItem reference) {
        if (reference == null) {
            return;
        }
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        stringPool.removeReference(reference);
    }

    public ResXmlStringPool getStringPool() {
        StringPool<?> stringPool = super.getStringPool();
        if (stringPool instanceof ResXmlStringPool) {
            return (ResXmlStringPool)stringPool;
        }
        return null;
    }

    @Override
    public void mergeWithName(ResourceMergeOption mergeOption, ValueItem valueItem) {
        super.mergeWithName(mergeOption, valueItem);
        ResXmlAttribute attribute = (ResXmlAttribute)valueItem;
        this.setNamespace(attribute.getNamespace());
    }

    @Override
    public int compareTo(ResXmlAttribute other) {
        String name2;
        int id1 = this.getNameId();
        int id2 = other.getNameId();
        if (id1 == 0 && id2 != 0) {
            return 1;
        }
        if (id2 == 0 && id1 != 0) {
            return -1;
        }
        if (id1 != 0) {
            return Integer.compare(id1, id2);
        }
        String name1 = this.getName();
        if (name1 == null) {
            name1 = "";
        }
        if ((name2 = other.getName()) == null) {
            name2 = "";
        }
        return name1.compareTo(name2);
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        this.serialize(serializer, true);
    }

    public void serialize(XmlSerializer serializer, boolean decode) throws IOException {
        String value;
        if (this.getValueType() == ValueType.STRING) {
            value = XmlSanitizer.escapeSpecialCharacter(this.getValueAsString());
            if (this.getNameId() == 0 || this.resolveName() == null) {
                value = XmlSanitizer.escapeDecodedValue(value);
            }
        } else {
            value = this.decodeValue(decode);
        }
        String name = decode ? this.decodeName(false) : this.getName(false);
        String uri = decode ? this.decodeUri() : this.getUri();
        serializer.attribute(uri, name, value);
    }

    public ResourceEntry encodeAttributeName(String uri, String prefix, String name) throws IOException {
        this.setNamespace(uri, prefix);
        if (!Namespace.isValidUri(uri) || Namespace.isExternalUri(uri)) {
            this.setName(name, 0);
            return null;
        }
        ResourceEntry resourceEntry = super.encodeAttrName(prefix, name);
        if (resourceEntry != null) {
            return resourceEntry;
        }
        if ((prefix = StringsUtil.emptyToNull(prefix)) == null) {
            this.setName(name, 0);
            return null;
        }
        throw new IOException("Unknown attribute name '" + prefix + ":" + name + "'");
    }

    public void encode(boolean validate, String uri, String prefix, String name, String value) throws IOException {
        ResourceEntry nameResource = this.encodeAttributeName(uri, prefix, name);
        EncodeResult encodeResult = super.encodeStyleValue(validate, nameResource, value);
        if (encodeResult.isError()) {
            throw new IOException(this.buildErrorMessage(encodeResult.getError(), value));
        }
    }

    public void encode(String uri, String prefix, String name, String value, boolean validate) throws IOException {
        ResourceEntry attrResource = this.encodeAttributeName(uri, prefix, name);
        EncodeResult encodeResult = ValueCoder.encodeReference(this.getPackageBlock(), value);
        if (encodeResult != null) {
            if (encodeResult.isError()) {
                throw new IOException(this.buildErrorMessage(encodeResult.getError(), value));
            }
            this.setValue(encodeResult);
            return;
        }
        if (attrResource != null) {
            attrResource = attrResource.resolveReference();
        }
        if (attrResource == null || attrResource.isEmpty()) {
            encodeResult = ValueCoder.encode(value);
            if (encodeResult != null) {
                this.setValue(encodeResult);
            } else {
                this.setValueAsString(XmlSanitizer.unEscapeSpecialCharacter(value));
            }
            return;
        }
        AttributeBag attributeBag = AttributeBag.create(attrResource.get());
        encodeResult = attributeBag.encode(value);
        if (encodeResult != null) {
            if (encodeResult.valueType == ValueType.STRING) {
                this.setValueAsString(XmlSanitizer.unEscapeSpecialCharacter(value));
                return;
            }
            if (encodeResult.isError()) {
                if (validate) {
                    throw new IOException(this.buildErrorMessage(encodeResult.getError(), value));
                }
                this.logEncodeError(encodeResult, value);
            } else {
                this.setValue(encodeResult);
                return;
            }
        }
        if ((encodeResult = ValueCoder.encode(value)) != null) {
            this.setValue(encodeResult);
            return;
        }
        this.setValueAsString(XmlSanitizer.unEscapeSpecialCharacter(value));
    }

    private void logEncodeError(EncodeResult error, String value) {
        System.out.println(this.buildErrorMessage(error.getError(), value));
    }

    private String buildErrorMessage(String msg, String value) {
        ResXmlElement parent = this.getParentElement();
        return msg + ", at line = " + parent.getStartLineNumber() + ", <" + parent.getName(true) + " " + this.getName(true) + "=\"" + value + "\"";
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_name, this.getName());
        jsonObject.put(NAME_id, this.getNameId());
        jsonObject.put(NAME_namespace_uri, this.getUri());
        ValueType valueType = this.getValueType();
        jsonObject.put("value_type", valueType.name());
        if (valueType == ValueType.STRING) {
            jsonObject.put("data", this.getValueAsString());
        } else if (valueType == ValueType.BOOLEAN) {
            jsonObject.put("data", this.getValueAsBoolean());
        } else {
            jsonObject.put("data", this.getData());
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        ValueType valueType;
        String name = json.optString(NAME_name, "");
        int id = json.optInt(NAME_id, 0);
        this.setName(name, id);
        String uri = json.optString(NAME_namespace_uri, null);
        if (uri != null) {
            ResXmlNamespace ns = this.getParentElement().getStartNamespaceByUri(uri);
            if (ns == null) {
                ns = this.getParentElement().getRootElement().getOrCreateNamespace(uri, "");
            }
            this.setNamespaceReference(ns.getUriReference());
        }
        if ((valueType = ValueType.fromName(json.getString("value_type"))) == ValueType.STRING) {
            this.setValueAsString(json.optString("data", ""));
        } else if (valueType == ValueType.BOOLEAN) {
            this.setValueAsBoolean(json.getBoolean("data"));
        } else {
            this.setValueType(valueType);
            this.setData(json.getInt("data"));
        }
    }

    public XMLAttribute decodeToXml() {
        return this.toXml(true);
    }

    public XMLAttribute toXml() {
        return this.toXml(false);
    }

    public XMLAttribute toXml(boolean decode) {
        if (decode) {
            return new XMLAttribute(this.decodeName(false), this.decodeValue());
        }
        return new XMLAttribute(this.getName(false), this.decodeValue(false));
    }

    @Override
    public String toString() {
        String fullName = this.getName(true);
        if (fullName != null) {
            ValueType valueType;
            String valStr;
            int id = this.getNameId();
            if (id != 0) {
                fullName = fullName + "(@" + HexUtil.toHex8(id) + ")";
            }
            if ((valStr = (valueType = this.getValueType()) == ValueType.STRING ? this.getValueAsString() : (valueType == ValueType.BOOLEAN ? String.valueOf(this.getValueAsBoolean()) : (valueType == ValueType.DEC ? String.valueOf(this.getData()) : "[" + (Object)((Object)valueType) + "] " + HexUtil.toHex8(this.getData())))) != null) {
                return fullName + "=\"" + valStr + "\"";
            }
            return fullName + "[" + (Object)((Object)valueType) + "]=\"" + this.getData() + "\"";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": ");
        builder.append(this.getIndex());
        builder.append("{NamespaceReference=").append(this.getNamespaceReference());
        builder.append(", NameReference=").append(this.getNameReference());
        builder.append(", ValueStringReference=").append(this.getValueStringReference());
        builder.append(", ValueSize=").append(this.getSize());
        builder.append(", ValueTypeByte=").append(this.getType() & 0xFF);
        builder.append(", Data=").append(this.getData());
        builder.append("}");
        return builder.toString();
    }
}

