/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.array.StagedAliasEntryArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.header.StagedAliasHeader;
import com.reandroid.arsc.value.StagedAliasEntry;
import java.util.Collection;

public class StagedAlias
extends Chunk<StagedAliasHeader> {
    private final StagedAliasEntryArray stagedAliasEntryArray;

    public StagedAlias() {
        super(new StagedAliasHeader(), 1);
        StagedAliasHeader header = (StagedAliasHeader)this.getHeaderBlock();
        this.stagedAliasEntryArray = new StagedAliasEntryArray(header.getCountItem());
        this.addChild(this.stagedAliasEntryArray);
    }

    public StagedAliasEntry searchByStagedResId(int stagedResId) {
        return this.getStagedAliasEntryArray().searchByStagedResId(stagedResId);
    }

    public void merge(StagedAlias stagedAlias) {
        if (stagedAlias == null || stagedAlias == this) {
            return;
        }
        StagedAliasEntryArray exist = this.getStagedAliasEntryArray();
        for (StagedAliasEntry entry : stagedAlias.listStagedAliasEntry()) {
            if (exist.contains(entry)) continue;
            exist.add(entry);
        }
    }

    public StagedAliasEntryArray getStagedAliasEntryArray() {
        return this.stagedAliasEntryArray;
    }

    public Collection<StagedAliasEntry> listStagedAliasEntry() {
        return this.getStagedAliasEntryArray().listItems();
    }

    public int getStagedAliasEntryCount() {
        return this.getStagedAliasEntryArray().size();
    }

    @Override
    public boolean isNull() {
        return this.getStagedAliasEntryCount() == 0;
    }

    @Override
    protected void onChunkRefreshed() {
        ((StagedAliasHeader)this.getHeaderBlock()).getCountItem().set(this.getStagedAliasEntryCount());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": count=" + this.getStagedAliasEntryCount();
    }

    public static StagedAlias mergeAll(Collection<StagedAlias> stagedAliasList) {
        if (stagedAliasList.size() == 0) {
            return null;
        }
        StagedAlias result = new StagedAlias();
        for (StagedAlias stagedAlias : stagedAliasList) {
            if (stagedAlias.isNull()) continue;
            result.merge(stagedAlias);
        }
        if (!result.isNull()) {
            result.refresh();
            return result;
        }
        return null;
    }
}

