/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.header.OverlayablePolicyHeader;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerArrayBlock;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.util.Collection;

public class OverlayablePolicy
extends Chunk<OverlayablePolicyHeader>
implements BlockLoad,
JSONConvert<JSONObject> {
    private final IntegerArrayBlock tableRefArray = new IntegerArrayBlock();
    public static final String NAME_flags = "flags";
    public static final String NAME_references = "references";

    public OverlayablePolicy() {
        super(new OverlayablePolicyHeader(), 1);
        this.addChild(this.tableRefArray);
        ((OverlayablePolicyHeader)this.getHeaderBlock()).getEntryCount().setBlockLoad(this);
    }

    @Override
    public boolean isNull() {
        return this.getTableReferenceCount() == 0;
    }

    public int getTableReferenceCount() {
        return this.getTableRefArray().size();
    }

    public Collection<Integer> listTableReferences() {
        return this.getTableRefArray().toList();
    }

    public IntegerArrayBlock getTableRefArray() {
        return this.tableRefArray;
    }

    public int getFlags() {
        return ((OverlayablePolicyHeader)this.getHeaderBlock()).getFlags().get();
    }

    public void setFlags(int flags) {
        ((OverlayablePolicyHeader)this.getHeaderBlock()).getFlags().set(flags);
    }

    public void setFlags(PolicyFlag[] policyFlags) {
        this.setFlags(PolicyFlag.sum(policyFlags));
    }

    public void addFlag(PolicyFlag policyFlag) {
        int i = policyFlag == null ? 0 : policyFlag.getFlagValue();
        this.setFlags(this.getFlags() | i);
    }

    public PolicyFlag[] getPolicyFlags() {
        return PolicyFlag.valuesOf(this.getFlags());
    }

    @Override
    protected void onChunkRefreshed() {
        ((OverlayablePolicyHeader)this.getHeaderBlock()).getEntryCount().set(this.getTableRefArray().size());
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        IntegerItem entryCount = ((OverlayablePolicyHeader)this.getHeaderBlock()).getEntryCount();
        if (sender == entryCount) {
            this.tableRefArray.setSize(entryCount.get());
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_flags, this.getFlags());
        JSONArray jsonArray = new JSONArray();
        for (Integer reference : this.listTableReferences()) {
            jsonArray.put(reference);
        }
        jsonObject.put(NAME_references, jsonArray);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setFlags(json.getInt(NAME_flags));
        JSONArray jsonArray = json.getJSONArray(NAME_references);
        IntegerArrayBlock integerArrayBlock = this.getTableRefArray();
        int length = jsonArray.length();
        integerArrayBlock.setSize(length);
        for (int i = 0; i < length; ++i) {
            integerArrayBlock.put(i, jsonArray.getInt(i));
        }
    }

    public void merge(OverlayablePolicy policy) {
        if (policy == null || policy == this) {
            return;
        }
        this.setFlags(policy.getFlags());
        IntegerArrayBlock exist = this.getTableRefArray();
        IntegerArrayBlock coming = policy.getTableRefArray();
        for (int reference : coming.toArray()) {
            if (exist.contains(reference)) continue;
            exist.add(reference);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": flags=" + PolicyFlag.toString(this.getPolicyFlags()) + "', count=" + this.getTableReferenceCount();
    }

    public static enum PolicyFlag {
        PUBLIC(1),
        SYSTEM_PARTITION(2),
        VENDOR_PARTITION(4),
        PRODUCT_PARTITION(8),
        SIGNATURE(16),
        ODM_PARTITION(32),
        OEM_PARTITION(64),
        ACTOR_SIGNATURE(128),
        CONFIG_SIGNATURE(256);

        private final int flag;

        private PolicyFlag(int flag) {
            this.flag = flag;
        }

        public int getFlagValue() {
            return this.flag;
        }

        public boolean contains(int flagsValue) {
            return (this.flag & flagsValue) == this.flag;
        }

        public static PolicyFlag[] valuesOf(int flagValue) {
            if (flagValue == 0) {
                return null;
            }
            PolicyFlag[] values = PolicyFlag.values();
            PolicyFlag[] tmp = new PolicyFlag[values.length];
            int count = 0;
            for (int i = 0; i < values.length; ++i) {
                PolicyFlag flags = values[i];
                if ((flags.getFlagValue() & flagValue) != flags.getFlagValue()) continue;
                tmp[i] = flags;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            if (count == tmp.length) {
                return tmp;
            }
            PolicyFlag[] results = new PolicyFlag[count];
            int j = 0;
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i] == null) continue;
                results[j] = tmp[i];
                ++j;
            }
            return results;
        }

        public static int sum(PolicyFlag[] flagsList) {
            if (flagsList == null || flagsList.length == 0) {
                return 0;
            }
            int results = 0;
            for (PolicyFlag flags : flagsList) {
                if (flags == null) continue;
                results |= flags.getFlagValue();
            }
            return results;
        }

        public static boolean contains(PolicyFlag[] flagsList, PolicyFlag policyFlag) {
            if (flagsList == null || flagsList.length == 0) {
                return policyFlag == null;
            }
            if (policyFlag == null) {
                return false;
            }
            for (PolicyFlag flags : flagsList) {
                if (!policyFlag.equals((Object)flags)) continue;
                return true;
            }
            return false;
        }

        public static String toString(PolicyFlag[] flagsList) {
            if (flagsList == null || flagsList.length == 0) {
                return "NONE";
            }
            StringBuilder builder = new StringBuilder();
            boolean appendOnce = false;
            for (PolicyFlag flags : flagsList) {
                if (flags == null) continue;
                if (appendOnce) {
                    builder.append('|');
                }
                builder.append(flags.name());
                appendOnce = true;
            }
            if (appendOnce) {
                return builder.toString();
            }
            return "NONE";
        }

        public static PolicyFlag[] valuesOf(String flagsString) {
            if (flagsString == null) {
                return null;
            }
            flagsString = flagsString.trim().toUpperCase();
            String[] namesList = flagsString.split("\\s*\\|\\s*");
            PolicyFlag[] tmp = new PolicyFlag[namesList.length];
            int count = 0;
            for (int i = 0; i < namesList.length; ++i) {
                PolicyFlag flags = PolicyFlag.nameOf(namesList[i]);
                if (flags == null) continue;
                tmp[i] = flags;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            if (count == tmp.length) {
                return tmp;
            }
            PolicyFlag[] results = new PolicyFlag[count];
            int j = 0;
            for (int i = 0; i < tmp.length; ++i) {
                if (tmp[i] == null) continue;
                results[j] = tmp[i];
                ++j;
            }
            return results;
        }

        public static PolicyFlag nameOf(String name) {
            if (name == null) {
                return null;
            }
            name = name.trim().toUpperCase();
            for (PolicyFlag flags : PolicyFlag.values()) {
                if (!name.equals(flags.name())) continue;
                return flags;
            }
            return null;
        }
    }
}

