/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.OverlayablePolicy;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.OverlayableHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.util.List;

public class Overlayable
extends Chunk<OverlayableHeader>
implements JSONConvert<JSONObject> {
    private final BlockList<OverlayablePolicy> policyList = new BlockList();
    private final ByteArray extraBytes = new ByteArray();
    public static final String NAME_name = "name";
    public static final String NAME_actor = "actor";
    public static final String NAME_policies = "policies";

    public Overlayable() {
        super(new OverlayableHeader(), 2);
        this.addChild(this.policyList);
        this.addChild(this.extraBytes);
    }

    public OverlayablePolicy get(int flags) {
        for (OverlayablePolicy policy : this.listOverlayablePolicies()) {
            if (flags != policy.getFlags()) continue;
            return policy;
        }
        return null;
    }

    public void addOverlayablePolicy(OverlayablePolicy overlayablePolicy) {
        this.policyList.add(overlayablePolicy);
    }

    public List<OverlayablePolicy> listOverlayablePolicies() {
        return this.policyList.getChildes();
    }

    public ByteArray getExtraBytes() {
        return this.extraBytes;
    }

    public String getName() {
        return ((OverlayableHeader)this.getHeaderBlock()).getName().get();
    }

    public void setName(String str) {
        ((OverlayableHeader)this.getHeaderBlock()).getName().set(str);
    }

    public String getActor() {
        return ((OverlayableHeader)this.getHeaderBlock()).getActor().get();
    }

    public void setActor(String str) {
        ((OverlayableHeader)this.getHeaderBlock()).getActor().set(str);
    }

    @Override
    protected void onChunkRefreshed() {
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        this.checkInvalidChunk(headerBlock);
        int size = headerBlock.getChunkSize();
        BlockReader chunkReader = reader.create(size);
        headerBlock = this.getHeaderBlock();
        headerBlock.readBytes(chunkReader);
        this.readOverlayablePlolicies(chunkReader);
        this.readExtraBytes(chunkReader);
        reader.offset(size);
        chunkReader.close();
        this.onChunkLoaded();
    }

    private void readOverlayablePlolicies(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        BlockList<OverlayablePolicy> policyList = this.policyList;
        while (headerBlock != null && headerBlock.getChunkType() == ChunkType.OVERLAYABLE_POLICY) {
            OverlayablePolicy policy = new OverlayablePolicy();
            policyList.add(policy);
            policy.readBytes(reader);
            headerBlock = reader.readHeaderBlock();
        }
    }

    private void readExtraBytes(BlockReader reader) throws IOException {
        int remaining = reader.available();
        this.extraBytes.setSize(remaining);
        this.extraBytes.readBytes(reader);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_name, this.getName());
        jsonObject.put(NAME_actor, this.getActor());
        JSONArray jsonArray = new JSONArray();
        for (OverlayablePolicy policy : this.listOverlayablePolicies()) {
            jsonArray.put(policy.toJson());
        }
        jsonObject.put(NAME_policies, jsonArray);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setName(json.optString(NAME_name));
        this.setActor(json.optString(NAME_actor));
        JSONArray jsonArray = json.getJSONArray(NAME_policies);
        int length = jsonArray.length();
        BlockList<OverlayablePolicy> policyList = this.policyList;
        for (int i = 0; i < length; ++i) {
            OverlayablePolicy policy = new OverlayablePolicy();
            policyList.add(policy);
            policy.fromJson(jsonArray.getJSONObject(i));
        }
    }

    public void merge(Overlayable overlayable) {
        if (overlayable == null || overlayable == this) {
            return;
        }
        this.setName(overlayable.getName());
        this.setActor(overlayable.getActor());
        for (OverlayablePolicy policy : overlayable.listOverlayablePolicies()) {
            OverlayablePolicy exist = this.get(policy.getFlags());
            if (exist == null) {
                exist = new OverlayablePolicy();
                this.addOverlayablePolicy(exist);
            }
            exist.merge(policy);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": name='" + this.getName() + "', actor='" + this.getActor() + "', policies=" + this.policyList.size() + "', extra=" + this.getExtraBytes().size();
    }
}

