/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.array.LibraryInfoArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.header.LibraryHeader;
import com.reandroid.arsc.value.LibraryInfo;
import java.util.Collection;

public class LibraryBlock
extends Chunk<LibraryHeader> {
    private final LibraryInfoArray mLibraryInfoArray;

    public LibraryBlock() {
        super(new LibraryHeader(), 1);
        LibraryHeader header = (LibraryHeader)this.getHeaderBlock();
        this.mLibraryInfoArray = new LibraryInfoArray(header.getCountItem());
        this.addChild(this.mLibraryInfoArray);
    }

    public boolean containsLibraryInfo(String packageName) {
        if (this.isEmpty()) {
            return false;
        }
        return this.getLibraryInfoArray().containsLibraryInfo(packageName);
    }

    public boolean isEmpty() {
        return this.getLibraryCount() == 0;
    }

    public LibraryInfoArray getLibraryInfoArray() {
        return this.mLibraryInfoArray;
    }

    public void addLibraryInfo(LibraryBlock libraryBlock) {
        if (libraryBlock == null) {
            return;
        }
        for (LibraryInfo info : libraryBlock.getLibraryInfoArray().listItems()) {
            this.addLibraryInfo(info);
        }
    }

    public void addLibraryInfo(LibraryInfo info) {
        if (info == null) {
            return;
        }
        this.getLibraryInfoArray().add(info);
        ((LibraryHeader)this.getHeaderBlock()).getCountItem().set(this.mLibraryInfoArray.size());
    }

    public Collection<LibraryInfo> listLibraryInfo() {
        return this.getLibraryInfoArray().listItems();
    }

    @Override
    public boolean isNull() {
        return this.mLibraryInfoArray.size() == 0;
    }

    public int getLibraryCount() {
        return this.mLibraryInfoArray.size();
    }

    public void setLibraryCount(int count) {
        ((LibraryHeader)this.getHeaderBlock()).getCountItem().set(count);
        this.mLibraryInfoArray.setSize(count);
    }

    @Override
    protected void onChunkRefreshed() {
        ((LibraryHeader)this.getHeaderBlock()).getCountItem().set(this.mLibraryInfoArray.size());
    }

    public void merge(LibraryBlock libraryBlock) {
        if (libraryBlock == null || libraryBlock == this) {
            return;
        }
        this.getLibraryInfoArray().merge(libraryBlock.getLibraryInfoArray());
    }
}

