/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.container.ExpandableBlockContainer;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import java.io.IOException;

public abstract class Chunk<T extends HeaderBlock>
extends ExpandableBlockContainer {
    private final T mHeaderBlock;
    protected final SingleBlockContainer<Block> firstPlaceHolder;

    protected Chunk(T headerBlock, int initialChildesCount) {
        super(initialChildesCount + 2);
        this.mHeaderBlock = headerBlock;
        this.firstPlaceHolder = new SingleBlockContainer();
        this.addChild((Block)headerBlock);
        this.addChild(this.firstPlaceHolder);
    }

    public SingleBlockContainer<Block> getFirstPlaceHolder() {
        return this.firstPlaceHolder;
    }

    void setHeaderLoaded(HeaderBlock.HeaderLoaded headerLoaded) {
        ((HeaderBlock)this.getHeaderBlock()).setHeaderLoaded(headerLoaded);
    }

    public final T getHeaderBlock() {
        return this.mHeaderBlock;
    }

    @Override
    protected final void onRefreshed() {
        ((HeaderBlock)this.getHeaderBlock()).refreshHeader();
        this.onChunkRefreshed();
    }

    protected abstract void onChunkRefreshed();

    public void onChunkLoaded() {
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        this.checkInvalidChunk(headerBlock);
        BlockReader chunkReader = reader.create(headerBlock.getChunkSize());
        this.onReadChildes(chunkReader);
        reader.offset(headerBlock.getChunkSize());
        chunkReader.close();
        this.onChunkLoaded();
    }

    protected void onReadChildes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
    }

    void checkInvalidChunk(HeaderBlock headerBlock) throws IOException {
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == null || chunkType == ChunkType.NULL) {
            throw new IOException("Invalid chunk: " + headerBlock);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": ");
        builder.append(this.getHeaderBlock());
        return builder.toString();
    }
}

